/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Supports;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;
import org.duckiee2.Trust.TrustManager;

public class Fire
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;
    private final TrustManager trustManager;

    public Fire(Infuse plugin, InfuseManager infuse, TrustManager trustManager) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.trustManager = trustManager;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getSecondInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("firespark")) continue;
            this.infuse.setSecondInfuse(player.getUniqueId(), "fire");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Fire.this.FirePassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking() && this.hasFireEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "fire", 2)) {
            event.setCancelled(true);
            this.activateFire(player);
        }
    }

    private boolean hasFireEquipped(Player player) {
        String effectname = "fire";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasFireSparkEquipped(Player player) {
        String effectname = "firespark";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    public void FirePassives(Player player, Object event) {
        if (this.hasFireEquipped(player) || this.hasFireSparkEquipped(player)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 40, 0, false, false));
            if (player.isInLava() || player.getFireTicks() > 0 || player.getLocation().getBlock().getType() == Material.LAVA) {
                double currentAttack;
                AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
                if (attackAttribute != null && (currentAttack = attackAttribute.getBaseValue()) == 1.0) {
                    attackAttribute.setBaseValue(2.0);
                }
                if (this.hasFireSparkEquipped(player)) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 4, false, false));
                }
            } else {
                double currentAttack;
                AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
                if (attackAttribute != null && (currentAttack = attackAttribute.getBaseValue()) == 2.0) {
                    attackAttribute.setBaseValue(1.0);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Player attacker;
        if (event.getDamager() instanceof Player && this.hasFireSparkEquipped(attacker = (Player)event.getDamager()) && event.getEntity() instanceof LivingEntity) {
            Player targetPlayer;
            LivingEntity target = (LivingEntity)event.getEntity();
            if (target instanceof Player && this.isTeammate(targetPlayer = (Player)target, attacker)) {
                return;
            }
            target.setFireTicks(100);
        }
    }

    public void activateFire(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "fire", 2)) {
            this.infuse.setSecondInfuse(player.getUniqueId(), "firespark");
            Cooldowns.setDuration(player.getUniqueId(), "firespark", 30L, 2);
            Cooldowns.setCooldown(player.getUniqueId(), "fire", 90L, 2);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasFireSparkEquipped(player)) {
                    this.infuse.setSecondInfuse(player.getUniqueId(), "fire");
                }
            }, 600L);
        }
    }

    public static ItemStack createFire() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a76Fire Effect";
            effectName = Fire.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79s\u1d1c\u1d18\u1d18\u1d0f\u0280\u1d1b \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a76\ud83d\udd25\u00a77 Grants Fire Resistance", "\u00a76\ud83d\udd25\u00a77 +1 Attack Damage while \u00a76on fire", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a76\ud83d\udd25\u00a77 Regenerate health while \u00a76on fire", "\u00a76\ud83d\udd25\u00a77 Inflict fire on players", "", "\u00a78Duration: \u00a7930s \u00a78Cooldown: \u00a7960s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)255, (int)165, (int)0));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(11));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

