/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Supports;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class Ocean
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;

    public Ocean(Infuse plugin, InfuseManager infuse) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getSecondInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("oceanspark")) continue;
            this.infuse.setSecondInfuse(player.getUniqueId(), "ocean");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Ocean.this.OceanPassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking() && this.hasOceanEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "ocean", 2)) {
            event.setCancelled(true);
            this.activateOcean(player);
        }
    }

    private boolean hasOceanEquipped(Player player) {
        String effectname = "ocean";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasOceanSparkEquipped(Player player) {
        String effectname = "oceanspark";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    public void OceanPassives(Player player, Object event) {
        if (this.hasOceanEquipped(player) || this.hasOceanSparkEquipped(player)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 40, 0, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.CONDUIT_POWER, 40, 0, false, false));
            if (player.isInWater() || player.getLocation().getBlock().getType() == Material.WATER) {
                double currentAttack;
                AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
                if (attackAttribute != null && (currentAttack = attackAttribute.getBaseValue()) == 1.0) {
                    attackAttribute.setBaseValue(3.0);
                }
                if (this.hasOceanSparkEquipped(player)) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 4, false, false));
                }
            } else {
                double currentAttack;
                AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
                if (attackAttribute != null && (currentAttack = attackAttribute.getBaseValue()) == 3.0) {
                    attackAttribute.setBaseValue(1.0);
                }
            }
        }
    }

    public void activateOcean(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "ocean", 2)) {
            this.infuse.setSecondInfuse(player.getUniqueId(), "oceanspark");
            Cooldowns.setDuration(player.getUniqueId(), "oceanspark", 30L, 2);
            Cooldowns.setCooldown(player.getUniqueId(), "ocean", 95L, 2);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasOceanSparkEquipped(player)) {
                    this.infuse.setSecondInfuse(player.getUniqueId(), "ocean");
                }
            }, 600L);
        }
    }

    public static ItemStack createOcean() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a79Ocean Effect";
            effectName = Ocean.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79s\u1d1c\u1d18\u1d18\u1d0f\u0280\u1d1b \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a79\ud83e\udee7\u00a77 Grants Dolphin's Grace", "\u00a79\ud83e\udee7\u00a77 Grants Conduit Power", "\u00a79\ud83e\udee7\u00a77 +2 Attack Damage while \u00a79in water", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a79\ud83e\udee7\u00a77 Regenerate health while \u00a79in water", "", "\u00a78Duration: \u00a7330s \u00a78Cooldown: \u00a7345s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)0, (int)0, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(12));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

