/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Supports;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class Speed
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;

    public Speed(Infuse plugin, InfuseManager infuse) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getSecondInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("speedspark")) continue;
            this.infuse.setSecondInfuse(player.getUniqueId(), "speed");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Speed.this.SpeedPassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking() && this.hasSpeedEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "speed", 2)) {
            event.setCancelled(true);
            this.activateSpeed(player);
        }
    }

    private boolean hasSpeedEquipped(Player player) {
        String effectname = "speed";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasSpeedSparkEquipped(Player player) {
        String effectname = "speedspark";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    public void SpeedPassives(Player player, Object event) {
        if (this.hasSpeedEquipped(player) || this.hasSpeedSparkEquipped(player)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, 1, false, false));
        }
    }

    public void activateSpeed(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "speed", 2)) {
            this.infuse.setSecondInfuse(player.getUniqueId(), "speedspark");
            Cooldowns.setDuration(player.getUniqueId(), "speedspark", 1L, 2);
            Cooldowns.setCooldown(player.getUniqueId(), "speed", 16L, 2);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Vector direction = player.getEyeLocation().getDirection().normalize();
            double playerVelocityMultiplier = 2.5;
            player.setVelocity(direction.clone().multiply(playerVelocityMultiplier));
            Particle.DustOptions dust = new Particle.DustOptions(Color.fromRGB((int)230, (int)220, (int)170), 1.5f);
            Location[] lastLoc = new Location[]{player.getLocation().clone()};
            int[] ticks = new int[]{0};
            Bukkit.getRegionScheduler().runAtFixedRate((Plugin)this.plugin, player.getLocation(), task -> {
                if (!player.isOnline()) {
                    task.cancel();
                    return;
                }
                Location loc = player.getLocation();
                double dist = lastLoc[0].distance(loc);
                if (dist > 0.1) {
                    Vector step = loc.toVector().subtract(lastLoc[0].toVector()).normalize().multiply(0.3);
                    Location particleLoc = lastLoc[0].clone();
                    for (double d = 0.0; d <= dist; d += 0.3) {
                        particleLoc.add(step);
                        player.getWorld().spawnParticle(Particle.DUST, particleLoc, 5, 0.1, 0.05, 0.1, 0.05, (Object)dust);
                    }
                    lastLoc[0] = loc.clone();
                }
                int n = ticks[0];
                ticks[0] = n + 1;
                if (n >= 3 && player.isOnGround()) {
                    task.cancel();
                }
            }, 1L, 1L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasSpeedSparkEquipped(player)) {
                    this.infuse.setSecondInfuse(player.getUniqueId(), "speed");
                }
            }, 20L);
        }
    }

    public static ItemStack createSpeed() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7#E8BD74Speed Effect";
            effectName = Speed.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79s\u1d1c\u1d18\u1d18\u1d0f\u0280\u1d1b \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7f\u00ab\u00a77 Grants Speed II", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7f\u00ab\u00a77 Dash foward", "", "\u00a78Duration: \u00a791s \u00a78Cooldown: \u00a7915s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.AQUA);
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(12));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

