/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.duckiee2.Managers.InfuseManager;

public class SetEffectsCommand
implements CommandExecutor,
TabCompleter {
    private InfuseManager infuseManager;
    private static final List<String> PRIMARY = Arrays.asList("strength", "heart", "haste", "invis", "feather", "frost", "thunder", "regen", "ender");
    private static final List<String> SUPPORT = Arrays.asList("ocean", "fire", "emerald", "speed");

    public SetEffectsCommand(InfuseManager infuseManager) {
        this.infuseManager = infuseManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /seteffect <player> <effect>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found. Do they even exist?");
            return true;
        }
        String effect = args[1].toLowerCase();
        if (PRIMARY.contains(effect)) {
            this.infuseManager.setInfuse(target.getUniqueId(), effect);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set Primary to " + effect + " for " + target.getName());
        } else if (SUPPORT.contains(effect)) {
            this.infuseManager.setSecondInfuse(target.getUniqueId(), effect);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set Support to " + effect + " for " + target.getName());
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown effect.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions;
        block4: {
            block3: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block3;
                String prefix = args[0].toLowerCase();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(prefix)) continue;
                    completions.add(player.getName());
                }
                break block4;
            }
            if (args.length != 2) break block4;
            String prefix = args[1].toLowerCase();
            for (String effect : PRIMARY) {
                if (!effect.startsWith(prefix)) continue;
                completions.add(effect);
            }
            for (String effect : SUPPORT) {
                if (!effect.startsWith(prefix)) continue;
                completions.add(effect);
            }
        }
        return completions;
    }
}

