/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Managers;

import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.duckiee2.Abilities.Primaries.Ender;
import org.duckiee2.Abilities.Primaries.Feather;
import org.duckiee2.Abilities.Primaries.Frost;
import org.duckiee2.Abilities.Primaries.Haste;
import org.duckiee2.Abilities.Primaries.Heart;
import org.duckiee2.Abilities.Primaries.Invis;
import org.duckiee2.Abilities.Primaries.Regen;
import org.duckiee2.Abilities.Primaries.Strength;
import org.duckiee2.Abilities.Primaries.Thunder;
import org.duckiee2.Abilities.Supports.Emerald;
import org.duckiee2.Abilities.Supports.Fire;
import org.duckiee2.Abilities.Supports.Ocean;
import org.duckiee2.Abilities.Supports.Speed;
import org.duckiee2.Infuse;

public class InfuseRecipeManager
implements Listener {
    private final Infuse plugin;
    private final Map<String, ItemStack> recipeResults;

    public InfuseRecipeManager(Infuse plugin) {
        this.plugin = plugin;
        this.recipeResults = new HashMap<String, ItemStack>();
        this.registerRecipes();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void registerRecipes() {
        this.registerEmerald();
        this.registerHeart();
        this.registerSpeed();
        this.registerStrength();
        this.registerFire();
        this.registerOcean();
        this.registerHaste();
        this.registerInvis();
        this.registerRegen();
        this.registerThunder();
        this.registerFrost();
        this.registerFeather();
        this.registerEnder();
    }

    private void registerEmerald() {
        ItemStack result = Emerald.createEmerald();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "emerald");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"EBE", "BCB", "EBE"});
        recipe.setIngredient('E', Material.EMERALD_BLOCK);
        recipe.setIngredient('B', Material.BELL);
        recipe.setIngredient('C', Material.END_CRYSTAL);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("emerald", result);
    }

    private void registerHeart() {
        ItemStack result = Heart.createHeart();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "heart");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"TDT", "DED", "TDT"});
        recipe.setIngredient('T', Material.TOTEM_OF_UNDYING);
        recipe.setIngredient('D', Material.DIAMOND_BLOCK);
        recipe.setIngredient('E', Material.ENCHANTED_GOLDEN_APPLE);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("heart", result);
    }

    private void registerSpeed() {
        ItemStack result = Speed.createSpeed();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "speed");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"SAS", "ARA", "SAS"});
        recipe.setIngredient('S', Material.SUGAR);
        recipe.setIngredient('A', Material.AMETHYST_SHARD);
        recipe.setIngredient('R', Material.RABBIT_FOOT);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("speed", result);
    }

    private void registerStrength() {
        ItemStack result = Strength.createStrength();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "strength");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"WSW", "NLN", "WSW"});
        recipe.setIngredient('W', Material.NETHER_WART);
        recipe.setIngredient('S', Material.WITHER_SKELETON_SKULL);
        recipe.setIngredient('N', Material.NETHERITE_SWORD);
        recipe.setIngredient('L', Material.LODESTONE);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("strength", result);
    }

    private void registerFire() {
        ItemStack result = Fire.createFire();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "fire");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"MFM", "FCF", "MFM"});
        recipe.setIngredient('M', Material.MAGMA_CREAM);
        recipe.setIngredient('F', Material.FIRE_CHARGE);
        recipe.setIngredient('C', Material.CRYING_OBSIDIAN);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("fire", result);
    }

    private void registerOcean() {
        ItemStack result = Ocean.createOcean();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "ocean");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"PSP", "SHS", "PSP"});
        recipe.setIngredient('P', Material.PRISMARINE_SHARD);
        recipe.setIngredient('S', Material.SEA_LANTERN);
        recipe.setIngredient('H', Material.HEART_OF_THE_SEA);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("ocean", result);
    }

    private void registerHaste() {
        ItemStack result = Haste.createHaste();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "haste");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"DND", "GBG", "DAD"});
        recipe.setIngredient('D', Material.DIAMOND_BLOCK);
        recipe.setIngredient('N', Material.NETHERITE_PICKAXE);
        recipe.setIngredient('G', Material.GOLD_BLOCK);
        recipe.setIngredient('B', Material.BEACON);
        recipe.setIngredient('A', Material.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("haste", result);
    }

    private void registerInvis() {
        ItemStack result = Invis.createInvis();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "invis");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"ESE", "SRS", "ESE"});
        recipe.setIngredient('E', Material.ENDER_EYE);
        recipe.setIngredient('S', Material.SCULK_SHRIEKER);
        recipe.setIngredient('R', Material.RECOVERY_COMPASS);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("invis", result);
    }

    private void registerRegen() {
        ItemStack result = Regen.createRegen();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "regen");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"GHT", "SCS", "THG"});
        recipe.setIngredient('G', Material.GOLDEN_APPLE);
        recipe.setIngredient('H', Material.HONEY_BOTTLE);
        recipe.setIngredient('S', Material.SUSPICIOUS_STEW);
        recipe.setIngredient('C', Material.CAKE);
        recipe.setIngredient('T', Material.TOTEM_OF_UNDYING);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("regen", result);
    }

    private void registerThunder() {
        ItemStack result = Thunder.createThunder();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "thunder");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"LSL", "TCT", "LSL"});
        recipe.setIngredient('L', Material.LIGHTNING_ROD);
        recipe.setIngredient('S', Material.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE);
        recipe.setIngredient('T', Material.TRIDENT);
        recipe.setIngredient('C', Material.CREEPER_HEAD);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("thunder", result);
    }

    private void registerFrost() {
        ItemStack result = Frost.createFrost();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "frost");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"IPI", "TCT", "IPI"});
        recipe.setIngredient('I', Material.BLUE_ICE);
        recipe.setIngredient('P', Material.POWDER_SNOW_BUCKET);
        recipe.setIngredient('T', Material.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE);
        recipe.setIngredient('C', Material.CONDUIT);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("frost", result);
    }

    private void registerFeather() {
        ItemStack result = Feather.createFeather();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "feather");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"FGF", "VTV", "FGF"});
        recipe.setIngredient('F', Material.FEATHER);
        recipe.setIngredient('G', Material.GOAT_HORN);
        recipe.setIngredient('V', Material.VEX_ARMOR_TRIM_SMITHING_TEMPLATE);
        recipe.setIngredient('T', Material.TRIDENT);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("feather", result);
    }

    private void registerEnder() {
        ItemStack result = Ender.createEnder();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "ender");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"BHB", "EDE", "BWB"});
        recipe.setIngredient('B', Material.DRAGON_BREATH);
        recipe.setIngredient('H', Material.DRAGON_HEAD);
        recipe.setIngredient('E', Material.ENDER_EYE);
        recipe.setIngredient('D', Material.DRAGON_EGG);
        recipe.setIngredient('W', Material.ELYTRA);
        Bukkit.addRecipe((Recipe)recipe);
        this.recipeResults.put("ender", result);
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        ShapedRecipe shaped;
        String recipeKey;
        if (event.getRecipe() instanceof ShapedRecipe && this.recipeResults.containsKey(recipeKey = (shaped = (ShapedRecipe)event.getRecipe()).getKey().getKey())) {
            Player player = (Player)event.getWhoClicked();
            if (event.isShiftClick()) {
                event.setCancelled(true);
                return;
            }
            Inventory topInv = event.getView().getTopInventory();
            if (topInv.getType() != InventoryType.WORKBENCH) {
                event.setCancelled(true);
                return;
            }
            if (!this.isNearBrewingStand(player.getLocation())) {
                event.setCancelled(true);
                return;
            }
            player.playSound(player.getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 5.0f, 1.0f);
            ChatColor color = this.getEffectColor(recipeKey);
            String effectName = recipeKey.substring(0, 1).toUpperCase() + recipeKey.substring(1);
            player.sendMessage(String.valueOf(color) + "An " + effectName + " effect has been brewed!");
            ItemStack itemStack = this.recipeResults.get(recipeKey).clone();
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ShapedRecipe shaped;
        String recipeKey;
        if (event.getRecipe() instanceof ShapedRecipe && this.recipeResults.containsKey(recipeKey = (shaped = (ShapedRecipe)event.getRecipe()).getKey().getKey())) {
            Inventory topInv = event.getView().getTopInventory();
            Player player = (Player)event.getView().getPlayer();
            if (topInv.getType() != InventoryType.WORKBENCH) {
                event.getInventory().setResult((ItemStack)null);
            } else if (!this.isNearBrewingStand(player.getLocation())) {
                event.getInventory().setResult((ItemStack)null);
            } else {
                event.getInventory().setResult(this.recipeResults.get(recipeKey));
            }
        }
    }

    private boolean isNearBrewingStand(Location loc) {
        World world = loc.getWorld();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    if (world.getBlockAt(loc.clone().add((double)x, (double)y, (double)z)).getType() != Material.BREWING_STAND) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @EventHandler
    public void onBrewingStandInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.BREWING_STAND) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            player.openWorkbench(player.getLocation(), true);
        }
    }

    @EventHandler
    public void onCrafter(CrafterCraftEvent event) {
        ItemStack result = event.getResult();
        if (result != null && result.getType() == Material.MACE) {
            event.setCancelled(true);
        }
    }

    private ChatColor getEffectColor(String key) {
        switch (key.toLowerCase()) {
            case "feather": {
                return ChatColor.of((String)"#0FB820");
            }
            case "speed": {
                return ChatColor.of((String)"#FFEE8C");
            }
            case "emerald": {
                return ChatColor.of((String)"#88E788");
            }
            case "haste": {
                return ChatColor.of((String)"#D98D32");
            }
            case "strength": {
                return ChatColor.of((String)"#B21920");
            }
            case "heart": {
                return ChatColor.of((String)"#E504B8");
            }
            case "invis": {
                return ChatColor.of((String)"#9F4AC1");
            }
            case "ocean": {
                return ChatColor.of((String)"#3F73CC");
            }
            case "fire": {
                return ChatColor.of((String)"#D5331E");
            }
            case "regen": {
                return ChatColor.of((String)"#F9D3D6");
            }
            case "frost": {
                return ChatColor.of((String)"#8EDFE7");
            }
            case "thunder": {
                return ChatColor.of((String)"#25695F");
            }
            case "ender": {
                return ChatColor.of((String)"#961D89");
            }
        }
        return ChatColor.GRAY;
    }
}

