/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;
import org.duckiee2.Trust.TrustManager;

public class Frost
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;
    private final TrustManager trustManager;
    private HashMap<UUID, Long> frosted = new HashMap();

    public Frost(Infuse plugin, InfuseManager infuse, TrustManager trustManager) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.trustManager = trustManager;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("frostspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "frost");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Frost.this.FrostPassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void FrostPassives(Player player, Object event) {
        if (this.hasFrostEquipped(player) || this.hasFrostSparkEquipped(player)) {
            Block blockBelow = player.getLocation().subtract(0.0, 1.0, 0.0).getBlock();
            Material type = blockBelow.getType();
            Block snowLayer = player.getLocation().getBlock();
            Material layer = snowLayer.getType();
            if (type == Material.ICE || type == Material.PACKED_ICE || type == Material.BLUE_ICE || type == Material.FROSTED_ICE) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, 9, false, false));
            }
            if (type == Material.SNOW_BLOCK) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, 2, false, false));
            }
            if (layer == Material.SNOW) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, 2, false, false));
            }
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent e) {
        Player targetPlayer;
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player p = (Player)e.getDamager();
        LivingEntity victim = (LivingEntity)e.getEntity();
        if (victim instanceof Player && this.isTeammate(targetPlayer = (Player)victim, p)) {
            return;
        }
        if (this.hasFrostSparkEquipped(p)) {
            this.frostbite(victim);
            if (this.isFrosted(victim)) {
                e.setDamage(e.getDamage() + 2.5);
            }
        } else if (this.hasFrostEquipped(p)) {
            if (Math.random() < 0.1) {
                this.frostbite(victim);
            }
            if (this.isFrosted(victim)) {
                e.setDamage(e.getDamage() + 1.0);
            }
        }
    }

    private void frostbite(LivingEntity e) {
        this.frosted.put(e.getUniqueId(), System.currentTimeMillis());
        e.setFreezeTicks(100);
    }

    private boolean isFrosted(LivingEntity e) {
        if (!this.frosted.containsKey(e.getUniqueId())) {
            return false;
        }
        long time = this.frosted.get(e.getUniqueId());
        if (System.currentTimeMillis() - time > 5000L) {
            this.frosted.remove(e.getUniqueId());
            return false;
        }
        return true;
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasFrostEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "frost", 1)) {
            event.setCancelled(true);
            this.activateFrost(player);
        }
    }

    private boolean hasFrostEquipped(Player player) {
        String effectname = "frost";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasFrostSparkEquipped(Player player) {
        String effectname = "frostspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    public void activateFrost(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "frost", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "frostspark");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Cooldowns.setDuration(player.getUniqueId(), "frostspark", 20L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "frost", 95L, 1);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasFrostSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "frost");
                }
            }, 400L);
        }
    }

    public static ItemStack createFrost() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7bFrost Effect";
            effectName = Frost.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7b\u2744\u00a77 Speed X on \u00a73Ice \u00a77& \u00a7oSpeed III \u00a7r\u00a77on \u00a7bSnow", "\u00a7b\u2744\u00a77 10% chance to Inflict \u00a7bFrostbite", "\u00a7b\u2744\u00a77 +1 Attack damage on frosted enemies", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7b\u2744\u00a77 100% chance to Inflict \u00a7bFrostbite", "\u00a7b\u2744\u00a77 +2.5 Atttack damage on frosted enemies", "", "\u00a78Duration: \u00a7320s \u00a78Cooldown: \u00a7375s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)0, (int)255, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(3));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

