/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Commands;

import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Abilities.Primaries.Ender;
import org.duckiee2.Abilities.Primaries.Feather;
import org.duckiee2.Abilities.Primaries.Frost;
import org.duckiee2.Abilities.Primaries.Haste;
import org.duckiee2.Abilities.Primaries.Heart;
import org.duckiee2.Abilities.Primaries.Invis;
import org.duckiee2.Abilities.Primaries.Regen;
import org.duckiee2.Abilities.Primaries.Strength;
import org.duckiee2.Abilities.Primaries.Thunder;
import org.duckiee2.Abilities.Supports.Emerald;
import org.duckiee2.Abilities.Supports.Fire;
import org.duckiee2.Abilities.Supports.Ocean;
import org.duckiee2.Abilities.Supports.Speed;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.InfuseManager;

public class DrainCommands
implements CommandExecutor,
Listener {
    private final InfuseManager infuseManager;
    private final Infuse plugin;

    public DrainCommands(Infuse plugin, InfuseManager infuseManager) {
        this.plugin = plugin;
        this.infuseManager = infuseManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String currentEffect;
        String slot;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        final Player player = (Player)sender;
        if (label.contains("rdrain")) {
            slot = "2";
        } else if (label.contains("ldrain")) {
            slot = "1";
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid usage. Use /rdrain or /ldrain");
            return true;
        }
        String string = currentEffect = slot.equals("1") ? this.infuseManager.getInfuse(player.getUniqueId()) : this.infuseManager.getSecondInfuse(player.getUniqueId());
        if (currentEffect == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have an Effect equipped in slot " + slot + ".");
            return true;
        }
        if (player.getInventory().firstEmpty() == -1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your inventory is full! Make space before unequipping.");
            return true;
        }
        if (slot.equals("1")) {
            this.infuseManager.removeInfuse(player.getUniqueId());
        } else {
            this.infuseManager.removeSecondInfuse(player.getUniqueId());
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have drained your: " + currentEffect);
        player.playSound(player.getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 3.0f, 1.3f);
        new BukkitRunnable(){

            public void run() {
                player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(20.0);
                ItemStack effectItem = DrainCommands.this.getEffectItem(currentEffect);
                if (effectItem != null) {
                    player.getInventory().addItem(new ItemStack[]{effectItem});
                }
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
        return true;
    }

    private ItemStack getEffectItem(String effectName) {
        switch (effectName.toLowerCase()) {
            case "feather": 
            case "featherspark": {
                return Feather.createFeather();
            }
            case "frost": 
            case "frostspark": {
                return Frost.createFrost();
            }
            case "invis": 
            case "invisspark": {
                return Invis.createInvis();
            }
            case "haste": 
            case "hastespark": {
                return Haste.createHaste();
            }
            case "heart": 
            case "heartspark": {
                return Heart.createHeart();
            }
            case "regen": 
            case "regenspark": {
                return Regen.createRegen();
            }
            case "strength": 
            case "strengthspark": {
                return Strength.createStrength();
            }
            case "thunder": 
            case "thunderspark": {
                return Thunder.createThunder();
            }
            case "ender": 
            case "enderspark": {
                return Ender.createEnder();
            }
            case "speed": 
            case "speedspark": {
                return Speed.createSpeed();
            }
            case "ocean": 
            case "oceanspark": {
                return Ocean.createOcean();
            }
            case "emerald": 
            case "emeraldspark": {
                return Emerald.createEmerald();
            }
            case "fire": 
            case "firespark": {
                return Fire.createFire();
            }
        }
        return null;
    }
}

