/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class Cooldowns {
    private static final Map<UUID, Map<String, Long>> cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private static final Map<UUID, Map<String, Long>> durations = new ConcurrentHashMap<UUID, Map<String, Long>>();

    public static void setDuration(UUID playerUUID, String key, long seconds, int slot) {
        String slotKey = Cooldowns.createSlotKey(key, slot);
        durations.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(slotKey, System.currentTimeMillis() + seconds * 1000L);
    }

    public static boolean isEffectActive(UUID playerUUID, String key, int slot) {
        return Cooldowns.getEffectTimeLeft(playerUUID, key, slot) > 0L;
    }

    public static long getEffectTimeLeft(UUID playerUUID, String key, int slot) {
        String slotKey = Cooldowns.createSlotKey(key, slot);
        Map<String, Long> playerDurations = durations.get(playerUUID);
        if (playerDurations != null && playerDurations.containsKey(slotKey)) {
            long timeLeft = playerDurations.get(slotKey) - System.currentTimeMillis();
            return timeLeft > 0L ? timeLeft : 0L;
        }
        return 0L;
    }

    public static void clearSpecificDuration(UUID playerUUID, String key, int slot) {
        String slotKey = Cooldowns.createSlotKey(key, slot);
        Map<String, Long> playerDurations = durations.get(playerUUID);
        if (playerDurations != null) {
            playerDurations.remove(slotKey);
        }
    }

    public static void cleanupExpiredDurations() {
        long currentTime = System.currentTimeMillis();
        for (UUID playerUUID : durations.keySet()) {
            Map<String, Long> playerDurations = durations.get(playerUUID);
            if (playerDurations == null) continue;
            playerDurations.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        }
    }

    public static boolean isOnCooldown(UUID playerUUID, String key, int slot) {
        return Cooldowns.getCooldownTimeLeft(playerUUID, key, slot) > 0L;
    }

    public static void setCooldown(UUID playerUUID, String key, long seconds, int slot) {
        String slotKey = Cooldowns.createSlotKey(key, slot);
        cooldowns.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(slotKey, System.currentTimeMillis() + seconds * 1000L);
    }

    public static long getCooldownTimeLeft(UUID playerUUID, String key, int slot) {
        String slotKey = Cooldowns.createSlotKey(key, slot);
        Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
        if (playerCooldowns != null && playerCooldowns.containsKey(slotKey)) {
            long timeLeft = playerCooldowns.get(slotKey) - System.currentTimeMillis();
            return timeLeft > 0L ? timeLeft : 0L;
        }
        return 0L;
    }

    public static void clearSpecificCooldown(UUID playerUUID, String key, int slot) {
        String slotKey = Cooldowns.createSlotKey(key, slot);
        Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
        if (playerCooldowns != null) {
            playerCooldowns.remove(slotKey);
        }
    }

    public static void cleanupAllExpiredCooldowns() {
        long currentTime = System.currentTimeMillis();
        for (UUID playerUUID : cooldowns.keySet()) {
            Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
            if (playerCooldowns == null) continue;
            playerCooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        }
    }

    public static void removeAllCooldowns(UUID playerUUID) {
        cooldowns.remove(playerUUID);
    }

    private static String createSlotKey(String key, int slot) {
        return key + "_slot" + slot;
    }
}

