/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class GemManager
extends BukkitRunnable {
    private Infuse plugin;
    private InfuseManager infuses;
    private static final Map<String, String> emoji = new HashMap<String, String>();
    private static final Map<String, ChatColor> Colour;

    public GemManager(Infuse plugin, InfuseManager infuses) {
        this.plugin = plugin;
        this.infuses = infuses;
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])");
        return pattern.matcher(input).replaceAll("");
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String support;
            UUID uuid = player.getUniqueId();
            String firstTime = "";
            String firstEmoji = "\ue001";
            String secondTime = "";
            String secondEmoji = "\ue001";
            String primary = this.infuses.getInfuse(uuid);
            if (primary != null) {
                ChatColor color = this.getColor(primary);
                if (Cooldowns.isEffectActive(uuid, primary, 1)) {
                    long timeLeft = Cooldowns.getEffectTimeLeft(uuid, primary, 1) / 1000L;
                    firstTime = this.formatIt(timeLeft, color, false);
                    firstEmoji = this.getInfuse(primary);
                } else if (Cooldowns.isOnCooldown(uuid, primary, 1)) {
                    long timeLeft = Cooldowns.getCooldownTimeLeft(uuid, primary, 1) / 1000L;
                    firstTime = this.formatIt(timeLeft, ChatColor.WHITE, false);
                    firstEmoji = this.getInfuse(primary);
                } else {
                    firstEmoji = this.getInfuse(primary);
                }
            }
            if ((support = this.infuses.getSecondInfuse(uuid)) != null) {
                ChatColor color = this.getColor(support);
                if (Cooldowns.isEffectActive(uuid, support, 2)) {
                    long timeLeft = Cooldowns.getEffectTimeLeft(uuid, support, 2) / 1000L;
                    secondTime = this.formatIt(timeLeft, color, true);
                    secondEmoji = this.getInfuse(support);
                } else if (Cooldowns.isOnCooldown(uuid, support, 2)) {
                    long timeLeft = Cooldowns.getCooldownTimeLeft(uuid, support, 2) / 1000L;
                    secondTime = this.formatIt(timeLeft, ChatColor.WHITE, true);
                    secondEmoji = this.getInfuse(support);
                } else {
                    secondEmoji = this.getInfuse(support);
                }
            }
            StringBuilder actionBar = new StringBuilder();
            if (!firstTime.isEmpty()) {
                actionBar.append(firstTime).append("  ");
            }
            actionBar.append(firstEmoji).append(" ");
            actionBar.append(secondEmoji);
            if (!secondTime.isEmpty()) {
                actionBar.append("  ").append(secondTime);
            }
            String finalMessage = actionBar.toString().trim();
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)finalMessage));
        }
    }

    private String getInfuse(String key) {
        return emoji.getOrDefault(key, "\ue001");
    }

    private String formatIt(long totalSeconds, ChatColor color, boolean rightAlign) {
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        String timeString = minutes + ":" + String.format("%02d", seconds);
        if (rightAlign) {
            return color.toString() + String.valueOf(ChatColor.BOLD) + timeString + String.valueOf(ChatColor.RESET);
        }
        return color.toString() + String.valueOf(ChatColor.BOLD) + timeString + String.valueOf(ChatColor.RESET);
    }

    private ChatColor getColor(String key) {
        return Colour.getOrDefault(key, ChatColor.GRAY);
    }

    static {
        emoji.put("strength", "\ue002");
        emoji.put("heart", "\ue003");
        emoji.put("haste", "\ue004");
        emoji.put("invis", "\ue005");
        emoji.put("feather", "\ue006");
        emoji.put("frost", "\ue007");
        emoji.put("thunder", "\ue008");
        emoji.put("regen", "\ue009");
        emoji.put("ender", "\ue027");
        emoji.put("strengthspark", "\ue014");
        emoji.put("heartspark", "\ue015");
        emoji.put("hastespark", "\ue016");
        emoji.put("invisspark", "\ue017");
        emoji.put("featherspark", "\ue018");
        emoji.put("frostspark", "\ue019");
        emoji.put("thunderspark", "\ue020");
        emoji.put("regenspark", "\ue021");
        emoji.put("enderspark", "\ue026");
        emoji.put("ocean", "\ue010");
        emoji.put("fire", "\ue011");
        emoji.put("emerald", "\ue012");
        emoji.put("speed", "\ue013");
        emoji.put("oceanspark", "\ue022");
        emoji.put("firespark", "\ue023");
        emoji.put("emeraldspark", "\ue024");
        emoji.put("speedspark", "\ue025");
        Colour = new HashMap<String, ChatColor>();
        Colour.put("feather", ChatColor.WHITE);
        Colour.put("featherspark", ChatColor.of((String)"#FEFDFE"));
        Colour.put("speed", ChatColor.WHITE);
        Colour.put("speedspark", ChatColor.of((String)"#FFEE8C"));
        Colour.put("emerald", ChatColor.WHITE);
        Colour.put("emeraldspark", ChatColor.of((String)"#88E788"));
        Colour.put("haste", ChatColor.WHITE);
        Colour.put("hastespark", ChatColor.of((String)"#D98D32"));
        Colour.put("strength", ChatColor.WHITE);
        Colour.put("strengthspark", ChatColor.of((String)"#B21920"));
        Colour.put("heart", ChatColor.WHITE);
        Colour.put("heartspark", ChatColor.of((String)"#E504B8"));
        Colour.put("invis", ChatColor.WHITE);
        Colour.put("invisspark", ChatColor.of((String)"#9F4AC1"));
        Colour.put("ocean", ChatColor.WHITE);
        Colour.put("oceanspark", ChatColor.of((String)"#3F73CC"));
        Colour.put("fire", ChatColor.WHITE);
        Colour.put("firespark", ChatColor.of((String)"#D5331E"));
        Colour.put("regen", ChatColor.WHITE);
        Colour.put("regenspark", ChatColor.of((String)"#F9D3D6"));
        Colour.put("frost", ChatColor.WHITE);
        Colour.put("frostspark", ChatColor.of((String)"#8EDFE7"));
        Colour.put("thunder", ChatColor.WHITE);
        Colour.put("thunderspark", ChatColor.of((String)"#25695F"));
        Colour.put("ender", ChatColor.WHITE);
        Colour.put("enderspark", ChatColor.of((String)"#961D89"));
    }
}

