/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Trust;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class TrustManager {
    private final File file;
    private FileConfiguration config;
    private final Map<UUID, Set<UUID>> trustMap = new HashMap<UUID, Set<UUID>>();

    public TrustManager(File dataFolder) {
        this.file = new File(dataFolder, "trust.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadConfig();
        this.loadTrustData();
    }

    private void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadTrustData() {
        this.trustMap.clear();
        for (String casterUUIDStr : this.config.getKeys(false)) {
            UUID casterUUID;
            try {
                casterUUID = UUID.fromString(casterUUIDStr);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            List trustedUUIDStrings = this.config.getStringList(casterUUIDStr);
            Set trustedSet = trustedUUIDStrings.stream().map(s -> {
                try {
                    return UUID.fromString(s);
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }).filter(Objects::nonNull).filter(uuid -> !uuid.equals(casterUUID)).collect(Collectors.toSet());
            if (trustedSet.isEmpty()) continue;
            this.trustMap.put(casterUUID, trustedSet);
        }
    }

    private void saveTrustData() {
        for (String string : this.config.getKeys(false)) {
            this.config.set(string, null);
        }
        for (Map.Entry entry : this.trustMap.entrySet()) {
            String casterUUID = ((UUID)entry.getKey()).toString();
            List trustedUUIDs = ((Set)entry.getValue()).stream().map(UUID::toString).collect(Collectors.toList());
            this.config.set(casterUUID, trustedUUIDs);
        }
        this.saveConfig();
    }

    public void addTrust(Player caster, Player trusted) {
        if (caster == null || trusted == null || caster.getUniqueId().equals(trusted.getUniqueId())) {
            return;
        }
        this.trustMap.computeIfAbsent(caster.getUniqueId(), k -> new HashSet()).add(trusted.getUniqueId());
        this.saveTrustData();
    }

    public void removeTrust(Player caster, Player trusted) {
        if (caster == null || trusted == null || caster.getUniqueId().equals(trusted.getUniqueId())) {
            return;
        }
        Set<UUID> trustedSet = this.trustMap.get(caster.getUniqueId());
        if (trustedSet != null) {
            trustedSet.remove(trusted.getUniqueId());
            if (trustedSet.isEmpty()) {
                this.trustMap.remove(caster.getUniqueId());
            }
            this.saveTrustData();
        }
    }

    public boolean isTrusted(Player player, Player caster) {
        if (player == null || caster == null) {
            return false;
        }
        if (player.getUniqueId().equals(caster.getUniqueId())) {
            return true;
        }
        Set<UUID> trustedSet = this.trustMap.get(caster.getUniqueId());
        return trustedSet != null && trustedSet.contains(player.getUniqueId());
    }
}

