/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class Haste
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;

    public Haste(Infuse plugin, InfuseManager infuse) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("hastespark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "haste");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!Haste.this.hasHasteEquipped(player) && !Haste.this.hasHasteSparkEquipped(player)) continue;
                    ItemStack mainHand = player.getInventory().getItemInMainHand();
                    Haste.this.HastePassives(player);
                    if (!Haste.this.isPickaxe(mainHand) || mainHand.getEnchantmentLevel(Enchantment.FORTUNE) >= 4) continue;
                    mainHand.addUnsafeEnchantment(Enchantment.FORTUNE, 4);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void HastePassives(Player player) {
        if (this.hasHasteEquipped(player)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 40, 1, false, false));
        }
    }

    private boolean isPickaxe(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type == Material.WOODEN_PICKAXE || type == Material.STONE_PICKAXE || type == Material.IRON_PICKAXE || type == Material.GOLDEN_PICKAXE || type == Material.DIAMOND_PICKAXE || type == Material.NETHERITE_PICKAXE;
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasHasteEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "haste", 1)) {
            event.setCancelled(true);
            this.activateHaste(player);
        }
    }

    private boolean hasHasteEquipped(Player player) {
        String effectname = "haste";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasHasteSparkEquipped(Player player) {
        String effectname = "hastespark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    public void activateHaste(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "haste", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "hastespark");
            player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 600, 255, false, false));
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Cooldowns.setDuration(player.getUniqueId(), "hastespark", 30L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "haste", 105L, 1);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasHasteSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "haste");
                }
            }, 600L);
        }
    }

    public static ItemStack createHaste() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a76Haste Effect";
            effectName = Haste.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7e\u26cf\u00a77 Grants Haste II and Fortune IV", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7e\u26cf\u00a77 Upgrades Haste II to Instamine", "", "\u00a78Duration: \u00a7930s \u00a78Cooldown: \u00a7975s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)255, (int)204, (int)51));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(5));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

