/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class Heart
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;

    public Heart(Infuse plugin, InfuseManager infuse) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.startPassiveTask();
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("heartspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "heart");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ItemStack mainHand = player.getInventory().getItemInMainHand();
                    Heart.this.HeartPassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void HeartPassives(Player player, Object event) {
        if (this.hasHeartEquipped(player)) {
            AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (maxHealthAttribute == null) {
                return;
            }
            double currentMaxHealth = maxHealthAttribute.getBaseValue();
            if (currentMaxHealth == 20.0) {
                maxHealthAttribute.setBaseValue(30.0);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attackAttribute != null) {
            attackAttribute.setBaseValue(20.0);
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attackAttribute != null) {
            attackAttribute.setBaseValue(20.0);
        }
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasHeartEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "heart", 1)) {
            event.setCancelled(true);
            this.activateHeart(player);
        }
    }

    private boolean hasHeartEquipped(Player player) {
        String effectname = "heart";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasHeartSparkEquipped(Player player) {
        String effectname = "heartspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    public void activateHeart(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "heart", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "heartspark");
            AttributeInstance attackAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attackAttribute != null) {
                attackAttribute.setBaseValue(40.0);
            }
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Cooldowns.setDuration(player.getUniqueId(), "heartspark", 30L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "heart", 150L, 1);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                AttributeInstance attr;
                if (this.hasHeartSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "heart");
                }
                if ((attr = player.getAttribute(Attribute.GENERIC_MAX_HEALTH)) != null) {
                    attr.setBaseValue(30.0);
                }
            }, 600L);
        }
    }

    public static ItemStack createHeart() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7cHeart Effect";
            effectName = Heart.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7c\u2764\u00a77 Grants \u00a7c15 total hearts", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7c\u2764\u00a77 Grants \u00a7c25 total hearts", "", "\u00a78Duration: \u00a7930s \u00a78Cooldown: \u00a7990s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.RED);
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(7));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

