/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Primaries;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;
import org.duckiee2.Trust.TrustManager;

public class Regen
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;
    private final TrustManager trustManager;

    public Regen(Infuse plugin, InfuseManager infuse, TrustManager trustManager) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.trustManager = trustManager;
        this.resetSparks();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("regenspark")) continue;
            this.infuse.setInfuse(player.getUniqueId(), "regen");
        }
    }

    @EventHandler
    public void RegenPassives(EntityDamageByEntityEvent event) {
        Player attacker;
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player && (this.hasRegenEquipped(attacker = (Player)event.getDamager()) || this.hasRegenSparkEquipped(attacker))) {
            attacker.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 1, false, false));
        }
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.isSneaking() && this.hasRegenEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "regen", 1)) {
            event.setCancelled(true);
            this.activateRegen(player);
        }
    }

    private boolean hasRegenEquipped(Player player) {
        String effectname = "regen";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasRegenSparkEquipped(Player player) {
        String effectname = "regenspark";
        String currenteffect = this.infuse.getInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    public void activateRegen(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "regen", 1)) {
            this.infuse.setInfuse(player.getUniqueId(), "regenspark");
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 300, 2, false, false));
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            for (Entity entity : player.getNearbyEntities(16.0, 16.0, 16.0)) {
                Player nearbyPlayer;
                if (!(entity instanceof Player) || !this.isTeammate(nearbyPlayer = (Player)entity, player)) continue;
                nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 300, 2, false, false));
                nearbyPlayer.playSound(nearbyPlayer.getLocation(), Sound.BLOCK_BEACON_AMBIENT, 3.0f, 1.5f);
            }
            Cooldowns.setDuration(player.getUniqueId(), "regenspark", 15L, 1);
            Cooldowns.setCooldown(player.getUniqueId(), "regen", 135L, 1);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasRegenSparkEquipped(player)) {
                    this.infuse.setInfuse(player.getUniqueId(), "regen");
                }
            }, 300L);
        }
    }

    public static ItemStack createRegen() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7cRegen Effect";
            effectName = Regen.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79\u1d18\u0280\u026a\u1d0d\u1d00\u0280\u028f \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7c\ud83d\udc8c\u00a77 Grants \u00a7oRegeneration \u00a7oII \u00a7r\u00a77when attacking enemies", "", "\u00a79s\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7c\ud83d\udc8c\u00a77 Regenerate self and teammates in a 16 block radius", "", "\u00a78Duration: \u00a7315s \u00a78Cooldown: \u00a73120s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)255, (int)0, (int)0));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(9));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

