/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Abilities.Supports;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.Cooldowns;
import org.duckiee2.Managers.InfuseManager;

public class Emerald
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuse;

    public Emerald(Infuse plugin, InfuseManager infuse) {
        this.plugin = plugin;
        this.infuse = infuse;
        this.resetSparks();
        this.startPassiveTask();
    }

    private void resetSparks() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String currentInfuse = this.infuse.getSecondInfuse(player.getUniqueId());
            if (currentInfuse == null || !currentInfuse.equals("emeraldspark")) continue;
            this.infuse.setSecondInfuse(player.getUniqueId(), "emerald");
        }
    }

    private void startPassiveTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Emerald.this.EmeraldPassives(player, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onOffhandAbility(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking() && this.hasEmeraldEquipped(player) && !Cooldowns.isOnCooldown(player.getUniqueId(), "emerald", 2)) {
            event.setCancelled(true);
            this.activateEmerald(player);
        }
    }

    private boolean hasEmeraldEquipped(Player player) {
        String effectname = "emerald";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    private boolean hasEmeraldSparkEquipped(Player player) {
        String effectname = "emeraldspark";
        String currenteffect = this.infuse.getSecondInfuse(player.getUniqueId());
        return currenteffect != null && currenteffect.equals(effectname);
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        double multiplier;
        Player player = event.getPlayer();
        if (this.hasEmeraldEquipped(player)) {
            multiplier = 1.5;
            event.setAmount((int)((double)event.getAmount() * multiplier));
        }
        if (this.hasEmeraldSparkEquipped(player)) {
            multiplier = 3.0;
            event.setAmount((int)((double)event.getAmount() * multiplier));
        }
    }

    public void EmeraldPassives(Player player, Object event) {
        if (this.hasEmeraldEquipped(player) || this.hasEmeraldSparkEquipped(player)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 40, 3, false, false));
        }
    }

    public void activateEmerald(Player player) {
        if (!Cooldowns.isOnCooldown(player.getUniqueId(), "emerald", 2)) {
            this.infuse.setSecondInfuse(player.getUniqueId(), "emeraldspark");
            player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 1200, 255, false, false, false));
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 5.0f, 1.0f);
            Cooldowns.setDuration(player.getUniqueId(), "emeraldspark", 60L, 2);
            Cooldowns.setCooldown(player.getUniqueId(), "emerald", 120L, 2);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.hasEmeraldSparkEquipped(player)) {
                    this.infuse.setSecondInfuse(player.getUniqueId(), "emerald");
                }
            }, 1200L);
        }
    }

    public static ItemStack createEmerald() {
        ItemStack effect = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)effect.getItemMeta();
        if (meta != null) {
            String effectName = "\u00a7aEmerald Effect";
            effectName = Emerald.applyHexColors(effectName);
            meta.setDisplayName(effectName);
            List<String> lore = List.of("\u00a79s\u1d1c\u1d18\u1d18\u1d0f\u0280\u1d1b \u1d07\u0493\u0493\u1d07\u1d04\u1d1b:", "", "\u00a7a\ud83d\udcb2\u00a77 Grants Hero of the Village III", "\u00a7a\ud83d\udcb2\u00a77 1.5x Collected Experience", "", "\u00a7as\u1d18\u1d00\u0280\u1d0b \u1d00\u0299\u026a\u029f\u026a\u1d1b\u028f:", "", "\u00a7a\ud83d\udcb2\u00a77 Upgrades Hero of the Village III to hero of the village \u221e", "\u00a7a\ud83d\udcb2\u00a77 3x Collected Experience", "", "\u00a78Duration: \u00a7960s \u00a78Cooldown: \u00a7960s");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)0, (int)255, (int)0));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(13));
            effect.setItemMeta((ItemMeta)meta);
        }
        return effect;
    }

    private static String applyHexColors(String text) {
        Pattern pattern = Pattern.compile("\u00a7#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hex)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

