/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Managers;

import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.duckiee2.Abilities.Primaries.Ender;
import org.duckiee2.Abilities.Primaries.Feather;
import org.duckiee2.Abilities.Primaries.Frost;
import org.duckiee2.Abilities.Primaries.Haste;
import org.duckiee2.Abilities.Primaries.Heart;
import org.duckiee2.Abilities.Primaries.Invis;
import org.duckiee2.Abilities.Primaries.Regen;
import org.duckiee2.Abilities.Primaries.Strength;
import org.duckiee2.Abilities.Primaries.Thunder;
import org.duckiee2.Abilities.Supports.Emerald;
import org.duckiee2.Abilities.Supports.Fire;
import org.duckiee2.Abilities.Supports.Ocean;
import org.duckiee2.Abilities.Supports.Speed;
import org.duckiee2.Infuse;
import org.duckiee2.Managers.InfuseManager;

public class EffectEquip
implements Listener {
    private final Infuse plugin;
    private final InfuseManager infuseManager;

    public EffectEquip(Infuse plugin, InfuseManager infuseManager) {
        this.plugin = plugin;
        this.infuseManager = infuseManager;
    }

    @EventHandler
    public void onFirstJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            List<String> effects = List.of("speed", "emerald", "ocean", "fire");
            String randomEffect = effects.get(new Random().nextInt(effects.size()));
            this.equipEffect(player, randomEffect, false);
        }
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        String effectName = this.getEffectFromItem(item);
        if (effectName == null) {
            return;
        }
        if (player.getInventory().firstEmpty() == -1) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your inventory is full! Make space before equipping.");
            return;
        }
        boolean isPrimary = this.isPrimaryEffect(effectName);
        if (!this.equipEffect(player, effectName, isPrimary)) {
            if (!isPrimary) {
                player.performCommand("rdrain");
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.equipEffect(player, effectName, false), 1L);
            } else {
                player.performCommand("ldrain");
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.equipEffect(player, effectName, true), 1L);
            }
        }
        this.consumeItem(player);
    }

    private boolean equipEffect(Player player, String effectName, boolean isPrimary) {
        String current;
        String string = current = isPrimary ? this.infuseManager.getInfuse(player.getUniqueId()) : this.infuseManager.getSecondInfuse(player.getUniqueId());
        if (current != null) {
            return false;
        }
        if (isPrimary) {
            this.infuseManager.setInfuse(player.getUniqueId(), effectName);
        } else {
            this.infuseManager.setSecondInfuse(player.getUniqueId(), effectName);
        }
        String colored = EffectEquip.applyHexColors(effectName);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have equipped " + colored);
        return true;
    }

    private void consumeItem(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item != null && item.getType() != Material.AIR) {
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                } else {
                    player.getInventory().setItemInMainHand(null);
                }
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        String primary = this.infuseManager.getInfuse(player.getUniqueId());
        String support = this.infuseManager.getSecondInfuse(player.getUniqueId());
        if (primary != null) {
            this.dropEffect(player, primary, true);
        } else if (support != null) {
            this.dropEffect(player, support, false);
        }
    }

    private void dropEffect(Player player, String effectName, boolean isPrimary) {
        if (isPrimary) {
            this.infuseManager.removeInfuse(player.getUniqueId());
        } else {
            this.infuseManager.removeSecondInfuse(player.getUniqueId());
        }
        ItemStack item = this.getEffectItem(effectName);
        if (item != null) {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        }
    }

    private String getEffectFromItem(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return null;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).toLowerCase();
        if (name.contains("feather")) {
            return "feather";
        }
        if (name.contains("speed")) {
            return "speed";
        }
        if (name.contains("emerald")) {
            return "emerald";
        }
        if (name.contains("ocean")) {
            return "ocean";
        }
        if (name.contains("fire")) {
            return "fire";
        }
        if (name.contains("haste")) {
            return "haste";
        }
        if (name.contains("strength")) {
            return "strength";
        }
        if (name.contains("heart")) {
            return "heart";
        }
        if (name.contains("invis")) {
            return "invis";
        }
        if (name.contains("regen")) {
            return "regen";
        }
        if (name.contains("frost")) {
            return "frost";
        }
        if (name.contains("thunder")) {
            return "thunder";
        }
        if (name.contains("ender")) {
            return "ender";
        }
        return null;
    }

    private boolean isPrimaryEffect(String effectName) {
        return effectName.equals("feather") || effectName.equals("haste") || effectName.equals("strength") || effectName.equals("heart") || effectName.equals("invis") || effectName.equals("regen") || effectName.equals("frost") || effectName.equals("thunder") || effectName.equals("ender");
    }

    private ItemStack getEffectItem(String effectName) {
        switch (effectName.toLowerCase()) {
            case "feather": {
                return Feather.createFeather();
            }
            case "speed": {
                return Speed.createSpeed();
            }
            case "emerald": {
                return Emerald.createEmerald();
            }
            case "ocean": {
                return Ocean.createOcean();
            }
            case "fire": {
                return Fire.createFire();
            }
            case "haste": {
                return Haste.createHaste();
            }
            case "strength": {
                return Strength.createStrength();
            }
            case "heart": {
                return Heart.createHeart();
            }
            case "invis": {
                return Invis.createInvis();
            }
            case "regen": {
                return Regen.createRegen();
            }
            case "frost": {
                return Frost.createFrost();
            }
            case "thunder": {
                return Thunder.createThunder();
            }
            case "ender": {
                return Ender.createEnder();
            }
        }
        return null;
    }

    private static String applyHexColors(String input) {
        Pattern pattern = Pattern.compile("(#(?:[0-9a-fA-F]{6}))");
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String colorCode = ChatColor.of((String)hexCode).toString();
            matcher.appendReplacement(result, colorCode);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

