/*
 * Decompiled with CFR 0.152.
 */
package org.duckiee2.Managers;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.duckiee2.Infuse;

public class InfuseManager {
    private final Infuse plugin;
    private final File file;
    private FileConfiguration config;

    public InfuseManager(Infuse plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "player_effects.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadConfig();
    }

    private void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setInfuse(UUID playerUUID, String infuse) {
        this.config.set(playerUUID.toString() + ".Primary", (Object)infuse);
        this.saveConfig();
    }

    public String getInfuse(UUID playerUUID) {
        return this.config.getString(playerUUID.toString() + ".Primary", null);
    }

    public void removeInfuse(UUID playerUUID) {
        this.config.set(playerUUID.toString() + ".Primary", null);
        this.saveConfig();
    }

    public void setSecondInfuse(UUID playerUUID, String infuse) {
        this.config.set(playerUUID.toString() + ".Support", (Object)infuse);
        this.saveConfig();
    }

    public String getSecondInfuse(UUID playerUUID) {
        return this.config.getString(playerUUID.toString() + ".Support", null);
    }

    public void removeSecondInfuse(UUID playerUUID) {
        this.config.set(playerUUID.toString() + ".Support", null);
        this.saveConfig();
    }
}

