/*
 * Decompiled with CFR 0.152.
 */
package jagm.tagtooltips;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class TagTooltips {
    public static final String MOD_ID = "tagtooltips";
    public static final KeyMapping SHOW_TAG_TOOLTIP_KEY = new KeyMapping("key.tagtooltips.show_tag_tooltip", 59, KeyMapping.Category.MISC);
    private static final Style TITLES = Style.EMPTY.withColor(0xFFFFA0);
    private static final Style GREYED = Style.EMPTY.withColor(0xA0A0A0).withItalic(Boolean.valueOf(true));
    private static final Comparator<TagKey<?>> TAG_COMPARATOR = Comparator.comparing(key -> key.location().toString());

    public static void onKey(KeyEvent key, boolean down) {
        if (InputConstants.getKey((KeyEvent)key) != InputConstants.UNKNOWN && SHOW_TAG_TOOLTIP_KEY.matches(key)) {
            SHOW_TAG_TOOLTIP_KEY.setDown(down);
        }
    }

    public static void clearTooltip(List<?> tooltip) {
        while (tooltip.size() > 1) {
            tooltip.removeLast();
        }
    }

    private static <T> String tagToTranslationKey(TagKey<T> tag, String title) {
        String label = tag.location().toString();
        String[] split = label.split(":");
        if (split.length < 2) {
            return "tag." + title + ".minecraft." + label.replace("/", ".");
        }
        return "tag." + title + "." + split[0] + "." + split[1].replace("/", ".");
    }

    private static <T> void addTags(Consumer<Component> tooltip, List<TagKey<T>> tags, String title) {
        if (!tags.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)("tooltip.tagtooltips." + title)).setStyle(TITLES));
            for (TagKey<T> tag : tags) {
                MutableComponent translation = Component.translatableWithFallback((String)TagTooltips.tagToTranslationKey(tag, title), (String)"");
                if (translation.getString().isEmpty()) {
                    tooltip.accept((Component)Component.translatable((String)"tooltip.tagtooltips.tag", (Object[])new Object[]{Component.literal((String)tag.location().toString()).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GRAY));
                    continue;
                }
                tooltip.accept((Component)Component.translatable((String)"tooltip.tagtooltips.tag_translatable", (Object[])new Object[]{Component.literal((String)tag.location().toString()).withStyle(ChatFormatting.WHITE), translation}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public static void onMakeTooltip(ItemStack stack, Runnable clearTooltip, Consumer<Component> tooltip, Function<ItemStack, Fluid> getFluid, Function<EntityType<?>, Stream<TagKey<EntityType<?>>>> tagsFromEntityType) {
        if (SHOW_TAG_TOOLTIP_KEY.isDown()) {
            clearTooltip.run();
            ArrayList itemTags = new ArrayList(stack.getTags().toList());
            itemTags.sort(TAG_COMPARATOR);
            ArrayList blockTags = new ArrayList();
            ArrayList poiTags = new ArrayList();
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                BlockState blockState = blockItem.getBlock().defaultBlockState();
                blockTags.addAll(blockState.getTags().toList());
                blockTags.sort(TAG_COMPARATOR);
                Optional poiTypeHolder = PoiTypes.forState((BlockState)blockState);
                if (poiTypeHolder.isPresent()) {
                    poiTags.addAll(((Holder)poiTypeHolder.get()).tags().toList());
                    poiTags.sort(TAG_COMPARATOR);
                }
            }
            ArrayList fluidTags = new ArrayList();
            Fluid fluid = getFluid.apply(stack);
            if (fluid != null) {
                fluidTags.addAll(fluid.defaultFluidState().getTags().toList());
                fluidTags.sort(TAG_COMPARATOR);
            }
            ArrayList entityTags = new ArrayList();
            Item item2 = stack.getItem();
            if (item2 instanceof SpawnEggItem) {
                SpawnEggItem spawnEgg = (SpawnEggItem)item2;
                entityTags.addAll(tagsFromEntityType.apply(spawnEgg.getType(stack)).toList());
                entityTags.sort(TAG_COMPARATOR);
            }
            ArrayList enchantmentTags = new ArrayList();
            List stackEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet().stream().toList();
            if (stackEnchantments.size() == 1) {
                enchantmentTags.addAll(((Holder)stackEnchantments.getFirst()).tags().toList());
                enchantmentTags.sort(TAG_COMPARATOR);
            }
            if (itemTags.isEmpty() && blockTags.isEmpty() && entityTags.isEmpty() && enchantmentTags.isEmpty()) {
                tooltip.accept((Component)Component.translatable((String)"tooltip.tagtooltips.no_tags").setStyle(GREYED));
            } else {
                TagTooltips.addTags(tooltip, fluidTags, "fluid");
                TagTooltips.addTags(tooltip, poiTags, "poi_type");
                TagTooltips.addTags(tooltip, blockTags, "block");
                TagTooltips.addTags(tooltip, entityTags, "entity_type");
                TagTooltips.addTags(tooltip, enchantmentTags, "enchantment");
                if (stackEnchantments.size() > 1) {
                    tooltip.accept((Component)Component.translatable((String)"tooltip.tagtooltips.enchantment").setStyle(TITLES));
                    tooltip.accept((Component)Component.translatable((String)"tooltip.tagtooltips.multiple_enchantments").setStyle(GREYED));
                }
                TagTooltips.addTags(tooltip, itemTags, "item");
            }
        }
    }
}

