/*
 * Decompiled with CFR 0.152.
 */
package jagm.tagtooltips;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7477;

public class TagTooltips {
    public static final String MOD_ID = "tagtooltips";
    public static final class_304 SHOW_TAG_TOOLTIP_KEY = new class_304("key.tagtooltips.show_tag_tooltip", 59, "key.categories.misc");
    private static final class_2583 TITLES = class_2583.field_24360.method_36139(0xFFFFA0);
    private static final class_2583 GREYED = class_2583.field_24360.method_36139(0xA0A0A0).method_10978(Boolean.valueOf(true));
    private static final Comparator<class_6862<?>> TAG_COMPARATOR = Comparator.comparing(key -> key.comp_327().toString());

    public static void onKey(int key, boolean down) {
        if (class_3675.method_15985((int)key, (int)0) != class_3675.field_16237 && SHOW_TAG_TOOLTIP_KEY.method_1417(key, 0)) {
            SHOW_TAG_TOOLTIP_KEY.method_23481(down);
        }
    }

    public static void clearTooltip(List<?> tooltip) {
        while (tooltip.size() > 1) {
            tooltip.removeLast();
        }
    }

    private static <T> String tagToTranslationKey(class_6862<T> tag, String title) {
        String label = tag.comp_327().toString();
        String[] split = label.split(":");
        if (split.length < 2) {
            return "tag." + title + ".minecraft." + label.replace("/", ".");
        }
        return "tag." + title + "." + split[0] + "." + split[1].replace("/", ".");
    }

    private static <T> void addTags(Consumer<class_2561> tooltip, List<class_6862<T>> tags, String title) {
        if (!tags.isEmpty()) {
            tooltip.accept((class_2561)class_2561.method_43471((String)("tooltip.tagtooltips." + title)).method_10862(TITLES));
            for (class_6862<T> tag : tags) {
                class_5250 translation = class_2561.method_48321((String)TagTooltips.tagToTranslationKey(tag, title), (String)"");
                if (translation.getString().isEmpty()) {
                    tooltip.accept((class_2561)class_2561.method_43469((String)"tooltip.tagtooltips.tag", (Object[])new Object[]{class_2561.method_43470((String)tag.comp_327().toString()).method_27692(class_124.field_1068)}).method_27692(class_124.field_1080));
                    continue;
                }
                tooltip.accept((class_2561)class_2561.method_43469((String)"tooltip.tagtooltips.tag_translatable", (Object[])new Object[]{class_2561.method_43470((String)tag.comp_327().toString()).method_27692(class_124.field_1068), translation}).method_27692(class_124.field_1080));
            }
        }
    }

    public static void onMakeTooltip(class_1799 stack, Runnable clearTooltip, Consumer<class_2561> tooltip, Function<class_1799, class_3611> getFluid, Function<class_1299<?>, Stream<class_6862<class_1299<?>>>> tagsFromEntityType) {
        if (SHOW_TAG_TOOLTIP_KEY.method_1434()) {
            clearTooltip.run();
            ArrayList itemTags = new ArrayList(stack.method_40133().toList());
            itemTags.sort(TAG_COMPARATOR);
            ArrayList blockTags = new ArrayList();
            ArrayList poiTags = new ArrayList();
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2680 blockState = blockItem.method_7711().method_9564();
                blockTags.addAll(blockState.method_40144().toList());
                blockTags.sort(TAG_COMPARATOR);
                Optional poiTypeHolder = class_7477.method_43989((class_2680)blockState);
                if (poiTypeHolder.isPresent()) {
                    poiTags.addAll(((class_6880)poiTypeHolder.get()).method_40228().toList());
                    poiTags.sort(TAG_COMPARATOR);
                }
            }
            ArrayList fluidTags = new ArrayList();
            class_3611 fluid = getFluid.apply(stack);
            if (fluid != null) {
                fluidTags.addAll(fluid.method_15785().method_40181().toList());
                fluidTags.sort(TAG_COMPARATOR);
            }
            ArrayList entityTags = new ArrayList();
            class_1792 class_17923 = stack.method_7909();
            if (class_17923 instanceof class_1826) {
                class_1826 spawnEgg = (class_1826)class_17923;
                class_638 level = class_310.method_1551().field_1687;
                if (level != null) {
                    entityTags.addAll(tagsFromEntityType.apply(spawnEgg.method_8015((class_7225.class_7874)level.method_30349(), stack)).toList());
                    entityTags.sort(TAG_COMPARATOR);
                }
            }
            ArrayList enchantmentTags = new ArrayList();
            List stackEnchantments = class_1890.method_57532((class_1799)stack).method_57534().stream().toList();
            if (stackEnchantments.size() == 1) {
                enchantmentTags.addAll(((class_6880)stackEnchantments.getFirst()).method_40228().toList());
                enchantmentTags.sort(TAG_COMPARATOR);
            }
            if (itemTags.isEmpty() && blockTags.isEmpty() && entityTags.isEmpty() && enchantmentTags.isEmpty()) {
                tooltip.accept((class_2561)class_2561.method_43471((String)"tooltip.tagtooltips.no_tags").method_10862(GREYED));
            } else {
                TagTooltips.addTags(tooltip, fluidTags, "fluid");
                TagTooltips.addTags(tooltip, poiTags, "poi_type");
                TagTooltips.addTags(tooltip, blockTags, "block");
                TagTooltips.addTags(tooltip, entityTags, "entity_type");
                TagTooltips.addTags(tooltip, enchantmentTags, "enchantment");
                if (stackEnchantments.size() > 1) {
                    tooltip.accept((class_2561)class_2561.method_43471((String)"tooltip.tagtooltips.enchantment").method_10862(TITLES));
                    tooltip.accept((class_2561)class_2561.method_43471((String)"tooltip.tagtooltips.multiple_enchantments").method_10862(GREYED));
                }
                TagTooltips.addTags(tooltip, itemTags, "item");
            }
        }
    }
}

