/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.thedustbuster.CarpetExtraExtrasSettings;
import net.thedustbuster.commands.CEE_Command;
import net.thedustbuster.commands.CamCommand;
import net.thedustbuster.rules.CEE_Rule;
import net.thedustbuster.rules.CarpetBotTeam;
import net.thedustbuster.rules.PearlTracking;
import net.thedustbuster.util.func.option.Option;
import net.thedustbuster.util.minecraft.TickDelayManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CarpetExtraExtrasServer
implements CarpetExtension,
ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"carpet-extra-extras");
    private static final List<CEE_Rule> rules = new ArrayList<CEE_Rule>();
    private static final List<CEE_Command> commands = new ArrayList<CEE_Command>();

    private static void registerRule(CEE_Rule c) {
        rules.add(c);
    }

    private static void registerCommand(CEE_Command c) {
        commands.add(c);
    }

    public static Option<MinecraftServer> getMinecraftServer() {
        return Option.of(CarpetServer.minecraft_server).filter(MinecraftServer::method_3820);
    }

    public String version() {
        return "carpet-extra-extras";
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)this);
        CarpetExtraExtrasServer.registerRule(CarpetBotTeam.INSTANCE);
        CarpetExtraExtrasServer.registerRule(PearlTracking.INSTANCE);
    }

    public void onServerLoaded(MinecraftServer server) {
        CarpetExtraExtrasServer.registerCommand(CamCommand.INSTANCE);
        commands.forEach(c -> c.register((CommandDispatcher<class_2168>)server.method_3734().method_9235()));
    }

    public void onTick(MinecraftServer server) {
        rules.forEach(CEE_Rule::onTick);
        TickDelayManager.tick();
    }

    public void onPlayerLoggedIn(class_3222 player) {
        rules.forEach(rule -> rule.onPlayerLoggedIn(player));
    }

    public void onPlayerLoggedOut(class_3222 player) {
        rules.forEach(rule -> rule.onPlayerLoggedOut(player));
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(CarpetExtraExtrasSettings.class);
        rules.forEach(CEE_Rule::onGameStarted);
    }

    public Map<String, String> canHasTranslations(String lang) {
        String jsonData;
        InputStream langFile = CarpetExtraExtrasServer.class.getClassLoader().getResourceAsStream("assets/carpet-extra-extras/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Collections.emptyMap();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().create();
        return (Map)gson.fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }
}

