/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.rules;

import carpet.CarpetServer;
import carpet.patches.EntityPlayerMPFake;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_3222;
import net.thedustbuster.CarpetExtraExtrasSettings;
import net.thedustbuster.adaptors.carpet.LoggerHelper;
import net.thedustbuster.rules.CEE_Rule;
import net.thedustbuster.util.func.option.Option;
import net.thedustbuster.util.minecraft.TextBuilder;

public final class CarpetBotTeam
implements CEE_Rule {
    public static final CarpetBotTeam INSTANCE = new CarpetBotTeam();
    private static Option<class_268> team = Option.empty();

    public static int getBots() {
        return CarpetBotTeam.getBotPlayers().size();
    }

    private static class_269 getScoreboard() {
        return Option.of(CarpetServer.minecraft_server).getOrThrow(() -> new IllegalStateException("Minecraft Server is not ready")).method_3845();
    }

    @Override
    public void onPlayerLoggedIn(class_3222 player) {
        if (player instanceof EntityPlayerMPFake) {
            CarpetBotTeam.updateTeam();
        }
    }

    @Override
    public void onPlayerLoggedOut(class_3222 player) {
        if (player instanceof EntityPlayerMPFake) {
            CarpetBotTeam.updateTeam();
        }
    }

    public class_2561[] createHUD() {
        TextBuilder text = new TextBuilder().addText("Players: ", List.of(class_124.field_1068)).addText(String.valueOf(CarpetServer.minecraft_server.method_3788() - CarpetBotTeam.getBots()), List.of(class_124.field_1077)).addText(" Bots: ", List.of(class_124.field_1068)).addText(String.valueOf(CarpetBotTeam.getBots()), List.of(class_124.field_1065));
        return LoggerHelper.createText(text);
    }

    public static void updateTeam() {
        CarpetBotTeam.updateTeam(CarpetExtraExtrasSettings.carpetBotTeam);
    }

    public static void updateTeam(boolean carpetBotTeam) {
        team = Option.of(CarpetBotTeam.getScoreboard().method_1153(CarpetExtraExtrasSettings.carpetBotTeamName));
        team.whenDefined(t -> CarpetBotTeam.getScoreboard().method_1191(t));
        if (carpetBotTeam) {
            CarpetBotTeam.createTeam();
            CarpetBotTeam.updatePlayers();
        }
    }

    private static void createTeam() {
        team = Option.of(CarpetBotTeam.getScoreboard().method_1171(CarpetExtraExtrasSettings.carpetBotTeamName));
        team.whenDefined(CarpetBotTeam::updateTeamProperties);
    }

    private static void updateTeamProperties(class_268 team) {
        team.method_1138((class_2561)class_2561.method_43470((String)(CarpetExtraExtrasSettings.carpetBotTeamPrefix + " ")).method_27692(CarpetExtraExtrasSettings.carpetBotTeamPrefixColor));
        team.method_1141(CarpetExtraExtrasSettings.carpetBotTeamColor);
    }

    private static void updatePlayers() {
        CarpetBotTeam.getBotPlayers().forEach(player -> team.whenDefined(t -> CarpetBotTeam.getScoreboard().method_1172(player.method_5820(), t)));
    }

    private static Set<class_3222> getBotPlayers() {
        return Option.of(CarpetServer.minecraft_server).map(server -> StreamSupport.stream(server.method_3738().spliterator(), false).flatMap(level -> level.method_18456().stream()).filter(player -> player instanceof EntityPlayerMPFake).collect(Collectors.toSet())).orElse(Set.of());
    }
}

