/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.util.func;

import java.util.function.Function;
import net.thedustbuster.util.func.Unit;
import net.thedustbuster.util.func.checked.CheckedFunction;
import net.thedustbuster.util.func.checked.CheckedRunnable;
import net.thedustbuster.util.func.checked.CheckedSupplier;
import net.thedustbuster.util.func.option.None;
import net.thedustbuster.util.func.option.Option;

public class Attempt<T> {
    private final Option<T> value;
    private final Option<Exception> exception;

    public static <R, S> Attempt<S> create(CheckedFunction<R, S> fn, R argument) {
        return Attempt.create(() -> fn.apply(argument));
    }

    public static <S> Attempt<S> create(CheckedSupplier<S> fn) {
        try {
            return new Attempt<S>(fn.get());
        }
        catch (Exception e) {
            return new Attempt(e);
        }
    }

    public static Attempt<Unit> run(CheckedRunnable fn) {
        try {
            fn.run();
            return new Attempt<Unit>(Unit.Unit);
        }
        catch (Exception e) {
            return new Attempt<Unit>(e);
        }
    }

    public Attempt(T value) {
        this.value = Option.of(value);
        this.exception = None.None();
    }

    public Attempt(Exception e) {
        this.value = None.None();
        this.exception = Option.of(e);
    }

    public <S> Attempt<S> map(CheckedFunction<T, S> fn) {
        return this.value.map((? super T t) -> Attempt.create(fn, t)).orElseGet(() -> this);
    }

    public <S> Attempt<S> flatMap(Function<T, Attempt<S>> fn) {
        return this.value.map(fn).orElseGet(() -> this);
    }

    public <S> Attempt<S> flatMapError(Function<Exception, Attempt<S>> handler) {
        return this.exception.map(handler).orElseGet(() -> this);
    }

    public Option<T> toOption() {
        if (this.exception.isDefined()) {
            return None.None();
        }
        return this.value;
    }

    public Attempt<T> handleException(CheckedFunction<Exception, T> handler) {
        return this.exception.map((? super T e) -> Attempt.create(handler, e)).orElse(this);
    }

    public T getOrHandle(CheckedFunction<Exception, T> handler) {
        return this.handleException(handler).get();
    }

    public T orThrow(Function<Exception, RuntimeException> handler) {
        return this.value.getOrThrow(() -> (RuntimeException)handler.apply(this.exception.getOrElse(new RuntimeException("Unexpected error: no value and no exception"))));
    }

    public T get() {
        return this.value.getOrThrow(() -> this.exception.map((? super T e) -> e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException((Throwable)e)).orElse(new RuntimeException("Unexpected error: no value and no exception")));
    }
}

