/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.util.func;

import java.util.function.Function;
import net.thedustbuster.util.func.option.Option;

public class Either<L, R> {
    private final Option<L> left;
    private final Option<R> right;

    public static <L, R> Either<L, R> right(R value) {
        return new Either(Option.empty(), Option.of(value));
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Either(Option.of(value), Option.empty());
    }

    public static <L, R> Either<L, R> cond(boolean bool, L left, R right) {
        return !bool ? Either.left(left) : Either.right(right);
    }

    private Either(Option<L> left, Option<R> right) {
        this.left = left;
        this.right = right;
    }

    public boolean isRight() {
        return this.right.isEmpty();
    }

    public boolean isLeft() {
        return this.left.isEmpty();
    }

    public R getRight() {
        return this.right.getOrThrow(() -> new IllegalStateException("Tried to get right value from a left Either."));
    }

    public L getLeft() {
        return this.left.getOrThrow(() -> new IllegalStateException("Tried to get left value from a right Either."));
    }

    public <T> Either<L, T> map(Function<R, T> fn) {
        return this.right.map((? super T r) -> Either.right(fn.apply(r))).orElseGet(() -> Either.left(this.getLeft()));
    }

    public <T> Either<L, T> flatMap(Function<R, Either<L, T>> fn) {
        return this.right.map(fn).orElseGet(() -> Either.left(this.getLeft()));
    }

    public <T> Either<T, R> mapLeft(Function<L, T> fn) {
        return this.left.map((? super T l) -> Either.left(fn.apply(l))).orElseGet(() -> Either.right(this.getRight()));
    }

    public <T> Either<T, R> flatMapLeft(Function<L, Either<T, R>> fn) {
        return this.left.map(fn).orElseGet(() -> Either.right(this.getRight()));
    }

    public Either<L, R> handleLeft(Function<L, R> fn) {
        return this.left.map((? super T l) -> Either.right(fn.apply(l))).orElse(this);
    }

    public <T> T fold(Function<L, T> leftFn, Function<R, T> rightFn) {
        if (this.right.isDefined()) {
            return rightFn.apply(this.right.get());
        }
        return leftFn.apply(this.left.get());
    }
}

