/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.util.func;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.thedustbuster.util.func.Either;
import net.thedustbuster.util.func.option.None;
import net.thedustbuster.util.func.option.Option;

public final class Validator<T, B> {
    private final T raw;
    private final Option<B> builderOpt;
    private final List<String> errors = new ArrayList<String>();

    private Validator(T raw, Option<B> builderOpt) {
        this.raw = raw;
        this.builderOpt = builderOpt;
    }

    public static <T, B> Validator<T, B> of(T raw, B builder) {
        return new Validator<T, B>(raw, Option.of(builder));
    }

    public static <T> Validator<T, Void> of(T raw) {
        return new Validator(raw, None.None());
    }

    public boolean hasBuilder() {
        return this.builderOpt.isDefined();
    }

    public Either<B, List<String>> toEither() {
        return this.errors.isEmpty() ? Either.left(this.builderOrThrow()) : Either.right(this.getErrorsList());
    }

    public Either<B, List<String>> toEitherFormatted() {
        return this.errors.isEmpty() ? Either.left(this.builderOrThrow()) : Either.right(this.getErrors());
    }

    public List<String> getErrorsList() {
        return List.copyOf(this.errors);
    }

    public List<String> getErrors() {
        if (this.errors.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        this.errors.forEach(e -> {
            if (e.contains("\n")) {
                Stream.of(e.split("\n")).filter(line -> !line.isBlank()).forEach(line -> sb.append("  ").append((String)line).append("\n"));
            } else {
                sb.append("  ").append((String)e).append("\n");
            }
        });
        return List.of(sb.toString());
    }

    private B builderOrThrow() {
        return this.builderOpt.getOrThrow(() -> new IllegalStateException("Builder is required"));
    }

    private Validator<T, B> recordError(Supplier<String> errorSupplier) {
        this.errors.add(errorSupplier.get());
        return this;
    }

    private Validator<T, B> recordIfFalse(boolean cond, Supplier<String> errorSupplier) {
        if (!cond) {
            this.errors.add(errorSupplier.get());
        }
        return this;
    }

    public Validator<T, B> check(boolean cond, String error) {
        return this.recordIfFalse(cond, () -> error);
    }

    public Validator<T, B> check(boolean cond, Supplier<String> errorMessageFn) {
        return this.recordIfFalse(cond, errorMessageFn);
    }

    public Validator<T, B> checkAndApply(boolean cond, Supplier<String> errorMessageFn, Consumer<B> onSuccess) {
        if (!cond) {
            return this.recordError(errorMessageFn);
        }
        onSuccess.accept(this.builderOrThrow());
        return this;
    }

    public Validator<T, B> require(boolean cond, String error) {
        return this.recordIfFalse(cond, () -> error);
    }

    public Validator<T, B> require(boolean cond, Supplier<String> errorMessageFn) {
        return this.recordIfFalse(cond, errorMessageFn);
    }

    public Validator<T, B> requireAndApply(boolean cond, Supplier<String> errorMessageFn, Consumer<B> onSuccess) {
        if (!cond) {
            return this.recordError(errorMessageFn);
        }
        onSuccess.accept(this.builderOrThrow());
        return this;
    }

    public <U> Validator<T, B> requiredOption(Option<U> maybe, String errorIfMissing) {
        return this.recordIfFalse(maybe.isDefined(), () -> errorIfMissing);
    }

    public <U> Validator<T, B> requireAndApplyOption(Option<U> maybe, Supplier<String> errorIfMissing, BiConsumer<B, U> onSuccess) {
        if (maybe.isEmpty()) {
            return this.recordError(errorIfMissing);
        }
        onSuccess.accept(this.builderOrThrow(), maybe.get());
        return this;
    }

    public <U, R> Validator<T, B> requireAndApplyOption(Option<U> maybe, Function<U, Option<R>> extractor, Function<Option<U>, String> errorMessageFn, String errorIfMissing, BiConsumer<B, R> onSuccess) {
        if (maybe.isEmpty()) {
            return this.recordError(() -> errorIfMissing);
        }
        Option<R> result = extractor.apply(maybe.get());
        if (result.isEmpty()) {
            return this.recordError(() -> (String)errorMessageFn.apply(maybe));
        }
        onSuccess.accept(this.builderOrThrow(), result.get());
        return this;
    }

    public <U, R> Validator<T, B> requireOptionMap(Option<? extends Collection<U>> maybeValues, Function<U, Option<R>> extractor, BiFunction<U, Integer, String> errorMessageFn, Supplier<String> errorIfMissing, BiConsumer<B, R> onSuccess) {
        if (maybeValues.isEmpty()) {
            return this.recordError(errorIfMissing);
        }
        maybeValues.whenDefined(coll -> {
            int i = 0;
            for (Object u : coll) {
                Option result = (Option)extractor.apply(u);
                if (result.isDefined()) {
                    onSuccess.accept(this.builderOrThrow(), result.get());
                } else {
                    this.errors.add((String)errorMessageFn.apply(u, i));
                }
                ++i;
            }
        });
        return this;
    }

    public <U> Validator<T, B> passOption(Option<U> maybe, BiConsumer<B, Option<U>> onSuccess) {
        onSuccess.accept(this.builderOrThrow(), maybe);
        return this;
    }

    public <U> Validator<T, B> checkOption(Option<U> maybe, Predicate<U> pred, Supplier<String> errorMessageFn) {
        maybe.whenDefined(u -> {
            if (!pred.test(u)) {
                this.errors.add((String)errorMessageFn.get());
            }
        });
        return this;
    }

    public <U> Validator<T, B> checkAndApplyOption(Option<U> maybe, BiConsumer<B, U> onSuccess) {
        maybe.whenDefined(o -> onSuccess.accept(this.builderOrThrow(), o));
        return this;
    }

    public <U, R> Validator<T, B> checkAndApplyOption(Option<U> maybe, Function<U, Option<R>> extractor, Function<U, String> errorMessageFn, BiConsumer<B, Option<R>> onSuccess) {
        Option result = maybe.flatMap(extractor);
        if (maybe.isDefined() && result.isEmpty()) {
            this.errors.add(errorMessageFn.apply(maybe.get()));
        }
        this.builderOpt.whenDefined(b -> onSuccess.accept(b, maybe.fold(__ -> result, None::None)));
        return this;
    }

    public <U> Validator<T, B> checkForEach(Collection<U> values, BiConsumer<U, Validator<T, B>> fn) {
        values.forEach(u -> fn.accept(u, this));
        return this;
    }

    public <U> Validator<T, B> checkOptionForEach(Option<? extends Collection<U>> maybeValues, BiConsumer<U, Validator<T, B>> fn) {
        maybeValues.whenDefined(coll -> this.checkForEach((Collection)coll, fn));
        return this;
    }

    public <U, R> Validator<T, B> checkOptionMap(Option<? extends Collection<U>> maybeValues, Function<U, Option<R>> extractor, BiFunction<U, Integer, String> errorMessageFn, BiConsumer<B, R> onSuccess) {
        maybeValues.whenDefined(coll -> {
            int i = 0;
            for (Object u : coll) {
                Option result = (Option)extractor.apply(u);
                if (result.isDefined()) {
                    onSuccess.accept(this.builderOrThrow(), result.get());
                } else {
                    this.errors.add((String)errorMessageFn.apply(u, i));
                }
                ++i;
            }
        });
        return this;
    }

    public <U, B2> Validator<T, B> validate(U u, Function<U, Validator<U, B2>> nestedValidator) {
        this.errors.addAll(nestedValidator.apply(u).getErrors());
        return this;
    }

    public <U, B2> Validator<T, B> validateAndApply(U u, Function<U, Validator<U, B2>> nestedValidator, BiConsumer<B2, B> onSuccess) {
        Validator<U, B2> nested = nestedValidator.apply(u);
        if (nested.getErrors().isEmpty()) {
            onSuccess.accept(nested.builderOrThrow(), this.builderOrThrow());
        } else {
            this.errors.addAll(nested.getErrors());
        }
        return this;
    }

    public <U, B2> Validator<T, B> validateOption(Option<U> maybeValue, Function<U, Validator<U, B2>> nestedValidator, Function<U, String> errorMessageFn, BiConsumer<B2, B> onSuccess) {
        maybeValue.whenDefined(value -> {
            Validator nested = (Validator)nestedValidator.apply(value);
            if (nested.getErrors().isEmpty()) {
                onSuccess.accept(nested.builderOrThrow(), this.builderOrThrow());
            } else {
                errorMessageFn.apply(maybeValue.get());
                this.errors.addAll(nested.getErrors());
            }
        });
        return this;
    }

    public <U, B2> Validator<T, B> requireValidateOption(Option<U> maybeValue, Function<U, Validator<U, B2>> nestedValidator, BiConsumer<B2, B> onSuccess, Supplier<String> errorIfMissing) {
        if (maybeValue.isEmpty()) {
            return this.recordError(errorIfMissing);
        }
        Validator<U, B2> nested = nestedValidator.apply(maybeValue.get());
        if (nested.getErrors().isEmpty()) {
            onSuccess.accept(nested.builderOrThrow(), this.builderOrThrow());
        } else {
            this.errors.addAll(nested.getErrors());
        }
        return this;
    }

    public <U, B2> Validator<T, B> validateOptionMap(Option<? extends Collection<U>> maybeValues, Function<U, Validator<U, B2>> nestedValidator, BiFunction<U, Integer, String> errorMessageFn, BiConsumer<B2, B> onSuccess) {
        maybeValues.whenDefined(coll -> {
            int i = 0;
            for (Object u : coll) {
                Validator nested = (Validator)nestedValidator.apply(u);
                List<String> nestedErrors = nested.getErrors();
                if (nestedErrors.isEmpty()) {
                    onSuccess.accept(nested.builderOrThrow(), this.builderOrThrow());
                } else {
                    this.errors.add((String)errorMessageFn.apply(u, i));
                    this.errors.addAll(nestedErrors);
                }
                ++i;
            }
        });
        return this;
    }

    public <U, B2> Validator<T, B> requireValidateOptionMap(Option<? extends Collection<U>> maybeValues, Function<U, Validator<U, B2>> nestedValidator, BiFunction<U, Integer, String> errorMessageFn, String errorIfMissing, BiConsumer<B2, B> onSuccess) {
        if (maybeValues.isEmpty()) {
            return this.recordError(() -> errorIfMissing);
        }
        maybeValues.whenDefined(coll -> {
            int i = 0;
            for (Object u : coll) {
                Validator nested = (Validator)nestedValidator.apply(u);
                List<String> nestedErrors = nested.getErrors();
                if (nestedErrors.isEmpty()) {
                    onSuccess.accept(nested.builderOrThrow(), this.builderOrThrow());
                } else {
                    this.errors.add((String)errorMessageFn.apply(u, i));
                    this.errors.addAll(nestedErrors);
                }
                ++i;
            }
        });
        return this;
    }
}

