/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.util.func.option;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thedustbuster.util.func.option.None;
import net.thedustbuster.util.func.option.Some;

public abstract class Option<T> {
    public static <T> Option<T> of(T value) {
        return value != null && !(value instanceof None) ? Some.Some(value) : None.None();
    }

    public static <T> Option<T> of(Optional<T> optional) {
        return optional != null && optional.isPresent() ? Some.Some(optional.get()) : None.None();
    }

    public static <T> Option<T> safe(Option<T> option) {
        return option == null ? None.None() : option;
    }

    public static <T> Option<T> empty() {
        return None.None();
    }

    public abstract T get();

    public abstract T orElse(T var1);

    public abstract T getOrElse(T var1);

    public abstract T orElseGet(Supplier<? extends T> var1);

    public abstract <E extends Throwable> T getOrThrow(Supplier<? extends E> var1) throws E;

    public abstract <U> U fold(Function<T, U> var1, Supplier<U> var2);

    public abstract Option<T> whenDefined(Consumer<T> var1);

    public abstract Option<T> whenDefined(Runnable var1);

    public abstract boolean isDefined();

    public abstract void isDefinedOrElse(Consumer<? super T> var1, Runnable var2);

    public abstract Option<T> whenEmpty(Runnable var1);

    public abstract boolean isEmpty();

    public abstract <U> Option<U> map(Function<? super T, ? extends U> var1);

    public abstract <U> Option<U> flatMap(Function<? super T, Option<U>> var1);

    public abstract Option<T> filter(Predicate<? super T> var1);
}

