/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.util.func.option;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thedustbuster.util.func.option.Option;
import org.jetbrains.annotations.NotNull;

public final class Some<T>
extends Option<T> {
    private final T value;

    private Some(@NotNull T value) {
        this.value = Objects.requireNonNull(value, "Value cannot be null");
    }

    public static <T> Option<T> Some(@NotNull T value) {
        return new Some<T>(Objects.requireNonNull(value, "Value cannot be null"));
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public T orElse(T other) {
        return this.value;
    }

    @Override
    public T getOrElse(T defaultValue) {
        return this.value;
    }

    @Override
    public T orElseGet(Supplier<? extends T> supplier) {
        return this.value;
    }

    @Override
    public <E extends Throwable> T getOrThrow(Supplier<? extends E> exceptionSupplier) {
        return this.value;
    }

    @Override
    public <U> U fold(Function<T, U> mapper, Supplier<U> defaultValue) {
        return mapper.apply(this.value);
    }

    @Override
    public Option<T> whenDefined(Consumer<T> consumer) {
        consumer.accept(this.value);
        return this;
    }

    @Override
    public Option<T> whenDefined(Runnable runnable) {
        runnable.run();
        return this;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public void isDefinedOrElse(Consumer<? super T> consumer, Runnable runnable) {
        consumer.accept(this.value);
    }

    @Override
    public Option<T> whenEmpty(Runnable runnable) {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public <U> Option<U> map(Function<? super T, ? extends U> mapper) {
        return Option.of(mapper.apply(this.value));
    }

    @Override
    public <U> Option<U> flatMap(Function<? super T, Option<U>> mapper) {
        return mapper.apply(this.value);
    }

    @Override
    public Option<T> filter(Predicate<? super T> predicate) {
        return predicate.test(this.value) ? this : Option.empty();
    }

    public String toString() {
        return "Some(" + String.valueOf(this.value) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class}, (Object)object2, n)) {
            case 0 -> {
                Some o = (Some)object2;
                yield Objects.equals(this.value, o.value);
            }
            default -> false;
        };
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

