/*
 * Decompiled with CFR 0.152.
 */
package com.angelofcreation.pet_necropolis.compat;

import com.angelofcreation.pet_necropolis.compat.ACECompat;
import com.github.alexmodguy.alexscaves.server.entity.living.CandicornEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VallumraptorEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.fml.ModList;

public class ACCompat {
    public static int getVariantTag(LivingEntity entity) {
        int variant = 0;
        if (entity instanceof DinosaurEntity) {
            DinosaurEntity dinosaur = (DinosaurEntity)entity;
            variant = dinosaur.getAltSkin();
        }
        if (entity instanceof VallumraptorEntity) {
            VallumraptorEntity vallumraptor = (VallumraptorEntity)entity;
            variant = (vallumraptor.isElder() ? 1 : 0) << 2 | vallumraptor.getAltSkin();
        }
        if (entity instanceof CandicornEntity) {
            CandicornEntity candicorn = (CandicornEntity)entity;
            variant = candicorn.getVariant();
        }
        if (ModList.get().isLoaded("alexscavesexemplified") && entity instanceof TremorzillaEntity) {
            TremorzillaEntity tremorzilla = (TremorzillaEntity)entity;
            variant = ACECompat.getVariantTag(tremorzilla);
        }
        return variant;
    }

    public static int getCollarTag(LivingEntity entity) {
        if (entity instanceof DinosaurEntity) {
            DinosaurEntity dinosaur = (DinosaurEntity)entity;
            switch (dinosaur.getAltSkin()) {
                case 1: {
                    return DyeColor.PURPLE.m_41060_();
                }
                case 2: {
                    return DyeColor.ORANGE.m_41060_();
                }
            }
        }
        if (entity instanceof CandicornEntity) {
            return DyeColor.PINK.m_41060_();
        }
        return 14;
    }

    public static TamableAnimal getRespawnedEntity(TamableAnimal pet, CompoundTag tag) {
        if (pet instanceof DinosaurEntity) {
            DinosaurEntity dinosaur = (DinosaurEntity)pet;
            dinosaur.setAltSkin(tag.m_128451_("PetVariant"));
            pet = dinosaur;
        }
        if (pet instanceof VallumraptorEntity) {
            VallumraptorEntity vallumraptor = (VallumraptorEntity)pet;
            vallumraptor.setElder(tag.m_128451_("PetVariant") >>> 2 == 1);
            vallumraptor.setAltSkin(tag.m_128451_("PetVariant") & 3);
            return vallumraptor;
        }
        if (pet instanceof CandicornEntity) {
            CandicornEntity candicorn = (CandicornEntity)pet;
            candicorn.setVariant(tag.m_128451_("PetVariant"));
            return candicorn;
        }
        if (ModList.get().isLoaded("alexscavesexemplified") && pet instanceof TremorzillaEntity) {
            TremorzillaEntity tremorzilla = (TremorzillaEntity)pet;
            return ACECompat.getRespawnedEntity(tremorzilla, tag);
        }
        return pet;
    }

    public static String getVariantTranslatable(LivingEntity pet, CompoundTag tag) {
        String variant = "";
        if (pet instanceof DinosaurEntity && !(pet instanceof VallumraptorEntity)) {
            switch (tag.m_128451_("PetVariant")) {
                case 1: {
                    variant = Component.m_237115_((String)"variant.alexscaves.dinosaur.retro").getString();
                    break;
                }
                case 2: {
                    variant = Component.m_237115_((String)"variant.alexscaves.dinosaur.tectonic").getString();
                }
            }
        }
        if (pet instanceof VallumraptorEntity) {
            switch (tag.m_128451_("PetVariant") & 3) {
                case 1: {
                    variant = Component.m_237115_((String)"variant.alexscaves.dinosaur.retro").getString();
                    break;
                }
                case 2: {
                    variant = Component.m_237115_((String)"variant.alexscaves.dinosaur.tectonic").getString();
                }
            }
            variant = tag.m_128451_("PetVariant") >>> 2 == 1 ? variant + " " + Component.m_237115_((String)"variant.alexscaves.vallumraptor.elder").getString() : variant;
            variant = variant.stripLeading();
        }
        if (pet instanceof CandicornEntity) {
            switch (tag.m_128451_("PetVariant")) {
                case 0: {
                    variant = Component.m_237115_((String)"variant.alexscaves.candicorn.candy_corn").getString();
                    break;
                }
                case 1: {
                    variant = Component.m_237115_((String)"variant.alexscaves.candicorn.peppermint").getString();
                    break;
                }
                case 2: {
                    variant = Component.m_237115_((String)"variant.alexscaves.candicorn.mint_chocolate_chip").getString();
                    break;
                }
                case 3: {
                    variant = Component.m_237115_((String)"variant.alexscaves.candicorn.popsicle").getString();
                    break;
                }
                case 4: {
                    variant = Component.m_237115_((String)"variant.alexscaves.candicorn.cotton_candy").getString();
                }
            }
        }
        if (ModList.get().isLoaded("alexscavesexemplified") && pet instanceof TremorzillaEntity) {
            switch (tag.m_128451_("PetVariant") & 3) {
                case 1: {
                    variant = Component.m_237115_((String)"variant.alexscaves.dinosaur.retro").getString();
                    break;
                }
                case 2: {
                    variant = Component.m_237115_((String)"variant.alexscaves.dinosaur.tectonic").getString();
                }
            }
            variant = tag.m_128451_("PetVariant") >>> 2 == 1 ? variant + " " + Component.m_237115_((String)"variant.alexscavesexemplified.tremorzilla.gammafied").getString() : variant;
            variant = variant.stripLeading();
        }
        return variant;
    }
}

