/*
 * Decompiled with CFR 0.152.
 */
package com.angelofcreation.pet_necropolis.compat;

import com.github.alexthe666.alexsmobs.entity.EntityCapuchinMonkey;
import com.github.alexthe666.alexsmobs.entity.EntityCrocodile;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityGorilla;
import com.github.alexthe666.alexsmobs.entity.EntityMantisShrimp;
import com.github.alexthe666.alexsmobs.entity.EntityTarantulaHawk;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;

public class AMCompat {
    public static int getVariantTag(LivingEntity entity) {
        if (entity instanceof EntityTarantulaHawk) {
            EntityTarantulaHawk tarantulaHawk = (EntityTarantulaHawk)entity;
            return tarantulaHawk.isNether() ? 1 : 0;
        }
        if (entity instanceof EntityElephant) {
            EntityElephant elephant = (EntityElephant)entity;
            return (elephant.isTusked() ? 1 : 0) << 1 | (elephant.isTrader() ? 1 : 0);
        }
        if (entity instanceof EntityCapuchinMonkey) {
            EntityCapuchinMonkey capuchinMonkey = (EntityCapuchinMonkey)entity;
            return capuchinMonkey.getVariant();
        }
        if (entity instanceof EntityCrocodile) {
            EntityCrocodile crocodile = (EntityCrocodile)entity;
            return crocodile.isDesert() ? 1 : 0;
        }
        if (entity instanceof EntityMantisShrimp) {
            EntityMantisShrimp mantisShrimp = (EntityMantisShrimp)entity;
            return mantisShrimp.getVariant();
        }
        if (entity instanceof EntityGorilla) {
            EntityGorilla gorilla = (EntityGorilla)entity;
            return gorilla.isSilverback() ? 1 : 0;
        }
        return 0;
    }

    public static TamableAnimal getRespawnedEntity(TamableAnimal pet, CompoundTag tag) {
        if (pet instanceof EntityTarantulaHawk) {
            EntityTarantulaHawk tarantulaHawk = (EntityTarantulaHawk)pet;
            tarantulaHawk.setNether(tag.m_128451_("PetVariant") == 1);
            return tarantulaHawk;
        }
        if (pet instanceof EntityElephant) {
            EntityElephant elephant = (EntityElephant)pet;
            elephant.setTusked(tag.m_128451_("PetVariant") >>> 1 == 1);
            elephant.setTrader((tag.m_128451_("PetVariant") & 1) == 1);
            return elephant;
        }
        if (pet instanceof EntityCapuchinMonkey) {
            EntityCapuchinMonkey capuchinMonkey = (EntityCapuchinMonkey)pet;
            capuchinMonkey.setVariant(tag.m_128451_("PetVariant"));
            return capuchinMonkey;
        }
        if (pet instanceof EntityCrocodile) {
            EntityCrocodile crocodile = (EntityCrocodile)pet;
            crocodile.setDesert(tag.m_128451_("PetVariant") == 1);
            return crocodile;
        }
        if (pet instanceof EntityMantisShrimp) {
            EntityMantisShrimp mantisShrimp = (EntityMantisShrimp)pet;
            mantisShrimp.setVariant(tag.m_128451_("PetVariant"));
            return mantisShrimp;
        }
        if (pet instanceof EntityGorilla) {
            EntityGorilla gorilla = (EntityGorilla)pet;
            gorilla.setSilverback(tag.m_128451_("PetVariant") == 1);
            return gorilla;
        }
        return pet;
    }

    public static String getVariantTranslatable(LivingEntity pet, CompoundTag tag) {
        String variant = "";
        if (pet instanceof EntityTarantulaHawk) {
            return tag.m_128451_("PetVariant") == 1 ? Component.m_237115_((String)"variant.alexsmobs.tarantula_hawk.nether").getString() : "";
        }
        if (pet instanceof EntityElephant) {
            variant = tag.m_128451_("PetVariant") >>> 1 == 1 ? Component.m_237115_((String)"variant.alexsmobs.elephant.tusked").getString() : "";
            variant = (tag.m_128451_("PetVariant") & 1) == 1 ? variant + " " + Component.m_237115_((String)"variant.alexsmobs.elephant.trader").getString() : variant;
            variant = variant.stripLeading();
        }
        if (pet instanceof EntityCapuchinMonkey) {
            switch (tag.m_128451_("PetVariant")) {
                case 0: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.capuchin_monkey.white_faced").getString();
                    break;
                }
                case 1: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.capuchin_monkey.blonde").getString();
                    break;
                }
                case 2: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.capuchin_monkey.chestnut").getString();
                    break;
                }
                case 3: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.capuchin_monkey.tufted").getString();
                }
            }
        }
        if (pet instanceof EntityCrocodile) {
            String string = variant = tag.m_128451_("PetVariant") == 1 ? Component.m_237115_((String)"variant.alexsmobs.crocodile.desert").getString() : "";
        }
        if (pet instanceof EntityMantisShrimp) {
            switch (tag.m_128451_("PetVariant")) {
                case 0: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.mantis_shrimp.rainbow").getString();
                    break;
                }
                case 1: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.mantis_shrimp.harlequin").getString();
                    break;
                }
                case 2: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.mantis_shrimp.peacock").getString();
                    break;
                }
                case 3: {
                    variant = Component.m_237115_((String)"variant.alexsmobs.mantis_shrimp.zebra").getString();
                }
            }
        }
        if (pet instanceof EntityGorilla) {
            variant = tag.m_128451_("PetVariant") == 1 ? Component.m_237115_((String)"variant.alexsmobs.gorilla.silverback").getString() : "";
        }
        return variant;
    }
}

