/*
 * Decompiled with CFR 0.152.
 */
package com.angelofcreation.pet_necropolis.mixin;

import com.angelofcreation.pet_necropolis.compat.ACCompat;
import com.angelofcreation.pet_necropolis.compat.AMCompat;
import com.teamabnormals.pet_cemetery.core.other.PCCriteriaTriggers;
import com.teamabnormals.pet_cemetery.core.other.PCEvents;
import com.teamabnormals.pet_cemetery.core.other.PCUtil;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PCEvents.class})
public abstract class PCEventsMixin {
    @Overwrite(remap=false)
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        TamableAnimal pet;
        LivingEntity entity = event.getEntity();
        EntityType type = entity.m_6095_();
        if (entity instanceof TamableAnimal && (pet = (TamableAnimal)entity).m_21824_()) {
            ItemStack collar = new ItemStack((ItemLike)PCItems.PET_COLLAR.get());
            CompoundTag tag = collar.m_41784_();
            tag.m_128359_("PetID", ForgeRegistries.ENTITY_TYPES.getKey((Object)type).toString());
            tag.m_128379_("IsChild", entity.m_6162_());
            if (entity.m_8077_()) {
                collar.m_41714_(entity.m_7770_());
            }
            tag.m_128359_("OwnerID", pet.m_21805_().toString());
            if (entity instanceof Wolf) {
                Wolf wolf = (Wolf)entity;
                tag.m_128405_("CollarColor", wolf.m_30428_().m_41060_());
            }
            if (entity instanceof Cat) {
                Cat cat = (Cat)entity;
                String variant = ((Registry)cat.m_9236_().m_9598_().m_6632_(Registries.f_257006_).get()).m_7981_((Object)cat.m_28554_()).toString();
                tag.m_128359_("PetVariant", variant);
                tag.m_128405_("CollarColor", cat.m_28166_().m_41060_());
            }
            if (entity instanceof Parrot) {
                Parrot parrot = (Parrot)entity;
                tag.m_128405_("PetVariant", parrot.m_28554_().m_262504_());
            }
            if (ForgeRegistries.ENTITY_TYPES.getKey((Object)type).m_135827_().equals("alexsmobs")) {
                tag.m_128405_("PetVariant", AMCompat.getVariantTag(entity));
            }
            if (ForgeRegistries.ENTITY_TYPES.getKey((Object)type).m_135827_().equals("alexscaves")) {
                tag.m_128405_("PetVariant", ACCompat.getVariantTag(entity));
                tag.m_128405_("CollarColor", ACCompat.getCollarTag(entity));
            }
            entity.m_19983_(collar);
        }
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = event.getItemStack();
        BlockPos offsetPos = pos.m_7494_();
        if (stack.m_150930_((Item)PCItems.PET_COLLAR.get()) && state.m_60713_(Blocks.f_50724_) && level.m_6042_().f_63863_() && (Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0 && level.m_8055_(offsetPos).m_60812_((BlockGetter)level, offsetPos).m_83281_()) {
            Player player = event.getEntity();
            RandomSource random = player.m_217043_();
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("PetID")) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(tag.m_128461_("PetID")));
                if (PCUtil.UNDEAD_MAP.containsKey(entityType)) {
                    entityType = (EntityType)PCUtil.UNDEAD_MAP.get(entityType);
                }
                Animal entity = (Animal)entityType.m_20615_(level);
                UUID owner = tag.m_128441_("OwnerID") ? UUID.fromString(tag.m_128461_("OwnerID")) : player.m_20148_();
                DyeColor collarColor = DyeColor.m_41053_((int)tag.m_128451_("CollarColor"));
                entity.m_6863_(tag.m_128471_("IsChild"));
                entity.m_6034_((double)((float)offsetPos.m_123341_() + 0.5f), (double)offsetPos.m_123342_(), (double)((float)offsetPos.m_123343_() + 0.5f));
                if (stack.m_41788_()) {
                    entity.m_6593_(stack.m_41786_());
                }
                Parrot respawnedEntity = null;
                if (entity instanceof TamableAnimal) {
                    TamableAnimal pet = (TamableAnimal)entity;
                    pet.m_7105_(true);
                    pet.m_21816_(owner);
                    if (pet instanceof Cat) {
                        CatVariant variant;
                        Cat cat = (Cat)pet;
                        Optional registry = level.m_9598_().m_6632_(Registries.f_257006_);
                        if (registry.isPresent() && (variant = (CatVariant)((Registry)registry.get()).m_7745_(new ResourceLocation(tag.m_128461_("PetVariant")))) != null) {
                            cat.m_28464_(variant);
                            cat.m_28131_(collarColor);
                            respawnedEntity = cat;
                        }
                    }
                    if (pet instanceof Parrot) {
                        Parrot parrot = (Parrot)pet;
                        parrot.m_28464_(Parrot.Variant.m_262398_((int)tag.m_128451_("PetVariant")));
                        respawnedEntity = parrot;
                    }
                    if (pet instanceof Wolf) {
                        Wolf wolf = (Wolf)pet;
                        wolf.m_30397_(collarColor);
                        respawnedEntity = wolf;
                    }
                    if (ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).m_135827_().equals("alexsmobs")) {
                        respawnedEntity = AMCompat.getRespawnedEntity(pet, tag);
                    }
                    if (ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).m_135827_().equals("alexscaves")) {
                        respawnedEntity = ACCompat.getRespawnedEntity(pet, tag);
                    }
                    if (respawnedEntity == null) {
                        respawnedEntity = pet;
                    }
                }
                if (respawnedEntity != null) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PCCriteriaTriggers.RESPAWN_PET.trigger(serverPlayer, entity, respawnedEntity);
                    }
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)RespawnAnchorBlock.f_55833_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) - 1)));
                    for (int i = 0; i < 10; ++i) {
                        double d0 = random.m_188583_() * 0.025;
                        double d1 = random.m_188583_() * 0.025;
                        double d2 = random.m_188583_() * 0.025;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, respawnedEntity.m_20208_(0.75), respawnedEntity.m_20187_(), respawnedEntity.m_20262_(0.75), d0, d1, d2);
                    }
                    level.m_5594_(player, pos, (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_7967_((Entity)respawnedEntity);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                }
            }
        }
    }
}

