/*
 * Decompiled with CFR 0.152.
 */
package com.angelofcreation.pet_necropolis.mixin;

import com.angelofcreation.pet_necropolis.compat.ACCompat;
import com.angelofcreation.pet_necropolis.compat.AMCompat;
import com.teamabnormals.pet_cemetery.common.entity.ZombieCat;
import com.teamabnormals.pet_cemetery.common.entity.ZombieParrot;
import com.teamabnormals.pet_cemetery.common.item.PetCollarItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PetCollarItem.class})
public abstract class PetCollarItemMixin
extends Item {
    public PetCollarItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Overwrite
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        String petID;
        EntityType entityType;
        Entity entity;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("PetID") && (entity = (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(petID = tag.m_128461_("PetID")))).m_20615_(world)) instanceof LivingEntity) {
            LivingEntity pet = (LivingEntity)entity;
            MutableComponent petType = Component.m_237115_((String)entityType.m_20675_()).m_130940_(ChatFormatting.GRAY);
            if (tag.m_128441_("PetVariant")) {
                String variant = "";
                if (pet instanceof Cat || pet instanceof ZombieCat) {
                    ResourceLocation catVariant = new ResourceLocation(tag.m_128461_("PetVariant"));
                    variant = catVariant.m_135815_();
                }
                if (pet instanceof Parrot || pet instanceof ZombieParrot) {
                    variant = Parrot.Variant.m_262398_((int)tag.m_128451_("PetVariant")).m_7912_();
                }
                if (ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).m_135827_().equals("alexsmobs")) {
                    variant = AMCompat.getVariantTranslatable(pet, tag);
                }
                if (ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).m_135827_().equals("alexscaves")) {
                    variant = ACCompat.getVariantTranslatable(pet, tag);
                }
                if (!variant.isEmpty()) {
                    variant = variant.replace("_", " ").concat(" ");
                }
                variant.stripLeading();
                petType = Component.m_237113_((String)WordUtils.capitalize((String)variant)).m_130940_(ChatFormatting.GRAY).m_7220_((Component)petType);
                if (tag.m_128471_("IsChild")) {
                    petType = Component.m_237115_((String)"tooltip.pet_cemetery.baby").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)petType);
                }
                tooltip.add((Component)petType);
            }
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }
}

