package dev.doublekekse.boids;

import dev.doublekekse.boids.config.BoidsConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import java.util.*;

import static net.minecraft.class_2170.method_9247;

public class Boids implements ModInitializer {
    public static BoidsConfig CONFIG;
    public static BoidsSimulation SETTINGS;
    public static Set<class_1299<?>> AFFECTED_ENTITIES = Collections.emptySet();

    public static void loadConfig() {
        CONFIG = BoidsConfig.load();
        CONFIG.save();

        SETTINGS = new BoidsSimulation(
            CONFIG.separationInfluence,
            CONFIG.separationRange,
            BoidsSimulation.degrees(CONFIG.separationAngle),

            CONFIG.alignmentInfluence,
            BoidsSimulation.degrees(CONFIG.alignmentAngle),

            CONFIG.cohesionInfluence,
            BoidsSimulation.degrees(CONFIG.cohesionAngle),

            CONFIG.randomness
        );

        AFFECTED_ENTITIES = affectedEntities(CONFIG);
    }

    private static Set<class_1299<?>> affectedEntities(BoidsConfig config) {
        var entities = new ArrayList<>(config.defaultEntities.types);

        entities.addAll(getEntities(config.includedEntities));
        entities.removeAll(getEntities(config.excludeEntities));

        return Set.copyOf(entities);
    }

    private static Collection<? extends class_1299<?>> getEntities(List<String> ids) {
        return ids.stream()
            .map(class_2960::method_12829)
            .filter(Objects::nonNull)
            .map(class_7923.field_41177::method_10223)
            .filter(Optional::isPresent)
            .map(Optional::orElseThrow)
            .map(class_6880.class_6883::comp_349)
            .toList();
    }

    public static boolean isAffected(class_1297 entity) {
        return AFFECTED_ENTITIES.contains(entity.method_5864());
    }

    @Override
    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register((minecraftServer) -> loadConfig());

        CommandRegistrationCallback.EVENT.register(
            (dispatcher, registryAccess, environment) -> {
                dispatcher.register(
                    method_9247("boids").requires((source) -> source.method_9259(2)).then(method_9247("config").then(method_9247("reload").executes(ctx -> {
                        loadConfig();

                        ctx.getSource().method_9226(() -> class_2561.method_43471("commands.boids.config.reload"), true);

                        return 1;
                    })))
                );
            }
        );
    }
}
