package dev.doublekekse.boids;

import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_243;

public record BoidsSimulation(
    float separationInfluence,
    float separationRange,
    float separationAngle,

    float alignmentInfluence,
    float alignmentAngle,

    float cohesionInfluence,
    float cohesionAngle,

    float randomness
) {
    public static float degrees(float angle) {
        return (float) Math.cos(Math.toRadians(angle));
    }

    public class_243 apply(class_1308 mob, List<? extends class_1308> nearbyMobs) {
        var separation = class_243.field_1353;
        var alignment = class_243.field_1353;
        var cohesion = class_243.field_1353;

        var random = new class_243(mob.method_59922().method_43059() * randomness, mob.method_59922().method_43059() * randomness, mob.method_59922().method_43059() * randomness);

        int alignmentCount = 0;
        int cohesionCount = 0;

        for (class_1308 other : nearbyMobs) {
            if (mob == other) continue;

            var delta = other.method_73189().method_1020(mob.method_73189());
            var dist = Math.max(0.00001f, delta.method_1033());
            var angle = mob.method_5720().method_1026(delta.method_1029());

            if (dist < separationRange &&
                angle >= separationAngle) {
                separation = separation.method_1019(delta.method_1021(-((1.0 / dist) - (1.0 / separationRange))));
            }

            if (angle >= alignmentAngle) {
                alignment = alignment.method_1019(other.method_18798().method_1029());
                alignmentCount++;
            }

            if (angle >= cohesionAngle) {
                cohesion = cohesion.method_1019(other.method_73189());
                cohesionCount++;
            }
        }


        if (alignmentCount == 0) {
            alignment = class_243.field_1353;
        } else {
            alignment = alignment.method_1021(1f / alignmentCount);
        }

        if (cohesionCount == 0) {
            cohesion = class_243.field_1353;
        } else {
            cohesion = cohesion.method_1021(1f / cohesionCount);
            cohesion = cohesion.method_1020(mob.method_73189());
        }

        return alignment.method_1021(alignmentInfluence)
            .method_1019(separation.method_1021(separationInfluence))
            .method_1019(cohesion.method_1021(cohesionInfluence))
            .method_1019(random);
    }
}
