/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.boids;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.doublekekse.boids.BoidsSimulation;
import dev.doublekekse.boids.config.BoidsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class Boids
implements ModInitializer {
    public static BoidsConfig CONFIG;
    public static BoidsSimulation SETTINGS;
    public static Set<class_1299<?>> AFFECTED_ENTITIES;

    public static void loadConfig() {
        CONFIG = BoidsConfig.load();
        CONFIG.save();
        SETTINGS = new BoidsSimulation(Boids.CONFIG.separationInfluence, Boids.CONFIG.separationRange, BoidsSimulation.degrees(Boids.CONFIG.separationAngle), Boids.CONFIG.alignmentInfluence, BoidsSimulation.degrees(Boids.CONFIG.alignmentAngle), Boids.CONFIG.cohesionInfluence, BoidsSimulation.degrees(Boids.CONFIG.cohesionAngle), Boids.CONFIG.randomness);
        AFFECTED_ENTITIES = Boids.affectedEntities(CONFIG);
    }

    private static Set<class_1299<?>> affectedEntities(BoidsConfig config) {
        ArrayList entities = new ArrayList(config.defaultEntities.types);
        entities.addAll(Boids.getEntities(config.includedEntities));
        entities.removeAll(Boids.getEntities(config.excludeEntities));
        return Set.copyOf(entities);
    }

    private static Collection<? extends class_1299<?>> getEntities(List<String> ids) {
        return ids.stream().map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41177).method_10223(arg_0)).filter(Optional::isPresent).map(Optional::orElseThrow).map(class_6880.class_6883::comp_349).toList();
    }

    public static boolean isAffected(class_1297 entity) {
        return AFFECTED_ENTITIES.contains(entity.method_5864());
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> Boids.loadConfig());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"boids").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"reload").executes(ctx -> {
            Boids.loadConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.boids.config.reload"), true);
            return 1;
        })))));
    }

    static {
        AFFECTED_ENTITIES = Collections.emptySet();
    }
}

