/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.boids.config;

import blue.endless.jankson.Comment;
import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.api.SyntaxError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;

public class BoidsConfig {
    private static final Jankson jankson = new Jankson.Builder().build();
    private static final Path filePath = FabricLoader.getInstance().getConfigDir().resolve("boids.json5");
    @Comment(value="Separation controls. All angles are in degrees")
    public float separationInfluence = 0.6f;
    public float separationRange = 2.5f;
    public float separationAngle = 70.0f;
    @Comment(value="Alignment controls")
    public float alignmentInfluence = 0.4f;
    public float alignmentAngle = 100.0f;
    @Comment(value="Cohesion controls")
    public float cohesionInfluence = 0.4f;
    public float cohesionAngle = 70.0f;
    @Comment(value="Speed limits")
    public float minSpeed = 0.2f;
    public float maxSpeed = 0.3f;
    @Comment(value="Random influence")
    public float randomness = 0.005f;
    @Comment(value="Which entities to be included by default. Can be one of 'DEFAULT' or 'NONE'")
    public DefaultEntities defaultEntities = DefaultEntities.DEFAULT;
    @Comment(value="Lists of additional entities to include or exclude by resource ID, e.g., 'minecraft:salmon'")
    public List<String> includedEntities = new ArrayList<String>();
    public List<String> excludeEntities = new ArrayList<String>();

    private static BoidsConfig loadFromJSON(String json) throws SyntaxError {
        return (BoidsConfig)jankson.fromJson(json, BoidsConfig.class);
    }

    public static BoidsConfig load() {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return new BoidsConfig();
        }
        try {
            String json = Files.readString(filePath, StandardCharsets.UTF_8);
            return BoidsConfig.loadFromJSON(json);
        }
        catch (SyntaxError | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        try {
            filePath.getParent().toFile().mkdirs();
            Files.writeString(filePath, (CharSequence)this.toJSON(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJSON() {
        return jankson.toJson((Object)this).toJson(JsonGrammar.JANKSON);
    }

    public static enum DefaultEntities {
        DEFAULT(List.of(class_1299.field_6073, class_1299.field_6070, class_1299.field_6111)),
        NONE(Collections.emptyList());

        public final Collection<class_1299<?>> types;

        private DefaultEntities(Collection<class_1299<?>> types) {
            this.types = types;
        }
    }
}

