/*
 * Decompiled with CFR 0.152.
 */
package de.daniel.bactromod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import de.daniel.bactromod.BactroMod;
import de.daniel.bactromod.config.ConfigData;
import de.daniel.bactromod.config.ConfigDefaults;
import de.daniel.bactromod.utils.SystemInfo;
import de.daniel.bactromod.windowborder.DwmApi;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

public class Config {
    private static final Path configPath;
    private static volatile ConfigData configData;
    private static final Gson gson;

    public static void save(ConfigData config) {
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            gson.toJson((Object)config, (Appendable)writer);
            configData = config;
        }
        catch (IOException e) {
            BactroMod.LOGGER.error("Could not save config file or directory.", (Throwable)e);
        }
        if (SystemInfo.isWindows11) {
            DwmApi.updateDwm(class_310.method_1551().method_22683().method_4490());
        }
    }

    public static ConfigData load() {
        return configData != null ? configData : ConfigDefaults.createDefaults();
    }

    static {
        block14: {
            configPath = FabricLoader.getInstance().getConfigDir().resolve("bactromod.json");
            gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                if (!Files.exists(configPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                        Config.save(ConfigDefaults.createDefaults());
                    }
                    catch (IOException e) {
                        configData = ConfigDefaults.createDefaults();
                        BactroMod.LOGGER.error("Could not create default config file or directory. Make sure {} is a directory and writable.", (Object)configPath.getParent(), (Object)e);
                    }
                    break block14;
                }
                try (BufferedReader reader = Files.newBufferedReader(configPath);){
                    configData = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
                    if (configData == null) {
                        configData = ConfigDefaults.createDefaults();
                    }
                }
                catch (JsonIOException | JsonSyntaxException | IOException e) {
                    Path backup = configPath.resolveSibling("bactromod_old_" + Instant.now().getEpochSecond() + ".json");
                    Files.move(configPath, backup, new CopyOption[0]);
                    BactroMod.LOGGER.warn("Existing config file in {} is invalid and has been replaced with default config. Invalid config file has been backed up at {}.", (Object)configPath, (Object)backup);
                    Config.save(ConfigDefaults.createDefaults());
                }
            }
            catch (IOException e) {
                configData = ConfigDefaults.createDefaults();
                BactroMod.LOGGER.error("Could not load default config file or directory.", (Throwable)e);
            }
        }
    }
}

