/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.configurableeverything.datapack.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.frozenblock.configurableeverything.config.MainConfig;
import net.frozenblock.configurableeverything.datapack.util.CERepositorySource;
import net.frozenblock.configurableeverything.util.ConfigurableEverythingSharedConstantsKt;
import net.frozenblock.lib.config.api.instance.ConfigSerialization;
import net.frozenblock.lib.config.api.instance.json.JanksonOps;
import net.frozenblock.lib.shadow.blue.endless.jankson.Jankson;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonElement;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonObject;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7654;
import net.minecraft.class_8580;
import net.minecraft.class_9248;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u007f\u0010\u001d\u001a\u00020\u001c\"\b\b\u0000\u0010\n*\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u001a\u0010\u0019\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\b\u0012\u00060\u0017j\u0002`\u00180\u00162\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lnet/frozenblock/configurableeverything/datapack/util/DatapackUtil;", "", "<init>", "()V", "Lnet/minecraft/class_8580;", "validator", "", "Lnet/frozenblock/configurableeverything/datapack/util/CERepositorySource;", "addedRepositories", "(Lnet/minecraft/class_8580;)Ljava/util/List;", "E", "Lnet/minecraft/class_6903$class_7863;", "lookup", "Lnet/minecraft/class_3300;", "manager", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_2378;", "registryKey", "Lnet/minecraft/class_2385;", "registry", "Lcom/mojang/serialization/Decoder;", "decoder", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exceptions", "", "directory", "", "loadJson5Contents", "(Lnet/minecraft/class_6903$class_7863;Lnet/minecraft/class_3300;Lnet/minecraft/class_5321;Lnet/minecraft/class_2385;Lcom/mojang/serialization/Decoder;Ljava/util/Map;Ljava/lang/String;)V", "ConfigurableEverything"})
@SourceDebugExtension(value={"SMAP\nDatapackUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatapackUtil.kt\nnet/frozenblock/configurableeverything/datapack/util/DatapackUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ConfigurableEverythingUtils.kt\nnet/frozenblock/configurableeverything/util/ConfigurableEverythingUtilsKt\n*L\n1#1,86:1\n1869#2:87\n1870#2:91\n13#3,3:88\n*S KotlinDebug\n*F\n+ 1 DatapackUtil.kt\nnet/frozenblock/configurableeverything/datapack/util/DatapackUtil\n*L\n29#1:87\n29#1:91\n30#1:88,3\n*E\n"})
public final class DatapackUtil {
    @NotNull
    public static final DatapackUtil INSTANCE = new DatapackUtil();

    private DatapackUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<CERepositorySource> addedRepositories(@Nullable class_8580 validator) {
        MainConfig.DatapackConfig config = MainConfig.Companion.get$default((MainConfig.Companion)MainConfig.Companion, (boolean)false, (int)1, null).datapack;
        if (validator == null) {
            return CollectionsKt.emptyList();
        }
        if (config.applyDatapackFolders) {
            List list = new ArrayList();
            Iterable $this$forEach$iv = config.datapackFolders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string$iv = "Adding datapack repository at " + it;
                boolean shouldLog$iv = true;
                boolean $i$f$log = false;
                Logger logger = ConfigurableEverythingSharedConstantsKt.LOGGER;
                if (logger != null) {
                    logger.info(string$iv);
                }
                Path path = Paths.get(it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                list.add(new CERepositorySource(path, null, null, validator, 6, null));
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @JvmStatic
    public static final <E> void loadJson5Contents(@NotNull class_6903.class_7863 lookup, @NotNull class_3300 manager, @NotNull class_5321<? extends class_2378<E>> registryKey, @NotNull class_2385<E> registry, @NotNull Decoder<E> decoder, @NotNull Map<class_5321<?>, Exception> exceptions, @NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(registryKey, (String)"registryKey");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        class_7654 fileToIdConverter = new class_7654(directory, ".json5");
        class_6903 registryOps = class_6903.method_40414((DynamicOps)((DynamicOps)JanksonOps.INSTANCE), (class_6903.class_7863)lookup);
        Map map = fileToIdConverter.method_45113(manager);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"listMatchingResources(...)");
        for (Map.Entry entry : map.entrySet()) {
            class_2960 resourceLocation = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            class_5321 resourceKey = class_5321.method_29179(registryKey, (class_2960)fileToIdConverter.method_45115(resourceLocation));
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    Object object;
                    Jankson jankson = ConfigSerialization.createJankson((String)"");
                    Intrinsics.checkNotNull((Object)reader);
                    JsonObject jsonObject = jankson.load(TextStreamsKt.readText((Reader)reader));
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"load(...)");
                    JsonElement jsonElement = (JsonElement)jsonObject;
                    DataResult dataResult = decoder.parse((DynamicOps)registryOps, (Object)jsonElement);
                    Intrinsics.checkNotNullExpressionValue((Object)dataResult.getOrThrow(), (String)"getOrThrow(...)");
                    registry.method_10272(resourceKey, object, new class_9248(Optional.empty(), dataResult.lifecycle()));
                }
                catch (Exception e) {
                    try {
                        reader.close();
                    }
                    catch (Exception e1) {
                        ExceptionsKt.addSuppressed((Throwable)e, (Throwable)e1);
                    }
                    throw e;
                }
                reader.close();
            }
            catch (Exception e) {
                Map<class_5321<?>, Exception> map2 = exceptions;
                Locale locale = Locale.ROOT;
                String string = "Failed to parse %s from pack %s";
                Object[] objectArray = new Object[]{resourceLocation, resource.method_14480()};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                IllegalStateException illegalStateException = new IllegalStateException(string2, e);
                map2.put(resourceKey, illegalStateException);
            }
        }
    }
}

