/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.configurableeverything.shadow.net.fabricmc.loom.kotlin.remapping;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmLambda;
import kotlin.metadata.KmPackage;
import kotlin.metadata.jvm.JvmMetadataUtil;
import kotlin.metadata.jvm.KotlinClassMetadata;
import net.frozenblock.configurableeverything.shadow.net.fabricmc.loom.kotlin.remapping.KotlinClassRemapper;
import net.frozenblock.configurableeverything.shadow.net.fabricmc.loom.kotlin.remapping.KotlinMetadataRemappingClassVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000e\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\"R\u001c\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lnet/frozenblock/configurableeverything/shadow/net/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor;", "Lorg/objectweb/asm/tree/AnnotationNode;", "Lorg/objectweb/asm/commons/Remapper;", "remapper", "Lorg/objectweb/asm/AnnotationVisitor;", "next", "", "className", "<init>", "(Lorg/objectweb/asm/commons/Remapper;Lorg/objectweb/asm/AnnotationVisitor;Ljava/lang/String;)V", "name", "", "value", "", "visit", "(Ljava/lang/String;Ljava/lang/Object;)V", "visitEnd", "()V", "Lkotlin/Metadata;", "readHeader", "()Lkotlin/Metadata;", "header", "writeClassHeader", "(Lkotlin/Metadata;)V", "remapped", "original", "validateKotlinClassHeader", "(Lkotlin/Metadata;Lkotlin/Metadata;)V", "Lorg/objectweb/asm/commons/Remapper;", "Lorg/objectweb/asm/AnnotationVisitor;", "getNext", "()Lorg/objectweb/asm/AnnotationVisitor;", "Ljava/lang/String;", "getClassName", "()Ljava/lang/String;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "fabric-loom"})
@SourceDebugExtension(value={"SMAP\nKotlinClassMetadataRemappingAnnotationVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadataRemappingAnnotationVisitor.kt\nnet/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,183:1\n1863#2:184\n1864#2:189\n37#3,2:185\n37#3,2:187\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadataRemappingAnnotationVisitor.kt\nnet/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor\n*L\n133#1:184\n133#1:189\n137#1:185,2\n138#1:187,2\n*E\n"})
public final class KotlinClassMetadataRemappingAnnotationVisitor
extends AnnotationNode {
    @NotNull
    private final Remapper remapper;
    @NotNull
    private final AnnotationVisitor next;
    @Nullable
    private final String className;
    private final Logger logger;

    public KotlinClassMetadataRemappingAnnotationVisitor(@NotNull Remapper remapper, @NotNull AnnotationVisitor next, @Nullable String className) {
        Intrinsics.checkNotNullParameter((Object)remapper, (String)"remapper");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        super(589824, KotlinMetadataRemappingClassVisitor.Companion.getANNOTATION_DESCRIPTOR());
        this.remapper = remapper;
        this.next = next;
        this.className = className;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final AnnotationVisitor getNext() {
        return this.next;
    }

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    public void visit(@Nullable String name, @Nullable Object value) {
        super.visit(name, value);
    }

    public void visitEnd() {
        KotlinClassMetadata metadata;
        KotlinVersion currentMinorVersion;
        super.visitEnd();
        Metadata metadata2 = this.readHeader();
        if (metadata2 == null) {
            return;
        }
        Metadata header = metadata2;
        KotlinVersion headerVersion = new KotlinVersion(header.mv()[0], header.mv()[1], 0);
        if (!Intrinsics.areEqual((Object)headerVersion, (Object)(currentMinorVersion = new KotlinVersion(KotlinVersion.CURRENT.getMajor(), KotlinVersion.CURRENT.getMinor(), 0)))) {
            this.logger.info("Kotlin metadata for class (" + this.className + ") as it was built using a different major Kotlin version (" + header.mv()[0] + "." + header.mv()[1] + ".x) while the remapper is using (" + KotlinVersion.CURRENT + ").");
        }
        if ((metadata = KotlinClassMetadata.Companion.readLenient(header)).getVersion().getMajor() < 1 || metadata.getVersion().getMajor() == 1 && metadata.getVersion().getMinor() < 4) {
            this.logger.warn(this.className + " is not supported by kotlin metadata remapping (version: " + metadata.getVersion() + ")");
            this.accept(this.next);
            return;
        }
        KotlinClassMetadata kotlinClassMetadata = metadata;
        if (kotlinClassMetadata instanceof KotlinClassMetadata.Class) {
            KmClass klass = ((KotlinClassMetadata.Class)metadata).getKmClass();
            klass = new KotlinClassRemapper(this.remapper).remap(klass);
            Metadata remapped = new KotlinClassMetadata.Class(klass, ((KotlinClassMetadata.Class)metadata).getVersion(), ((KotlinClassMetadata.Class)metadata).getFlags()).write();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.SyntheticClass) {
            KmLambda klambda = ((KotlinClassMetadata.SyntheticClass)metadata).getKmLambda();
            if (klambda != null) {
                klambda = new KotlinClassRemapper(this.remapper).remap(klambda);
                Metadata remapped = new KotlinClassMetadata.SyntheticClass(klambda, ((KotlinClassMetadata.SyntheticClass)metadata).getVersion(), ((KotlinClassMetadata.SyntheticClass)metadata).getFlags()).write();
                this.writeClassHeader(remapped);
                this.validateKotlinClassHeader(remapped, header);
            } else {
                this.accept(this.next);
            }
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.FileFacade) {
            KmPackage kpackage = ((KotlinClassMetadata.FileFacade)metadata).getKmPackage();
            kpackage = new KotlinClassRemapper(this.remapper).remap(kpackage);
            Metadata remapped = new KotlinClassMetadata.FileFacade(kpackage, ((KotlinClassMetadata.FileFacade)metadata).getVersion(), ((KotlinClassMetadata.FileFacade)metadata).getFlags()).write();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            KmPackage kpackage = ((KotlinClassMetadata.MultiFileClassPart)metadata).getKmPackage();
            kpackage = new KotlinClassRemapper(this.remapper).remap(kpackage);
            Metadata remapped = new KotlinClassMetadata.MultiFileClassPart(kpackage, ((KotlinClassMetadata.MultiFileClassPart)metadata).getFacadeClassName(), ((KotlinClassMetadata.MultiFileClassPart)metadata).getVersion(), ((KotlinClassMetadata.MultiFileClassPart)metadata).getFlags()).write();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassFacade || kotlinClassMetadata instanceof KotlinClassMetadata.Unknown) {
            this.accept(this.next);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final Metadata readHeader() {
        Integer kind = null;
        int[] metadataVersion = null;
        String[] data1 = null;
        String[] data2 = null;
        String extraString = null;
        String packageName = null;
        Integer extraInt = null;
        if (this.values == null) {
            return null;
        }
        List list = this.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)list, (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            Collection $this$toTypedArray$iv;
            List list2 = (List)element$iv;
            boolean bl = false;
            Object name = list2.get(0);
            Object value = list2.get(1);
            Object e = name;
            if (Intrinsics.areEqual(e, (Object)"k")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Int");
                kind = (Integer)value;
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"mv")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
                metadataVersion = CollectionsKt.toIntArray((Collection)((List)value));
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"d1")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                $this$toTypedArray$iv = (List)value;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                data1 = thisCollection$iv.toArray(new String[0]);
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"d2")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                $this$toTypedArray$iv = (List)value;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                data2 = thisCollection$iv.toArray(new String[0]);
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"xs")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                extraString = (String)value;
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"pn")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                packageName = (String)value;
                continue;
            }
            if (!Intrinsics.areEqual(e, (Object)"xi")) continue;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Int");
            extraInt = (Integer)value;
        }
        return JvmMetadataUtil.Metadata(kind, metadataVersion, (String[])data1, (String[])data2, extraString, packageName, extraInt);
    }

    private final void writeClassHeader(Metadata header) {
        AnnotationNode newNode = new AnnotationNode(this.api, this.desc);
        List list = this.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
        newNode.values = CollectionsKt.toMutableList((Collection)list);
        AnnotationNode $this$writeClassHeader_u24lambda_u241 = newNode;
        boolean bl = false;
        int n = ((Collection)$this$writeClassHeader_u24lambda_u241.values).size() + -1;
        int i = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                Object e;
                if (Intrinsics.areEqual(e = $this$writeClassHeader_u24lambda_u241.values.get(i), (Object)"k")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.k());
                } else if (Intrinsics.areEqual(e, (Object)"mv")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, ArraysKt.toList((int[])header.mv()));
                } else if (Intrinsics.areEqual(e, (Object)"d1")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, ArraysKt.toList((Object[])header.d1()));
                } else if (Intrinsics.areEqual(e, (Object)"d2")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, ArraysKt.toList((Object[])header.d2()));
                } else if (Intrinsics.areEqual(e, (Object)"xs")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.xs());
                } else if (Intrinsics.areEqual(e, (Object)"pn")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.pn());
                } else if (Intrinsics.areEqual(e, (Object)"xi")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.xi());
                }
                if (i == n2) break;
                i += 2;
            }
        }
        newNode.accept(this.next);
    }

    private final void validateKotlinClassHeader(Metadata remapped, Metadata original) {
        if (remapped.d2().length != original.d2().length) {
            this.logger.info("Kotlin class metadata size mismatch: data2 size does not match original in class " + this.className + ". New: " + remapped.d2().length + " Old: " + original.d2().length);
        }
    }
}

