/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.configurableeverything.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.class_4239;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0005\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a-\u0010\u000b\u001a\u00020\u0001*\u00020\u00002\u0014\b\u0004\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0011\u0010\u000e\u001a\u00020\r*\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0011\u0010\u000e\u001a\u00020\r*\u00020\u0010\u00a2\u0006\u0004\b\u000e\u0010\u0011\u001a'\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0016\u001a\u0019\u0010\u0018\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0006\u001a'\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\"\u001e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u001e*\u00020\u001d8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u001e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\"*\u00020\u001d8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0016\u0010&\u001a\u00020\t*\u00020\u00008\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"\u0016\u0010+\u001a\u00020(*\u00020\u00008\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\"\u0016\u0010.\u001a\u00020\u0012*\u00020\u00008\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0014\u0010/\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b/\u00100\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Ljava/io/File;", "", "recreateDir", "(Ljava/io/File;)V", "jar", "addToJar", "(Ljava/io/File;Ljava/io/File;)V", "Lkotlin/Function1;", "Ljava/util/jar/JarEntry;", "", "transform", "removeFromJar", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "", "readTextSkipUtf8Bom", "(Ljava/io/File;)Ljava/lang/String;", "Ljava/net/URL;", "(Ljava/net/URL;)Ljava/lang/String;", "Ljava/util/jar/JarOutputStream;", "jarOut", "sourceFile", "parentDirPath", "(Ljava/util/jar/JarOutputStream;Ljava/io/File;Ljava/lang/String;)V", "zipFile", "zipAllTo", "Ljava/util/zip/ZipOutputStream;", "zipOut", "zipFiles", "(Ljava/util/zip/ZipOutputStream;Ljava/io/File;Ljava/lang/String;)V", "Ljava/nio/file/Path;", "", "getAsDir", "(Ljava/nio/file/Path;)[Ljava/io/File;", "asDir", "", "getAsFileList", "(Ljava/nio/file/Path;)Ljava/util/List;", "asFileList", "isJar", "(Ljava/io/File;)Z", "Ljava/util/jar/JarInputStream;", "getAsJarInput", "(Ljava/io/File;)Ljava/util/jar/JarInputStream;", "asJarInput", "getAsJarOutput", "(Ljava/io/File;)Ljava/util/jar/JarOutputStream;", "asJarOutput", "UTF8_BOM", "Ljava/lang/String;", "ConfigurableEverything"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\nnet/frozenblock/configurableeverything/util/FileUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,126:1\n19#1:127\n13805#2,2:128\n13805#2,2:130\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\nnet/frozenblock/configurableeverything/util/FileUtilsKt\n*L\n22#1:127\n64#1:128,2\n99#1:130,2\n*E\n"})
public final class FileUtilsKt {
    @NotNull
    public static final String UTF8_BOM = "\ufeff";

    public static final void recreateDir(@NotNull File $this$recreateDir) {
        Intrinsics.checkNotNullParameter((Object)$this$recreateDir, (String)"<this>");
        FilesKt.deleteRecursively((File)$this$recreateDir);
        class_4239.method_47525((Path)$this$recreateDir.toPath());
    }

    @Nullable
    public static final File[] getAsDir(@NotNull Path $this$asDir) {
        Intrinsics.checkNotNullParameter((Object)$this$asDir, (String)"<this>");
        boolean $i$f$getAsDir = false;
        return $this$asDir.toFile().listFiles();
    }

    @Nullable
    public static final List<File> getAsFileList(@NotNull Path $this$asFileList) {
        Intrinsics.checkNotNullParameter((Object)$this$asFileList, (String)"<this>");
        boolean $i$f$getAsFileList = false;
        Path $this$asDir$iv = $this$asFileList;
        boolean $i$f$getAsDir = false;
        Object[] objectArray = $this$asDir$iv.toFile().listFiles();
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    public static final boolean isJar(@NotNull File $this$isJar) {
        Intrinsics.checkNotNullParameter((Object)$this$isJar, (String)"<this>");
        boolean $i$f$isJar = false;
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$isJar), (Object)"jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addToJar(@NotNull File $this$addToJar, @NotNull File jar) {
        Intrinsics.checkNotNullParameter((Object)$this$addToJar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Closeable closeable = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jar)));
        Throwable throwable = null;
        try {
            JarOutputStream it = (JarOutputStream)closeable;
            boolean bl = false;
            FileUtilsKt.addToJar(it, $this$addToJar, "");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeFromJar(@NotNull File $this$removeFromJar, @NotNull Function1<? super JarEntry, Boolean> transform) {
        Intrinsics.checkNotNullParameter((Object)$this$removeFromJar, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$removeFromJar = false;
        File tempFile = File.createTempFile("temp", ".jar");
        Closeable closeable = new FileOutputStream(tempFile);
        int n = 8192;
        closeable = new JarOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            JarOutputStream jarOut = (JarOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileInputStream($this$removeFromJar);
            int n2 = 8192;
            closeable2 = new JarInputStream(closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2));
            Throwable throwable2 = null;
            try {
                JarInputStream jarIn = (JarInputStream)closeable2;
                boolean bl2 = false;
                while (jarIn.getNextJarEntry() != null) {
                    JarEntry entry;
                    if (((Boolean)transform.invoke((Object)entry)).booleanValue()) continue;
                    jarOut.putNextEntry(entry);
                    ByteStreamsKt.copyTo$default((InputStream)jarIn, (OutputStream)jarOut, (int)0, (int)2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                InlineMarker.finallyEnd((int)1);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        Intrinsics.checkNotNull((Object)tempFile);
        FilesKt.copyRecursively$default((File)tempFile, (File)$this$removeFromJar, (boolean)true, null, (int)4, null);
        FilesKt.deleteRecursively((File)tempFile);
    }

    @NotNull
    public static final JarInputStream getAsJarInput(@NotNull File $this$asJarInput) {
        Intrinsics.checkNotNullParameter((Object)$this$asJarInput, (String)"<this>");
        boolean $i$f$getAsJarInput = false;
        return new JarInputStream(new BufferedInputStream(new FileInputStream($this$asJarInput)));
    }

    @NotNull
    public static final JarOutputStream getAsJarOutput(@NotNull File $this$asJarOutput) {
        Intrinsics.checkNotNullParameter((Object)$this$asJarOutput, (String)"<this>");
        boolean $i$f$getAsJarOutput = false;
        return new JarOutputStream(new BufferedOutputStream(new FileOutputStream($this$asJarOutput)));
    }

    @NotNull
    public static final String readTextSkipUtf8Bom(@NotNull File $this$readTextSkipUtf8Bom) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextSkipUtf8Bom, (String)"<this>");
        return StringsKt.removePrefix((String)FilesKt.readText$default((File)$this$readTextSkipUtf8Bom, null, (int)1, null), (CharSequence)UTF8_BOM);
    }

    @NotNull
    public static final String readTextSkipUtf8Bom(@NotNull URL $this$readTextSkipUtf8Bom) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextSkipUtf8Bom, (String)"<this>");
        URL uRL = $this$readTextSkipUtf8Bom;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        return StringsKt.removePrefix((String)new String(byArray, charset), (CharSequence)UTF8_BOM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addToJar(JarOutputStream jarOut, File sourceFile, String parentDirPath) {
        File[] fileArray = sourceFile.listFiles();
        if (fileArray == null) {
            File[] fileArray2 = new File[]{sourceFile};
            fileArray = fileArray2;
        }
        File[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File f = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (f.isDirectory()) {
                String path = Intrinsics.areEqual((Object)parentDirPath, (Object)"") ? f.getName() : parentDirPath + File.separator + f.getName();
                JarEntry entry = new JarEntry(path + File.separator);
                entry.setTime(f.lastModified());
                entry.isDirectory();
                entry.setSize(f.length());
                jarOut.putNextEntry(entry);
                Intrinsics.checkNotNull((Object)f);
                Intrinsics.checkNotNull((Object)path);
                FileUtilsKt.addToJar(jarOut, f, path);
                continue;
            }
            Closeable closeable = new BufferedInputStream(new FileInputStream(f));
            Throwable throwable = null;
            try {
                BufferedInputStream origin = (BufferedInputStream)closeable;
                boolean bl2 = false;
                String path = parentDirPath + File.separator + f.getName();
                JarEntry entry = new JarEntry(path);
                entry.setTime(f.lastModified());
                entry.isDirectory();
                entry.setSize(f.length());
                jarOut.putNextEntry(entry);
                ByteStreamsKt.copyTo$default((InputStream)origin, (OutputStream)jarOut, (int)0, (int)2, null);
                Unit unit = Unit.INSTANCE;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void zipAllTo(@NotNull File $this$zipAllTo, @NotNull File zipFile) {
        Intrinsics.checkNotNullParameter((Object)$this$zipAllTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            boolean bl = false;
            FileUtilsKt.zipFiles(it, $this$zipAllTo, "");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipFiles(ZipOutputStream zipOut, File sourceFile, String parentDirPath) {
        block7: {
            File[] fileArray = sourceFile.listFiles();
            if (fileArray == null) break block7;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File f = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (f.isDirectory()) {
                    String path = Intrinsics.areEqual((Object)parentDirPath, (Object)"") ? f.getName() : parentDirPath + File.separator + f.getName();
                    ZipEntry entry = new ZipEntry(path + File.separator);
                    entry.setTime(f.lastModified());
                    entry.isDirectory();
                    entry.setSize(f.length());
                    zipOut.putNextEntry(entry);
                    Intrinsics.checkNotNull((Object)f);
                    Intrinsics.checkNotNull((Object)path);
                    FileUtilsKt.zipFiles(zipOut, f, path);
                    continue;
                }
                Closeable closeable = new BufferedInputStream(new FileInputStream(f));
                Throwable throwable = null;
                try {
                    BufferedInputStream origin = (BufferedInputStream)closeable;
                    boolean bl2 = false;
                    String path = parentDirPath + File.separator + f.getName();
                    ZipEntry entry = new ZipEntry(path);
                    entry.setTime(f.lastModified());
                    entry.isDirectory();
                    entry.setSize(f.length());
                    zipOut.putNextEntry(entry);
                    ByteStreamsKt.copyTo$default((InputStream)origin, (OutputStream)zipOut, (int)0, (int)2, null);
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }
}

