/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.RecipeRandomizer;
import com.ghzdude.randomizer.loot.LootRandomizer;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CompletabilityVerifier {
    private static final Object2ObjectMap<ResourceLocation, Set<ResourceLocation>> RESULT_MAP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<ResourceLocation, Int2ObjectMap<Set<ResourceLocation>>> INGREDIENT_MAP = new Object2ObjectOpenHashMap();
    private static final Object2BooleanMap<ResourceLocation> COMPLETABILITY_CACHE = new Object2BooleanOpenHashMap();
    private static final Object2ObjectMap<ResourceLocation, Set<ResourceLocation>> TAG_MAP = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, ResourceLocation> MODIFY_RECIPES = new Object2ObjectOpenHashMap();
    private static VerifierSaveData data;
    public static ResourceLocation ENDER_EYE;
    public static ResourceLocation OBSIDIAN;
    private static final Deque<ResourceLocation> RECIPE_PATH;
    private static final Deque<Component> PRINT_PATH;
    private static final Deque<ResourceLocation> COMPLETION_QUEUE;
    private static final Logger LOGGER;
    private static boolean requiresNether;
    private static boolean isCompletable;
    private static boolean walkingBack;
    private static Registry<Item> ITEM_REGISTRY;
    private static final List<ResourceLocation> OVERWORLD_LOOT;
    private static final List<ResourceLocation> OVERWORLD_BLOCKS;
    private static final List<ResourceLocation> ALL_OVERWORLD;
    private static final List<ResourceLocation> NETHER_BLOCKS;
    private static final List<ResourceLocation> ALL_NETHER;
    private static final List<ResourceLocation> NETHER_LOOT;

    static void init(MinecraftServer server) {
        ITEM_REGISTRY = server.registryAccess().lookupOrThrow(Registries.ITEM);
        RESULT_MAP.defaultReturnValue(Collections.emptySet());
        INGREDIENT_MAP.defaultReturnValue((Object)Int2ObjectMaps.emptyMap());
        data = VerifierSaveData.get(server.overworld().getDataStorage());
        ENDER_EYE = ITEM_REGISTRY.getKey((Object)Items.ENDER_EYE);
        OBSIDIAN = ITEM_REGISTRY.getKey((Object)Items.OBSIDIAN);
        if (CompletabilityVerifier.data.fromDisk) {
            LOGGER.info("Loading saved completability data!");
            for (ModificationData modificationData : CompletabilityVerifier.data.modificationData) {
                LootRandomizer.registerSpecialDrop(modificationData.table, modificationData.original, modificationData.replacement);
            }
            LOGGER.info("Loaded {} entries!", (Object)CompletabilityVerifier.data.modificationData.size());
            return;
        }
        for (ResourceLocation recipe : RecipeRandomizer.getKnownRecipes()) {
            ResourceLocation result = RecipeRandomizer.getResultFor(recipe);
            CompletabilityVerifier.addRecipe(RecipeRandomizer.getIngredients(recipe), result, recipe);
        }
        for (ResourceLocation table : LootRandomizer.getKnownTables()) {
            CompletabilityVerifier.addLootTable(table, LootRandomizer.getDrops(table));
        }
        ALL_OVERWORLD.clear();
        ALL_OVERWORLD.addAll(OVERWORLD_BLOCKS);
        ALL_OVERWORLD.addAll(OVERWORLD_LOOT);
        ALL_NETHER.clear();
        ALL_NETHER.addAll(NETHER_BLOCKS);
        ALL_NETHER.addAll(NETHER_LOOT);
        ALL_NETHER.removeIf(ALL_OVERWORLD::contains);
    }

    public static void dispose() {
        RESULT_MAP.clear();
        INGREDIENT_MAP.clear();
        COMPLETION_QUEUE.clear();
        RECIPE_PATH.clear();
        data = null;
    }

    public static void addRecipe(Set<JsonElement> ingredients, ResourceLocation output, ResourceLocation recipe) {
        if (!RandomizerConfig.ensureCompletability) {
            return;
        }
        int i = 0;
        for (JsonElement ing : ingredients) {
            ObjectOpenHashSet items = new ObjectOpenHashSet();
            if (ing.isJsonArray()) {
                for (JsonElement e : ing.getAsJsonArray()) {
                    CompletabilityVerifier.parseJson(e, (Set<ResourceLocation>)items);
                }
            } else {
                CompletabilityVerifier.parseJson(ing, (Set<ResourceLocation>)items);
            }
            CompletabilityVerifier.addIngredients(recipe, i++, (Set<ResourceLocation>)items);
        }
        CompletabilityVerifier.addResult(output, recipe);
    }

    public static void addLootTable(ResourceLocation table, Set<ResourceLocation> stacks) {
        if (!RandomizerConfig.ensureCompletability) {
            return;
        }
        for (ResourceLocation stack : stacks) {
            CompletabilityVerifier.addResult(stack, table);
        }
        if (LootRandomizer.isBlock(table)) {
            ResourceLocation block = LootRandomizer.getBlockFor(table);
            if (block == null) {
                return;
            }
            CompletabilityVerifier.addIngredient(table, block);
        }
        if (LootRandomizer.isEntityDrop(table)) {
            ResourceLocation egg = LootRandomizer.getEggForEntityTable(table);
            if (egg == null) {
                return;
            }
            CompletabilityVerifier.addIngredient(table, egg);
        }
    }

    private static void parseJson(JsonElement element, Set<ResourceLocation> items) {
        String s = element.getAsString();
        if (s.startsWith("#")) {
            ResourceLocation tag = ResourceLocation.parse((String)s.substring(1));
            TAG_MAP.computeIfAbsent((Object)tag, k -> ITEM_REGISTRY.get(ItemTags.create((ResourceLocation)k)).map(holders -> holders.stream().map(Holder::get).map(arg_0 -> ITEM_REGISTRY.getKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet())).orElse(Collections.emptySet()));
            items.add(tag);
        } else {
            items.add(ResourceLocation.parse((String)s));
        }
    }

    private static void addIngredient(@NotNull ResourceLocation recipe, @NotNull ResourceLocation item) {
        CompletabilityVerifier.addIngredients(recipe, 0, Set.of(item));
    }

    private static void addIngredients(@NotNull ResourceLocation recipe, @NotNull Set<ResourceLocation> items) {
        CompletabilityVerifier.addIngredients(recipe, 0, items);
    }

    private static void addIngredients(@NotNull ResourceLocation recipe, int index, @NotNull Set<ResourceLocation> items) {
        if (items.isEmpty()) {
            return;
        }
        ((Set)((Int2ObjectMap)INGREDIENT_MAP.computeIfAbsent((Object)recipe, k -> new Int2ObjectArrayMap())).computeIfAbsent(index, i -> new ObjectOpenHashSet())).addAll(items.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet()));
    }

    private static boolean isTag(ResourceLocation location) {
        return TAG_MAP.containsKey((Object)location);
    }

    private static void addResult(ResourceLocation item, ResourceLocation recipe) {
        ((Set)RESULT_MAP.computeIfAbsent((Object)item, k -> new ObjectOpenHashSet())).add(recipe);
    }

    private static boolean modifyRecipe(ResourceLocation table, ResourceLocation ingredient) {
        if (!CompletabilityVerifier.isLoot(table)) {
            return false;
        }
        MODIFY_RECIPES.put(table, ingredient);
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Table '{}' will be modified to drop '{}'", (Object)table, (Object)ingredient);
        }
        return true;
    }

    private static void commitModifiedRecipes() {
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Commiting {} modified recipes", (Object)MODIFY_RECIPES.size());
        }
        for (ResourceLocation table : MODIFY_RECIPES.keySet()) {
            Set<ResourceLocation> drops = LootRandomizer.getItems(table);
            ResourceLocation randomDrop = (ResourceLocation)drops.stream().findAny().orElseThrow();
            LootRandomizer.registerSpecialDrop(table, randomDrop, MODIFY_RECIPES.get(table));
            CompletabilityVerifier.computeCompletion(table);
            data.addEntry(table, randomDrop, MODIFY_RECIPES.get(table));
        }
        if (!MODIFY_RECIPES.isEmpty()) {
            data.setDirty(true);
        }
    }

    static void ensureCompletability() {
        if (CompletabilityVerifier.data.fromDisk) {
            return;
        }
        PRINT_PATH.add((Component)Component.translatable((String)"Iterating all ender eye recipes"));
        boolean validRecipe = CompletabilityVerifier.ensureCompletability(ENDER_EYE, true);
        if (requiresNether) {
            RECIPE_PATH.clear();
            PRINT_PATH.add((Component)Component.translatable((String)"Requires nether access, iterating obsidian recipes"));
            LOGGER.info("Nether access is required!");
            validRecipe = CompletabilityVerifier.ensureCompletability(OBSIDIAN, true);
            if (!validRecipe) {
                LOGGER.warn("Obsidian is not obtainable!");
            }
            for (ResourceLocation location : COMPLETION_QUEUE) {
                COMPLETABILITY_CACHE.put((Object)location, validRecipe);
            }
        }
        CompletabilityVerifier.commitModifiedRecipes();
        if (validRecipe) {
            isCompletable = true;
        }
        for (Component component : PRINT_PATH) {
            LOGGER.debug(component.getString());
        }
        if (!isCompletable) {
            LOGGER.info("Game is Incompletable!");
        }
    }

    private static boolean ensureCompletability(ResourceLocation ingredient) {
        return CompletabilityVerifier.ensureCompletability(ingredient, false);
    }

    private static boolean ensureCompletability(ResourceLocation ingredient, boolean init) {
        Set<ResourceLocation> passed;
        Set recipes = (Set)RESULT_MAP.get((Object)ingredient);
        if (recipes.isEmpty()) {
            if (RandomizerConfig.enableDebug) {
                LOGGER.debug("No recipes found for ingredient: {}!", (Object)ingredient);
            }
            return false;
        }
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Iterating recipes that make '{}'", (Object)ingredient);
            LOGGER.debug("{} recipes found: {}", (Object)recipes.size(), (Object)recipes);
        }
        if (!(passed = CompletabilityVerifier.iterateRecipes(recipes, false, true)).isEmpty()) {
            return true;
        }
        passed = CompletabilityVerifier.iterateRecipes(recipes, true, true);
        if (passed.isEmpty()) {
            ResourceLocation random = RandomizerUtil.getRandom(ALL_OVERWORLD, RandomizerCore.seededRNG);
            CompletabilityVerifier.print("Ingredient '%s' can be obtained from '%s'", ingredient, random);
            return CompletabilityVerifier.modifyRecipe(random, ingredient);
        }
        CompletabilityVerifier.print("Ingredient '%s' can be obtained from %s", ingredient, passed);
        return true;
    }

    private static void print(String key, Object ... args) {
        PRINT_PATH.add((Component)Component.translatable((String)key, (Object[])args));
    }

    private static Set<ResourceLocation> iterateRecipes(Set<ResourceLocation> recipes, boolean deep, boolean init) {
        if (!deep) {
            Set<Object> obtainableRecipes = recipes.stream().filter(ALL_OVERWORLD::contains).collect(Collectors.toUnmodifiableSet());
            if (!obtainableRecipes.isEmpty()) {
                return obtainableRecipes;
            }
            obtainableRecipes = recipes.stream().filter(ALL_NETHER::contains).collect(Collectors.toUnmodifiableSet());
            if (!obtainableRecipes.isEmpty()) {
                requiresNether = true;
                return obtainableRecipes;
            }
            return Collections.emptySet();
        }
        for (ResourceLocation recipe : recipes) {
            if (!CompletabilityVerifier.addToPath(recipe)) continue;
            if (LootRandomizer.isChestLoot(recipe)) {
                CompletabilityVerifier.walkBack(false);
                continue;
            }
            ObjectCollection indexedIngredients = ((Int2ObjectMap)INGREDIENT_MAP.get((Object)recipe)).values();
            if (indexedIngredients.isEmpty()) {
                CompletabilityVerifier.walkBack(false);
                continue;
            }
            if (!CompletabilityVerifier.iterateIngredients((ObjectCollection<Set<ResourceLocation>>)indexedIngredients, recipe)) continue;
            CompletabilityVerifier.walkBack(true);
            return Set.of(recipe);
        }
        return Collections.emptySet();
    }

    private static Set<ResourceLocation> expandIngredients(Set<ResourceLocation> compactIngredients) {
        return compactIngredients.stream().flatMap(location -> CompletabilityVerifier.isTag(location) ? ((Set)TAG_MAP.get(location)).stream() : Stream.of(location)).collect(Collectors.toUnmodifiableSet());
    }

    private static boolean quickIterateIngredient(Set<ResourceLocation> ingredients, Set<ResourceLocation> iterated, Set<ResourceLocation> failed) {
        for (ResourceLocation ingredient : ingredients) {
            if (!iterated.add(ingredient)) continue;
            if (COMPLETABILITY_CACHE.containsKey((Object)ingredient)) {
                if (COMPLETABILITY_CACHE.getBoolean((Object)ingredient)) {
                    return true;
                }
                if (CompletabilityVerifier.isTag(ingredient)) continue;
                failed.add(ingredient);
                continue;
            }
            if (((Set)RESULT_MAP.get((Object)ingredient)).isEmpty()) {
                if (CompletabilityVerifier.isTag(ingredient)) continue;
                failed.add(ingredient);
                continue;
            }
            Set<ResourceLocation> quickSearch = CompletabilityVerifier.iterateRecipes((Set)RESULT_MAP.get((Object)ingredient), false, false);
            if (!quickSearch.isEmpty()) {
                CompletabilityVerifier.logIngredient(ingredient, RECIPE_PATH.peekLast(), true);
                CompletabilityVerifier.print("Ingredient '%s' can be obtained from %s", ingredient, quickSearch);
                return CompletabilityVerifier.computeCompletion(ingredient);
            }
            if (CompletabilityVerifier.isTag(ingredient)) continue;
            failed.add(ingredient);
        }
        return false;
    }

    private static boolean deepSearch(Set<ResourceLocation> ingredients, ResourceLocation recipe) {
        for (ResourceLocation ingredient : ingredients) {
            if (!CompletabilityVerifier.canObtainIngredient(ingredient, recipe)) continue;
            CompletabilityVerifier.logIngredient(ingredient, recipe, true);
            return true;
        }
        CompletabilityVerifier.logIngredient(ingredients, recipe, false);
        return false;
    }

    private static boolean iterateIngredients(ObjectCollection<Set<ResourceLocation>> ingredientMap, ResourceLocation recipe) {
        int craftableSlots = ingredientMap.size();
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Currently iterating recipe '{}' for their ingredients", (Object)recipe);
        }
        for (Set compactIngredients : ingredientMap) {
            if (compactIngredients.isEmpty()) {
                CompletabilityVerifier.logEmptyIngredients(recipe);
                continue;
            }
            ObjectOpenHashSet iterated = new ObjectOpenHashSet();
            ObjectOpenHashSet failed = new ObjectOpenHashSet();
            if (CompletabilityVerifier.quickIterateIngredient(compactIngredients, (Set<ResourceLocation>)iterated, (Set<ResourceLocation>)failed) || CompletabilityVerifier.quickIterateIngredient(CompletabilityVerifier.expandIngredients(compactIngredients), (Set<ResourceLocation>)iterated, (Set<ResourceLocation>)failed) || CompletabilityVerifier.deepSearch((Set<ResourceLocation>)failed, recipe)) continue;
            --craftableSlots;
        }
        return craftableSlots == ingredientMap.size();
    }

    private static boolean canObtainIngredient(ResourceLocation ingredient, ResourceLocation recipe) {
        if (LootRandomizer.isChestLoot(recipe)) {
            if (RandomizerConfig.enableDebug) {
                LOGGER.debug("Checking loot table '{}'", (Object)recipe);
            }
            return CompletabilityVerifier.computeCompletion(recipe, CompletabilityVerifier::checkLoot);
        }
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Checking ingredient '{}' in recipe '{}'", (Object)ingredient, (Object)recipe);
        }
        return CompletabilityVerifier.computeCompletion(ingredient, CompletabilityVerifier::ensureCompletability);
    }

    private static boolean isLoot(ResourceLocation key) {
        return LootRandomizer.hasTable(key);
    }

    private static boolean checkLoot(ResourceLocation table) {
        if (ALL_OVERWORLD.contains(table)) {
            return CompletabilityVerifier.computeCompletion(table);
        }
        if (ALL_NETHER.contains(table)) {
            requiresNether = true;
            if (!COMPLETION_QUEUE.contains(table)) {
                COMPLETION_QUEUE.add(table);
            }
            return true;
        }
        return false;
    }

    private static boolean computeCompletion(ResourceLocation location) {
        return CompletabilityVerifier.computeCompletion(location, k -> true);
    }

    private static boolean computeCompletion(ResourceLocation location, Predicate<ResourceLocation> predicate) {
        if (!COMPLETABILITY_CACHE.containsKey((Object)location)) {
            COMPLETABILITY_CACHE.put((Object)location, predicate.test(location));
        }
        return COMPLETABILITY_CACHE.getBoolean((Object)location);
    }

    private static void walkBack(boolean success) {
        if (RECIPE_PATH.isEmpty()) {
            LOGGER.error("Cannot walk back on empty path!");
            return;
        }
        ResourceLocation last = RECIPE_PATH.removeLast();
        if (!RandomizerConfig.enableDebug) {
            return;
        }
        if (success) {
            LOGGER.debug("Back to recipe '{}'", (Object)RECIPE_PATH.peekLast());
            PRINT_PATH.add((Component)Component.translatable((String)"Recipe %s is obtainable!", (Object[])new Object[]{last}));
        } else {
            LOGGER.debug("Recipe '{}' is not obtainable, back to recipe '{}'", (Object)last, (Object)RECIPE_PATH.peekLast());
        }
    }

    private static boolean addToPath(ResourceLocation recipe) {
        if (RECIPE_PATH.contains(recipe)) {
            return false;
        }
        RECIPE_PATH.add(recipe);
        return true;
    }

    private static void logIngredient(Object ingredient, ResourceLocation recipe, boolean success) {
        if (!RandomizerConfig.enableDebug) {
            return;
        }
        if (success) {
            LOGGER.debug("Ingredient '{}' in recipe '{}' is obtainable!", ingredient, (Object)recipe);
        } else {
            LOGGER.debug("All ingredients for recipe '{}' are unobtainable!", (Object)recipe);
        }
    }

    private static void logEmptyIngredients(ResourceLocation recipe) {
        if (!RandomizerConfig.enableDebug) {
            return;
        }
        String type = CompletabilityVerifier.isLoot(recipe) ? "Table" : "Recipe";
        LOGGER.debug("{} '{}' has a set of ingredients that is empty!", (Object)type, (Object)recipe);
    }

    static {
        RECIPE_PATH = new ArrayDeque<ResourceLocation>();
        PRINT_PATH = new ArrayDeque<Component>();
        COMPLETION_QUEUE = new ArrayDeque<ResourceLocation>();
        LOGGER = LogUtils.getLogger();
        requiresNether = false;
        isCompletable = false;
        walkingBack = false;
        OVERWORLD_LOOT = Stream.of(BuiltInLootTables.BURIED_TREASURE, BuiltInLootTables.ABANDONED_MINESHAFT, BuiltInLootTables.SIMPLE_DUNGEON, BuiltInLootTables.DESERT_PYRAMID, BuiltInLootTables.ANCIENT_CITY, BuiltInLootTables.ANCIENT_CITY_ICE_BOX, BuiltInLootTables.STRONGHOLD_CORRIDOR, BuiltInLootTables.STRONGHOLD_CROSSING, BuiltInLootTables.STRONGHOLD_LIBRARY, BuiltInLootTables.SHIPWRECK_TREASURE, BuiltInLootTables.SHIPWRECK_MAP, BuiltInLootTables.SHIPWRECK_SUPPLY, BuiltInLootTables.CAT_MORNING_GIFT, BuiltInLootTables.VILLAGE_WEAPONSMITH, BuiltInLootTables.VILLAGE_TOOLSMITH, BuiltInLootTables.VILLAGE_ARMORER, BuiltInLootTables.VILLAGE_CARTOGRAPHER, BuiltInLootTables.VILLAGE_MASON, BuiltInLootTables.VILLAGE_SHEPHERD, BuiltInLootTables.VILLAGE_BUTCHER, BuiltInLootTables.VILLAGE_FLETCHER, BuiltInLootTables.VILLAGE_FISHER, BuiltInLootTables.VILLAGE_TANNERY, BuiltInLootTables.VILLAGE_TEMPLE, BuiltInLootTables.VILLAGE_DESERT_HOUSE, BuiltInLootTables.VILLAGE_PLAINS_HOUSE, BuiltInLootTables.VILLAGE_TAIGA_HOUSE, BuiltInLootTables.VILLAGE_SNOWY_HOUSE, BuiltInLootTables.RUINED_PORTAL, BuiltInLootTables.TRIAL_CHAMBERS_REWARD, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_COMMON, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_RARE, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_UNIQUE, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE, BuiltInLootTables.TRIAL_CHAMBERS_SUPPLY, BuiltInLootTables.TRIAL_CHAMBERS_CORRIDOR, BuiltInLootTables.TRIAL_CHAMBERS_INTERSECTION, BuiltInLootTables.TRIAL_CHAMBERS_INTERSECTION_BARREL, BuiltInLootTables.TRIAL_CHAMBERS_ENTRANCE, BuiltInLootTables.TRIAL_CHAMBERS_CORRIDOR_DISPENSER, BuiltInLootTables.TRIAL_CHAMBERS_CHAMBER_DISPENSER, BuiltInLootTables.TRIAL_CHAMBERS_WATER_DISPENSER, BuiltInLootTables.TRIAL_CHAMBERS_CORRIDOR_POT, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_RANGED, BuiltInLootTables.EQUIPMENT_TRIAL_CHAMBER_MELEE, BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE, BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY, BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY, BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY, BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY, (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.BLACK), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.GRAY), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.LIGHT_GRAY), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.WHITE), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.RED), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.ORANGE), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.YELLOW), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.GREEN), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.CYAN), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.BLUE), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.PURPLE), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.BROWN), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.LIGHT_BLUE), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.LIME), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.MAGENTA), (ResourceKey)BuiltInLootTables.SHEAR_SHEEP_BY_DYE.get(DyeColor.PINK), (ResourceKey)EntityType.COW.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.COD.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.RABBIT.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.TROPICAL_FISH.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.PUFFERFISH.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.SILVERFISH.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.ILLUSIONER.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.PIG.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.PILLAGER.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.ILLUSIONER.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.ZOMBIE.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.CREEPER.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.SPIDER.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.SKELETON.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.WITCH.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.BREEZE.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.ARMADILLO.getDefaultLootTable().orElseThrow()).map(ResourceKey::location).toList();
        OVERWORLD_BLOCKS = Stream.of(Blocks.GRASS_BLOCK, Blocks.DIRT, Blocks.COARSE_DIRT, Blocks.PODZOL, Blocks.MUD, Blocks.STONE, Blocks.ANDESITE, Blocks.GRANITE, Blocks.DIORITE, Blocks.AMETHYST_BLOCK, Blocks.LARGE_AMETHYST_BUD, Blocks.MEDIUM_AMETHYST_BUD, Blocks.SMALL_AMETHYST_BUD, Blocks.OBSIDIAN, Blocks.COBBLESTONE, Blocks.POINTED_DRIPSTONE, Blocks.DRIPSTONE_BLOCK, Blocks.DEEPSLATE, Blocks.CHEST, Blocks.CHISELED_DEEPSLATE, Blocks.COBBLED_DEEPSLATE, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.DEEPSLATE_BRICKS, Blocks.DEEPSLATE_TILES, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.POLISHED_BASALT, Blocks.POLISHED_DEEPSLATE, Blocks.POLISHED_DEEPSLATE_WALL, Blocks.SMOOTH_BASALT, Blocks.CANDLE, Blocks.WHITE_CANDLE, Blocks.GRAY_CARPET, Blocks.GRAY_WOOL, Blocks.BLUE_WOOL, Blocks.LIGHT_BLUE_WOOL, Blocks.CYAN_WOOL, Blocks.PACKED_ICE, Blocks.REDSTONE_WIRE, Blocks.BRICKS, Blocks.COBBLESTONE_SLAB, Blocks.COBBLESTONE_STAIRS, Blocks.COBBLESTONE_WALL, Blocks.DIRT_PATH, Blocks.FARMLAND, Blocks.OAK_PLANKS, Blocks.OAK_SLAB, Blocks.OAK_STAIRS, Blocks.ACACIA_PLANKS, Blocks.ACACIA_SLAB, Blocks.ACACIA_STAIRS, Blocks.SPRUCE_PLANKS, Blocks.SPRUCE_SLAB, Blocks.SPRUCE_STAIRS, Blocks.SMOOTH_SANDSTONE, Blocks.SMOOTH_SANDSTONE_SLAB, Blocks.SMOOTH_SANDSTONE_STAIRS, Blocks.SANDSTONE, Blocks.SANDSTONE_SLAB, Blocks.SANDSTONE_STAIRS, Blocks.WHEAT, Blocks.POTATOES, Blocks.CARROTS, Blocks.BEETROOTS, Blocks.STONE_BRICKS, Blocks.MOSSY_STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, Blocks.STONE_BRICK_STAIRS, Blocks.STONE_BRICK_SLAB, Blocks.SMOOTH_STONE_SLAB, Blocks.IRON_BARS, Blocks.IRON_DOOR, Blocks.STONE_BUTTON, Blocks.OAK_DOOR, Blocks.BOOKSHELF, Blocks.OAK_FENCE, Blocks.DARK_OAK_PLANKS, Blocks.DARK_OAK_FENCE, Blocks.RAIL, Blocks.COBWEB, Blocks.MUD_BRICKS, Blocks.MUD_BRICK_STAIRS, Blocks.BLUE_TERRACOTTA, Blocks.YELLOW_TERRACOTTA, Blocks.RED_TERRACOTTA, Blocks.CYAN_TERRACOTTA, Blocks.BRICK_SLAB, Blocks.BIRCH_FENCE, Blocks.BIRCH_PLANKS, Blocks.BIRCH_SLAB, Blocks.BIRCH_STAIRS, Blocks.DARK_OAK_DOOR, Blocks.DARK_OAK_FENCE, Blocks.DARK_OAK_LOG, Blocks.DARK_OAK_PLANKS, Blocks.DARK_OAK_SLAB, Blocks.DARK_OAK_STAIRS, Blocks.JUNGLE_DOOR, Blocks.JUNGLE_FENCE, Blocks.JUNGLE_LOG, Blocks.JUNGLE_PLANKS, Blocks.JUNGLE_SLAB, Blocks.JUNGLE_STAIRS, Blocks.OAK_DOOR, Blocks.OAK_FENCE, Blocks.OAK_LOG, Blocks.OAK_PLANKS, Blocks.OAK_SLAB, Blocks.OAK_STAIRS, Blocks.SPRUCE_DOOR, Blocks.SPRUCE_FENCE, Blocks.SPRUCE_LOG, Blocks.SPRUCE_PLANKS, Blocks.SPRUCE_SLAB, Blocks.SPRUCE_STAIRS, Blocks.ACACIA_LOG, Blocks.BIRCH_LOG, Blocks.CHERRY_LOG, Blocks.OAK_LOG, Blocks.DARK_OAK_LOG, Blocks.SPRUCE_LOG, Blocks.IRON_ORE, Blocks.GOLD_ORE, Blocks.COPPER_ORE, Blocks.COAL_ORE, Blocks.DIAMOND_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.CORNFLOWER, Blocks.SUNFLOWER, Blocks.DANDELION, Blocks.ORANGE_TULIP, Blocks.PINK_TULIP, Blocks.RED_TULIP, Blocks.WHITE_TULIP, Blocks.ROSE_BUSH, Blocks.SMALL_DRIPLEAF, Blocks.BIG_DRIPLEAF).distinct().map(block -> ((ResourceKey)block.getLootTable().orElseThrow()).location()).toList();
        ALL_OVERWORLD = new ArrayList<ResourceLocation>();
        NETHER_BLOCKS = Stream.of(Blocks.NETHERRACK, Blocks.SOUL_SAND, Blocks.GLOWSTONE, Blocks.MAGMA_BLOCK, Blocks.GRAVEL, Blocks.SOUL_SAND, Blocks.BASALT, Blocks.SOUL_SOIL, Blocks.BONE_BLOCK, Blocks.NETHER_QUARTZ_ORE, Blocks.NETHER_GOLD_ORE, Blocks.ANCIENT_DEBRIS, Blocks.BASALT, Blocks.POLISHED_BASALT, Blocks.BLACKSTONE, Blocks.GILDED_BLACKSTONE, Blocks.POLISHED_BLACKSTONE_BRICKS, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS, Blocks.CHISELED_POLISHED_BLACKSTONE, Blocks.GOLD_BLOCK, Blocks.MAGMA_BLOCK, Blocks.QUARTZ_BLOCK, Blocks.SMOOTH_QUARTZ, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICK_FENCE, Blocks.NETHER_BRICK_STAIRS, Blocks.NETHER_WART, Blocks.CRIMSON_STEM, Blocks.NETHER_WART_BLOCK, Blocks.SHROOMLIGHT, Blocks.WEEPING_VINES, Blocks.WARPED_STEM, Blocks.WARPED_WART_BLOCK, Blocks.SHROOMLIGHT).distinct().map(block -> ((ResourceKey)block.getLootTable().orElseThrow()).location()).toList();
        ALL_NETHER = new ArrayList<ResourceLocation>();
        NETHER_LOOT = Stream.of(BuiltInLootTables.BASTION_BRIDGE, BuiltInLootTables.BASTION_OTHER, BuiltInLootTables.BASTION_HOGLIN_STABLE, BuiltInLootTables.BASTION_TREASURE, BuiltInLootTables.NETHER_BRIDGE, BuiltInLootTables.PIGLIN_BARTERING, (ResourceKey)EntityType.BLAZE.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.PIGLIN.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.PIGLIN_BRUTE.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.ZOGLIN.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.HOGLIN.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.GHAST.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.WITHER_SKELETON.getDefaultLootTable().orElseThrow(), (ResourceKey)EntityType.MAGMA_CUBE.getDefaultLootTable().orElseThrow()).map(ResourceKey::location).toList();
    }

    private static class VerifierSaveData
    extends SavedData {
        public static final Codec<VerifierSaveData> CODEC = new Codec<VerifierSaveData>(){

            public <T> DataResult<T> encode(VerifierSaveData saveData, DynamicOps<T> dynamicOps, T t) {
                return CompoundTag.CODEC.encode((Object)saveData.save(), dynamicOps, t);
            }

            public <T> DataResult<Pair<VerifierSaveData, T>> decode(DynamicOps<T> dynamicOps, T t) {
                return CompoundTag.CODEC.decode(dynamicOps, t).map(p -> p.mapFirst(VerifierSaveData::load));
            }
        };
        public static final SavedDataType<VerifierSaveData> FACTORY = new SavedDataType("%s_modified_data".formatted("randomizer"), VerifierSaveData::new, CODEC, DataFixTypes.LEVEL);
        private final List<ModificationData> modificationData = new ArrayList<ModificationData>();
        public boolean fromDisk = false;

        private VerifierSaveData() {
        }

        public static VerifierSaveData get(DimensionDataStorage storage) {
            return (VerifierSaveData)storage.computeIfAbsent(FACTORY);
        }

        public void addEntry(ResourceLocation table, ResourceLocation original, ResourceLocation replacement) {
            this.addEntry(new ModificationData(table, original, replacement));
        }

        private void addEntry(ModificationData data) {
            if (!this.modificationData.contains(data)) {
                this.modificationData.add(data);
            }
        }

        @NotNull
        public CompoundTag save() {
            return this.save(new CompoundTag());
        }

        @NotNull
        public CompoundTag save(@NotNull CompoundTag tag) {
            ListTag data = new ListTag();
            LOGGER.info("Saving Verification Data!");
            for (ModificationData table : this.modificationData) {
                data.add((Object)table.toNBT());
            }
            LOGGER.info("Wrote {} entries!", (Object)this.modificationData.size());
            tag.put("data", (Tag)data);
            return tag;
        }

        public static VerifierSaveData load(CompoundTag tag) {
            VerifierSaveData data = new VerifierSaveData();
            tag.getList("data").map(ListTag::stream).ifPresent(stream -> stream.map(Tag::asCompound).filter(Optional::isPresent).map(Optional::get).map(ModificationData::fromNBT).filter(data1 -> LootRandomizer.getKnownTables().contains(data1.table())).forEach(data::addEntry));
            if (!data.modificationData.isEmpty()) {
                data.fromDisk = true;
            }
            return data;
        }
    }

    private record ModificationData(ResourceLocation table, ResourceLocation original, ResourceLocation replacement) {
        public CompoundTag toNBT() {
            return CompoundTag.builder().put("id", this.table.toString()).put("original", this.original.toString()).put("replacement", this.replacement.toString()).build();
        }

        public static ModificationData fromNBT(CompoundTag tag) {
            return new ModificationData(ResourceLocation.parse((String)((String)tag.getString("id").orElseThrow())), ResourceLocation.parse((String)((String)tag.getString("original").orElseThrow())), ResourceLocation.parse((String)((String)tag.getString("replacement").orElseThrow())));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ModificationData)) return false;
            ModificationData modificationData = (ModificationData)obj;
            if (!this.table().equals((Object)modificationData.table())) return false;
            return true;
        }
    }
}

