/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.RandomizationMapData;
import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.StructureRandomizer;
import com.ghzdude.randomizer.io.ConfigIO;
import com.ghzdude.randomizer.special.generators.EnchantmentGenerator;
import com.ghzdude.randomizer.special.generators.PotionGenerator;
import com.ghzdude.randomizer.special.item.SpecialItems;
import com.ghzdude.randomizer.util.RandomizerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.TickEvent;

public class ItemRandomizer {
    private static final Object2IntMap<ResourceLocation> VALID_ITEMS = new Object2IntOpenHashMap();
    private static final List<ResourceLocation> ITEM_LIST = new ArrayList<ResourceLocation>();
    private static final Object2IntMap<ResourceLocation> SIMPLE_ITEMS = new Object2IntOpenHashMap();
    private static final List<ResourceLocation> BLACKLISTED_ITEMS = new ArrayList<ResourceLocation>();
    private static RandomizationMapData INSTANCE;
    private static Registry<Item> REGISTRY;
    private static FeatureFlagSet ENABLED;
    private static final String POINT_KEY = "points";
    private static final String POINT_MAX_KEY = "point_max";
    private static final String CYCLE_KEY = "cycle";
    private static final String CYCLE_COUNTER_KEY = "cycle_counter";
    private static final String AMOUNT_KEY = "amount_items_given";
    private static int OFFSET;
    private static final int COUNTER_MAX = 50;

    static void init(MinecraftServer server) {
        ITEM_LIST.clear();
        BLACKLISTED_ITEMS.clear();
        VALID_ITEMS.clear();
        REGISTRY = server.registryAccess().lookupOrThrow(Registries.ITEM);
        ENABLED = server.getWorldData().enabledFeatures();
        SpecialItems.init(arg_0 -> REGISTRY.getKey(arg_0));
        BLACKLISTED_ITEMS.addAll(ConfigIO.read("blacklisted_items", Stream.of(Items.COMMAND_BLOCK, Items.COMMAND_BLOCK_MINECART, Items.CHAIN_COMMAND_BLOCK, Items.REPEATING_COMMAND_BLOCK, Items.BARRIER, Items.LIGHT, Items.STRUCTURE_BLOCK, Items.STRUCTURE_VOID, Items.KNOWLEDGE_BOOK, Items.JIGSAW, Items.TEST_BLOCK, Items.TEST_INSTANCE_BLOCK, Items.DEBUG_STICK).map(arg_0 -> REGISTRY.getKey(arg_0)).filter(Objects::nonNull).toList(), REGISTRY));
        BLACKLISTED_ITEMS.add(REGISTRY.getKey((Object)Items.AIR));
        ConfigIO.readValues("items", SpecialItems.CONFIGURED_ITEMS, REGISTRY).object2IntEntrySet().forEach(ItemRandomizer::putValidItem);
        for (ResourceLocation loc : REGISTRY.keySet()) {
            ItemRandomizer.putValidItem(loc, 1);
        }
        for (ResourceLocation loc : VALID_ITEMS.keySet()) {
            REGISTRY.get(loc).map(ItemStack::new).filter(stack -> !EnchantmentGenerator.canEnchant(stack) && !PotionGenerator.canHaveEffect(stack)).map(ItemStack::getItem).ifPresent(stack -> SIMPLE_ITEMS.put((Object)loc, VALID_ITEMS.getInt(stack)));
        }
        ITEM_LIST.addAll((Collection<ResourceLocation>)VALID_ITEMS.keySet());
        INSTANCE = RandomizationMapData.get(server, "item");
    }

    private static void putValidItem(Map.Entry<ResourceLocation, Integer> entry) {
        if (entry instanceof Object2IntMap.Entry) {
            Object2IntMap.Entry intEntry = (Object2IntMap.Entry)entry;
            ItemRandomizer.putValidItem(entry.getKey(), intEntry.getIntValue());
        } else {
            ItemRandomizer.putValidItem(entry.getKey(), entry.getValue());
        }
    }

    private static void putValidItem(ResourceLocation loc, int value) {
        Item item = RandomizerUtil.getOrThrow(REGISTRY, loc);
        if (ItemRandomizer.isBlacklisted(item) || VALID_ITEMS.containsKey((Object)loc) || ENABLED == null || !item.isEnabled(ENABLED)) {
            return;
        }
        VALID_ITEMS.put((Object)loc, value);
    }

    public static int giveRandomItem(int pointsToUse, Inventory inventory) {
        inventory.player.displayClientMessage((Component)Component.translatable((String)"randomizer.giving_item.label"), true);
        return RandomizerConfig.giveMultipleItems ? RandomizerUtil.giveMultiple(pointsToUse, inventory) : RandomizerUtil.giveOnce(pointsToUse, inventory);
    }

    public static int getPointValue(Item item) {
        return ItemRandomizer.getPointValue(REGISTRY.getKey((Object)item));
    }

    public static int getPointValue(ResourceLocation item) {
        return VALID_ITEMS.getInt((Object)item);
    }

    public static Item getRandomItem(Random rng, int points) {
        ResourceLocation toReturn;
        while (ItemRandomizer.getPointValue(toReturn = RandomizerUtil.getRandom(ITEM_LIST, rng)) > points) {
        }
        return (Item)((Holder.Reference)REGISTRY.get(toReturn).orElseThrow()).get();
    }

    public static Item getRandomItem(int points) {
        return ItemRandomizer.getRandomItem(RandomizerCore.unseededRNG, points);
    }

    public static ItemStack getRandomItemStack(Random rng) {
        ResourceLocation item = RandomizerUtil.getRandom(ITEM_LIST, rng);
        return RandomizerUtil.itemToStack(INSTANCE.getItemFor((Item)((Holder.Reference)REGISTRY.get(item).orElseThrow()).get()));
    }

    public static Stream<Item> getValidItems() {
        return ItemRandomizer.getKeys().map(arg_0 -> REGISTRY.get(arg_0)).map(Optional::orElseThrow).map(Holder::get);
    }

    public static Stream<ResourceLocation> getKeys() {
        return ITEM_LIST.stream();
    }

    public static boolean isBlacklisted(Item item) {
        return ItemRandomizer.isBlacklisted(REGISTRY.getKey((Object)item));
    }

    public static boolean isBlacklisted(ResourceLocation item) {
        return BLACKLISTED_ITEMS.contains(item);
    }

    static void playerTickPre(TickEvent.PlayerTickEvent.Pre event) {
        if (!ItemRandomizer.shouldTick(event)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player();
        CompoundTag data = player.getPersistentData();
        if (ItemRandomizer.shouldUsePoints(player)) {
            int pointsToUse;
            int pointMax = data.getInt(POINT_MAX_KEY).orElseGet(() -> {
                data.putInt(POINT_MAX_KEY, 1);
                return 1;
            });
            int points = RandomizerConfig.pointsCarryover ? data.getIntOr(POINT_KEY, 0) + pointMax : pointMax;
            int remaining = pointsToUse = RandomizerCore.seededRNG.nextInt(points) + 1;
            if (RandomizerConfig.generateStructures && RandomizerCore.seededRNG.nextInt(100) < RandomizerConfig.structureProbability) {
                remaining = StructureRandomizer.tryPlace(pointsToUse, player.level(), player);
            } else if (RandomizerConfig.giveRandomItems) {
                remaining = ItemRandomizer.giveRandomItem(pointsToUse, player.getInventory());
            }
            if (remaining < pointsToUse) {
                ItemRandomizer.increaseCycle((Player)player, data);
            }
            data.putInt(POINT_KEY, remaining);
        }
    }

    private static boolean shouldUsePoints(ServerPlayer player) {
        return player.gameMode.isSurvival();
    }

    private static boolean shouldTick(TickEvent.PlayerTickEvent.Pre event) {
        if (event.side().isClient()) {
            return false;
        }
        if (OFFSET < 0) {
            OFFSET = 0;
        }
        return ++OFFSET % RandomizerConfig.itemCooldown == 0;
    }

    private static void increaseCycle(Player player, CompoundTag data) {
        int cycleCounter;
        int pointMax = data.getIntOr(POINT_MAX_KEY, 1);
        int cycle = data.getIntOr(CYCLE_KEY, 0) + 1;
        if (cycle % (cycleCounter = data.getIntOr(CYCLE_COUNTER_KEY, RandomizerConfig.cycleBase)) == 0) {
            cycle = 0;
            int i = cycleCounter / 2 + 1;
            cycleCounter = Math.min(cycleCounter + i, 50);
            player.displayClientMessage((Component)Component.translatable((String)"randomizer.player.point_max.increased", (Object[])new Object[]{++pointMax}), false);
        }
        data.putInt(POINT_MAX_KEY, pointMax);
        data.putInt(CYCLE_KEY, cycle);
        data.putInt(CYCLE_COUNTER_KEY, cycleCounter);
    }

    public static void incrementAmtItemsGiven(Player player) {
        ItemRandomizer.incrementAmtItemsGiven(player.getPersistentData());
    }

    public static void incrementAmtItemsGiven(CompoundTag data) {
        data.putInt(AMOUNT_KEY, data.getIntOr(AMOUNT_KEY, 0) + 1);
    }

    static {
        OFFSET = 0;
    }
}

