/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.ItemRandomizer;
import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.io.ConfigIO;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import org.slf4j.Logger;

public class MobRandomizer {
    private static final List<ResourceLocation> BLACKLISTED_ENTITIES = new ArrayList<ResourceLocation>();
    private static final List<MobCategory> BLACKLISTED_CATEGORIES = List.of(MobCategory.MISC);
    private static final List<ResourceLocation> BLACKLISTED_ATTRIBUTES = new ArrayList<ResourceLocation>();
    private static final List<ResourceLocation> VALID_ATTRIBUTES = new ArrayList<ResourceLocation>();
    private static final List<AttributeInfo> SPECIAL_ATTRIBUTES = List.of(AttributeInfo.of((Holder<Attribute>)Attributes.SCALE, 0.1, 32.0), AttributeInfo.of((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.5, 4.0), AttributeInfo.of((Holder<Attribute>)Attributes.FLYING_SPEED, 0.5, 4.0), AttributeInfo.of((Holder<Attribute>)Attributes.ARMOR, 0.0, 32.0, Op.ADD), AttributeInfo.of((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 0.0, 32.0, Op.ADD), AttributeInfo.of((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 0.0, 32.0, Op.ADD), AttributeInfo.of((Holder<Attribute>)Attributes.ATTACK_SPEED, 0.5, 4.0), AttributeInfo.of((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, 0.0, 32.0, Op.ADD), AttributeInfo.of((Holder<Attribute>)Attributes.WAYPOINT_TRANSMIT_RANGE, 4.0, 4096.0, Op.ADD), AttributeInfo.of((Holder<Attribute>)Attributes.GRAVITY, 0.5, 2.0), AttributeInfo.of((Holder<Attribute>)Attributes.STEP_HEIGHT, 0.5, 16.0), AttributeInfo.of((Holder<Attribute>)Attributes.MAX_HEALTH, 0.0, 1024.0, Op.ADD), AttributeInfo.of((Holder<Attribute>)Attributes.MAX_ABSORPTION, 0.0, 1024.0, Op.ADD));
    private static final List<EntityType<?>> VALID_TYPES = new ArrayList();
    private static final List<EntitySpawnReason> VALID_REASONS = new ArrayList<EntitySpawnReason>();
    private static final int MAGIC_NUMBER = 289;
    private static Registry<Attribute> ATTRIBUTE_REGISTRY;
    private static Registry<EntityType<?>> TYPE_REGISTRY;
    private static final Logger LOGGER;

    static void init(RegistryAccess access) {
        ATTRIBUTE_REGISTRY = access.lookupOrThrow(Registries.ATTRIBUTE);
        TYPE_REGISTRY = access.lookupOrThrow(Registries.ENTITY_TYPE);
        if (BLACKLISTED_ENTITIES.isEmpty()) {
            BLACKLISTED_ENTITIES.addAll(ConfigIO.read("blacklisted_mobs", Stream.of(EntityType.ENDER_DRAGON, EntityType.WITHER, EntityType.WARDEN, EntityType.GIANT).map(arg_0 -> TYPE_REGISTRY.getKey(arg_0)).filter(Objects::nonNull).toList(), TYPE_REGISTRY));
        }
        if (BLACKLISTED_ATTRIBUTES.isEmpty()) {
            BLACKLISTED_ATTRIBUTES.addAll(ConfigIO.read("blacklisted_attributes", Stream.of(Attributes.SCALE, Attributes.GRAVITY, Attributes.LUCK, Attributes.SWEEPING_DAMAGE_RATIO, Attributes.WAYPOINT_RECEIVE_RANGE, Attributes.TEMPT_RANGE, Attributes.BLOCK_INTERACTION_RANGE, Attributes.BLOCK_BREAK_SPEED, Attributes.CAMERA_DISTANCE, Attributes.BURNING_TIME).map(Holder::get).map(arg_0 -> ATTRIBUTE_REGISTRY.getKey(arg_0)).filter(Objects::nonNull).toList(), ATTRIBUTE_REGISTRY));
        }
        for (ResourceLocation type : TYPE_REGISTRY.keySet()) {
            if (BLACKLISTED_ENTITIES.contains(type)) continue;
            TYPE_REGISTRY.get(type).map(Holder::get).filter(e -> !BLACKLISTED_CATEGORIES.contains(e.getCategory())).ifPresent(VALID_TYPES::add);
        }
        for (ResourceLocation att : ATTRIBUTE_REGISTRY.keySet()) {
            if (BLACKLISTED_ATTRIBUTES.contains(att)) continue;
            VALID_ATTRIBUTES.add(att);
        }
        VALID_REASONS.addAll(List.of(EntitySpawnReason.SPAWNER, EntitySpawnReason.BREEDING, EntitySpawnReason.CHUNK_GENERATION, EntitySpawnReason.TRIAL_SPAWNER, EntitySpawnReason.PATROL, EntitySpawnReason.NATURAL, EntitySpawnReason.JOCKEY, EntitySpawnReason.STRUCTURE, EntitySpawnReason.BUCKET, EntitySpawnReason.CONVERSION));
    }

    static boolean randomizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        EntitySpawnReason spawnReason;
        boolean cancel = false;
        Mob entity = event.getEntity();
        CompoundTag data = entity.getPersistentData();
        if (RandomizerConfig.randomizeMobs && VALID_REASONS.contains(spawnReason = event.getSpawnReason()) && !data.contains("randomized")) {
            entity = MobRandomizer.randomizeMobSpawn((Entity)entity, spawnReason);
            cancel = true;
        }
        if (RandomizerConfig.randomizeMobAttributes && !data.contains("added_attribute") && RandomizerCore.seededRNG.nextInt(100) < 30) {
            List<AttributeInstance> applicable = VALID_ATTRIBUTES.stream().map(arg_0 -> ATTRIBUTE_REGISTRY.get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(arg_0 -> ((Mob)entity).getAttribute(arg_0)).filter(Objects::nonNull).toList();
            double offset = 1.0;
            int amt = 1 + RandomizerCore.seededRNG.nextInt(3);
            ArrayList<String> added = new ArrayList<String>(amt);
            for (int i = 0; i < amt; ++i) {
                AttributeModifier modifier;
                AttributeInstance instance = RandomizerUtil.getRandom(applicable, RandomizerCore.seededRNG);
                Attribute attribute = (Attribute)instance.getAttribute().get();
                ResourceLocation att = ATTRIBUTE_REGISTRY.getKey((Object)attribute);
                Optional<AttributeInfo> info = AttributeInfo.fromLocation(att);
                if (info.isPresent()) {
                    modifier = info.get().toModifier();
                } else {
                    double sanitizedMin = attribute.sanitizeValue(-0.5);
                    modifier = MobRandomizer.createModifier(sanitizedMin, sanitizedMin + 1.0, att);
                }
                instance.addOrReplacePermanentModifier(modifier);
                added.add("%s(x%f.2)".formatted(modifier.id().getPath(), modifier.amount()));
            }
            if (!added.isEmpty() && RandomizerConfig.enableDebug) {
                entity.setCustomName((Component)Component.literal((String)"%s".formatted(added)));
            }
            data.putBoolean("added_attribute", true);
        }
        return cancel;
    }

    private static AttributeModifier createModifier(double min, double max, ResourceLocation location) {
        return new AttributeModifier(location, RandomizerCore.unseededRNG.nextDouble(min, max), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static Mob getRandomMob(Level level, EntitySpawnReason reason) {
        EntityType<?> entityType = RandomizerUtil.getRandom(VALID_TYPES, RandomizerCore.unseededRNG);
        Entity mob = entityType.create(level, reason);
        if (!(mob instanceof Mob)) {
            throw new IllegalStateException("mob failed to create for some reason!");
        }
        return (Mob)mob;
    }

    private static void spawnMob(ServerLevel level, Entity mob, Entity reference) {
        mob.setPos(reference.position());
        mob.setXRot(reference.getXRot());
        mob.setYRot(reference.getYRot());
        mob.getSlot(EquipmentSlot.MAINHAND.getIndex()).set(ItemRandomizer.getRandomItemStack(RandomizerCore.unseededRNG));
        mob.getPersistentData().putBoolean("randomized", true);
        NaturalSpawner.SpawnState state = level.getChunkSource().getLastSpawnState();
        if (state != null) {
            MobCategory category = mob.getType().getCategory();
            int count = state.getMobCategoryCounts().getOrDefault((Object)category, 0);
            if (count <= category.getMaxInstancesPerChunk() * state.getSpawnableChunkCount() / 289) {
                level.addFreshEntity(mob);
            }
        }
    }

    private static Mob randomizeMobSpawn(Entity toSpawn, EntitySpawnReason reason) {
        ServerLevel level = (ServerLevel)toSpawn.level();
        Mob mob = MobRandomizer.getRandomMob((Level)level, reason);
        MobRandomizer.spawnMob(level, (Entity)mob, toSpawn);
        return mob;
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    record AttributeInfo(ResourceLocation loc, double min, double max, Op op) {
        static Map<ResourceLocation, AttributeInfo> MAP = new Object2ObjectOpenHashMap();

        public static AttributeInfo of(Holder<Attribute> holder, double min, double max) {
            return AttributeInfo.of(holder, min, max, Op.ADD_M_BASE);
        }

        public static AttributeInfo of(Holder<Attribute> holder, double min, double max, Op op) {
            return holder.unwrapKey().map(ResourceKey::location).map(location -> {
                AttributeInfo info = new AttributeInfo((ResourceLocation)location, min, max, op);
                MAP.put((ResourceLocation)location, info);
                return info;
            }).orElseThrow();
        }

        public static Optional<AttributeInfo> fromLocation(ResourceLocation loc) {
            return Optional.ofNullable(MAP.get(loc));
        }

        public AttributeModifier toModifier() {
            double d = RandomizerCore.unseededRNG.nextDouble(this.min(), this.max());
            return new AttributeModifier(this.loc(), d, this.op().getOperation());
        }
    }

    static enum Op {
        ADD(AttributeModifier.Operation.ADD_VALUE),
        ADD_M_BASE(AttributeModifier.Operation.ADD_MULTIPLIED_BASE),
        ADD_M_TOTAL(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

        private final AttributeModifier.Operation operation;

        private Op(AttributeModifier.Operation operation) {
            this.operation = operation;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }
    }
}

