/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.ItemRandomizer;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RandomizationMapData
extends SavedData {
    public static final RandomizationMapData VANILLA = new DefaultedMapData();
    public static final Codec<RandomizationMapData> CODEC = Codec.of((Encoder)new Encoder<RandomizationMapData>(){

        public <T> DataResult<T> encode(RandomizationMapData randomizationMapData, DynamicOps<T> dynamicOps, T t) {
            CompoundTag tag = randomizationMapData.save(new CompoundTag());
            return CompoundTag.CODEC.encode((Object)tag, dynamicOps, t);
        }
    }, (Decoder)new Decoder<RandomizationMapData>(){

        public <T> DataResult<Pair<RandomizationMapData, T>> decode(DynamicOps<T> dynamicOps, T t) {
            DataResult result = CompoundTag.CODEC.decode(dynamicOps, t);
            if (result.isSuccess()) {
                RandomizationMapData data = RandomizationMapData.load((CompoundTag)((Pair)result.getOrThrow()).getFirst());
                return DataResult.success((Object)Pair.of((Object)((Object)data), t));
            }
            return DataResult.error(() -> "failed");
        }
    });
    private static final Object2ObjectMap<String, SavedDataType<RandomizationMapData>> TYPE_MAP = new Object2ObjectOpenHashMap();
    private static final ResourceLocation AIR = ResourceLocation.parse((String)"minecraft:air");
    private static final Random RNG = new Random();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> ITEM_MAP = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> ITEM_MAP_REVERSE = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> TAGKEY_MAP = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> TAGKEY_MAP_REVERSE = new Object2ObjectOpenHashMap();
    private static Registry<Item> ITEM_REGISTRY;
    private boolean isLoaded = false;

    public RandomizationMapData() {
        this.ITEM_MAP.defaultReturnValue((Object)AIR);
        this.ITEM_MAP_REVERSE.defaultReturnValue((Object)AIR);
        this.TAGKEY_MAP.defaultReturnValue((Object)AIR);
        this.TAGKEY_MAP_REVERSE.defaultReturnValue((Object)AIR);
    }

    static void init(RegistryAccess access) {
        ITEM_REGISTRY = access.lookupOrThrow(Registries.ITEM);
    }

    public static RandomizationMapData get(DimensionDataStorage storage, String prefix) {
        String name = "randomizer_" + prefix;
        SavedDataType type = (SavedDataType)TYPE_MAP.computeIfAbsent((Object)name, k -> new SavedDataType(name, RandomizationMapData::new, CODEC, DataFixTypes.LEVEL));
        RandomizationMapData data = (RandomizationMapData)storage.computeIfAbsent(type);
        if (!data.isLoaded()) {
            data.generateItemMap();
            data.generateTagMap();
            data.setDirty();
            data.isLoaded = true;
        }
        return data;
    }

    public static RandomizationMapData get(MinecraftServer server, String prefix) {
        return RandomizationMapData.get(server.overworld().getDataStorage(), prefix);
    }

    public static RandomizationMapData get(ServerLevel serverLevel, String prefix) {
        return RandomizationMapData.get(serverLevel.getServer(), prefix);
    }

    private static boolean isInvalid(ResourceLocation loc) {
        return ItemRandomizer.isBlacklisted(loc) || loc.getPath().isEmpty();
    }

    @NotNull
    public CompoundTag save(CompoundTag tag) {
        LOGGER.warn("Saving randomizations to disk!");
        CompoundTag itemMap = new CompoundTag();
        CompoundTag tagKeyMap = new CompoundTag();
        this.ITEM_MAP.forEach((vanilla, random) -> {
            if (RandomizationMapData.isInvalid(vanilla) || RandomizationMapData.isInvalid(random)) {
                return;
            }
            itemMap.putString(vanilla.toString(), random.toString());
        });
        this.TAGKEY_MAP.forEach((vanilla, random) -> {
            if (RandomizationMapData.isInvalid(vanilla) || RandomizationMapData.isInvalid(random)) {
                return;
            }
            tagKeyMap.putString(vanilla.toString(), random.toString());
        });
        tag.put("item_map", (Tag)itemMap);
        tag.put("tag_key_map", (Tag)tagKeyMap);
        return tag;
    }

    public static RandomizationMapData load(CompoundTag tag) {
        Optional<ResourceLocation> random;
        ResourceLocation vanilla;
        RandomizationMapData data = new RandomizationMapData();
        LOGGER.warn("Loading from disk!");
        CompoundTag itemMap = tag.getCompoundOrEmpty("item_map");
        CompoundTag tagMap = tag.getCompoundOrEmpty("tag_key_map");
        for (String item : itemMap.keySet()) {
            vanilla = ResourceLocation.parse((String)item);
            random = itemMap.getString(item).map(ResourceLocation::tryParse);
            if (random.isEmpty() || RandomizationMapData.isInvalid(vanilla) || RandomizationMapData.isInvalid(random.get())) continue;
            data.putItem(vanilla, random.get());
        }
        ObjectSet loadedKeys = data.ITEM_MAP.keySet();
        Set validKeys = ItemRandomizer.getKeys().collect(Collectors.toSet());
        Sets.SetView difference = Sets.difference(validKeys, (Set)loadedKeys);
        if (!difference.isEmpty()) {
            RandomizationMapData.generateMap((Set<ResourceLocation>)difference, data::putItem);
            RandomizationMapData.logDifference((Set<ResourceLocation>)difference);
        }
        for (String tagKey : tagMap.keySet()) {
            vanilla = ResourceLocation.parse((String)tagKey);
            random = tagMap.getString(tagKey).map(ResourceLocation::tryParse);
            if (random.isEmpty() || RandomizationMapData.isInvalid(vanilla) || RandomizationMapData.isInvalid(random.get())) continue;
            data.putTag(vanilla, random.get());
        }
        data.getItems().stream().filter(l -> l.equals((Object)data.getItemFor((ResourceLocation)l))).forEach(RandomizationMapData::logMatchingKey);
        loadedKeys = data.TAGKEY_MAP.keySet();
        validKeys = ITEM_REGISTRY.getTags().map(HolderSet.Named::key).map(TagKey::location).collect(Collectors.toSet());
        difference = Sets.difference(validKeys, (Set)loadedKeys);
        if (!difference.isEmpty()) {
            RandomizationMapData.generateMap((Set<ResourceLocation>)difference, data::putTag);
            RandomizationMapData.logDifference((Set<ResourceLocation>)difference);
        }
        data.getTags().stream().filter(l -> l.equals((Object)data.getTagKeyFor((ResourceLocation)l))).forEach(RandomizationMapData::logMatchingKey);
        data.setDirty();
        data.isLoaded = true;
        return data;
    }

    private static void generateMap(Set<ResourceLocation> vanilla, BiConsumer<ResourceLocation, ResourceLocation> putItem) {
        RandomizationMapData.generateMap(new ArrayList<ResourceLocation>(vanilla), putItem);
    }

    private void generateTagMap() {
        List<ResourceLocation> vanilla = ITEM_REGISTRY.getTags().map(HolderSet.Named::key).map(TagKey::location).collect(Collectors.toList());
        RandomizationMapData.generateMap(vanilla, this::putTag);
        ObjectSet loadedKeys = this.TAGKEY_MAP.keySet();
        Set<ResourceLocation> validKeys = ITEM_REGISTRY.getTags().map(HolderSet.Named::key).map(TagKey::location).collect(Collectors.toSet());
        validKeys.removeIf(((Set)loadedKeys)::contains);
        if (!validKeys.isEmpty()) {
            RandomizationMapData.logDifference(validKeys);
        }
        this.TAGKEY_MAP.keySet().stream().filter(l -> l.equals(this.TAGKEY_MAP.get(l))).forEach(RandomizationMapData::logMatchingKey);
    }

    private void generateItemMap() {
        List<ResourceLocation> vanilla = ItemRandomizer.getKeys().collect(Collectors.toList());
        RandomizationMapData.generateMap(vanilla, this::putItem);
        ObjectSet loadedKeys = this.ITEM_MAP.keySet();
        Set<ResourceLocation> validKeys = ItemRandomizer.getKeys().collect(Collectors.toSet());
        validKeys.removeIf(((Set)loadedKeys)::contains);
        if (!validKeys.isEmpty()) {
            RandomizationMapData.logDifference(validKeys);
        }
        this.ITEM_MAP.keySet().stream().filter(l -> l.equals(this.ITEM_MAP.get(l))).forEach(RandomizationMapData::logMatchingKey);
    }

    private static void generateMap(List<ResourceLocation> vanilla, BiConsumer<ResourceLocation, ResourceLocation> biConsumer) {
        if (vanilla.size() == 1) {
            return;
        }
        ResourceLocation tail = vanilla.get(RNG.nextInt(1, vanilla.size()));
        while (!vanilla.isEmpty()) {
            ResourceLocation key = vanilla.removeFirst();
            ResourceLocation value = vanilla.isEmpty() ? tail : RandomizerUtil.getRandom(vanilla, RNG);
            biConsumer.accept(key, value);
        }
    }

    private void putItem(ResourceLocation vanilla, ResourceLocation random) {
        if (RandomizationMapData.isInvalid(vanilla) || RandomizationMapData.isInvalid(random)) {
            LOGGER.warn("Invalid mapping: [{}:{}]", (Object)vanilla, (Object)random);
            return;
        }
        this.ITEM_MAP.put((Object)vanilla, (Object)random);
        this.ITEM_MAP_REVERSE.put((Object)random, (Object)vanilla);
    }

    private void putTag(ResourceLocation vanilla, ResourceLocation random) {
        if (RandomizationMapData.isInvalid(vanilla) || RandomizationMapData.isInvalid(random)) {
            throw new IllegalArgumentException("Tags cannot be air!");
        }
        this.TAGKEY_MAP.put((Object)vanilla, (Object)random);
        this.TAGKEY_MAP_REVERSE.put((Object)random, (Object)vanilla);
    }

    public ItemStack getStackFor(ItemStack stack) {
        return this.getStackFor(stack.getItem(), stack.getCount());
    }

    public ItemStack getStackFor(Item vanilla, int count) {
        Item randomItem = this.getItemFor(vanilla);
        if (randomItem == Items.AIR || count < 1) {
            return new ItemStack((ItemLike)vanilla, Math.max(count, 1));
        }
        ItemStack random = new ItemStack((ItemLike)randomItem);
        random.setCount(Math.min(random.getMaxStackSize(), count));
        return random;
    }

    public Item getItemFor(Item item) {
        ResourceLocation vanilla = Objects.requireNonNull(ITEM_REGISTRY.getKey((Object)item));
        ResourceLocation random = this.getItemFor(vanilla);
        return ITEM_REGISTRY.get(random).map(Holder::get).orElseGet(() -> {
            LOGGER.warn("failed to get item for {}", (Object)item);
            return item;
        });
    }

    public ResourceLocation getItemFor(ResourceLocation vanilla) {
        if (RandomizationMapData.isInvalid(vanilla)) {
            throw new IllegalArgumentException("Cannot randomize Air!");
        }
        if (!this.ITEM_MAP.containsKey((Object)vanilla)) {
            LOGGER.warn("Item '{}' is not mapped to a random item!", (Object)vanilla);
            return vanilla;
        }
        return (ResourceLocation)this.ITEM_MAP.get((Object)vanilla);
    }

    public ResourceLocation getOriginalItem(ResourceLocation random) {
        return (ResourceLocation)this.ITEM_MAP_REVERSE.get((Object)random);
    }

    public TagKey<Item> getOriginalTagKey(TagKey<Item> random) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.getOriginalTagKey(random.location()));
    }

    public ResourceLocation getOriginalTagKey(ResourceLocation random) {
        return (ResourceLocation)this.TAGKEY_MAP_REVERSE.get((Object)random);
    }

    public TagKey<Item> getTagKeyFor(TagKey<Item> vanilla) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.getTagKeyFor(vanilla.location()));
    }

    public ResourceLocation getTagKeyFor(ResourceLocation vanilla) {
        return (ResourceLocation)this.TAGKEY_MAP.get((Object)vanilla);
    }

    @Nullable
    public TagKey<Item> getRandomTag(Random rng) {
        int s = rng.nextInt(this.TAGKEY_MAP.size());
        int i = 0;
        for (ResourceLocation value : this.TAGKEY_MAP.values()) {
            if (i++ != s) continue;
            return TagKey.create((ResourceKey)ITEM_REGISTRY.key(), (ResourceLocation)value);
        }
        return null;
    }

    @Nullable
    public Item getRandomItem(Random rng) {
        int s = rng.nextInt(this.ITEM_MAP.size());
        int i = 0;
        for (ResourceLocation value : this.ITEM_MAP.values()) {
            if (i++ != s) continue;
            return (Item)((Holder.Reference)ITEM_REGISTRY.get(value).orElseThrow()).get();
        }
        return null;
    }

    public Set<ResourceLocation> getItems() {
        return this.ITEM_MAP.keySet();
    }

    public Set<ResourceLocation> getTags() {
        return this.TAGKEY_MAP.keySet();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    private static void logDifference(Set<ResourceLocation> difference) {
        if (difference.isEmpty()) {
            return;
        }
        LOGGER.warn("Not all keys were associated with a random item/tag!");
        LOGGER.warn("Missed keys: {}", difference);
    }

    private static void logMatchingKey(ResourceLocation l) {
        LOGGER.warn("The key '{}' has been mapped to itself!", (Object)l);
    }

    private static class DefaultedMapData
    extends RandomizationMapData {
        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public ItemStack getStackFor(Item vanilla, int count) {
            return new ItemStack((ItemLike)vanilla, count);
        }

        @Override
        public ItemStack getStackFor(ItemStack stack) {
            return stack;
        }

        @Override
        public Item getItemFor(Item item) {
            return item;
        }

        @Override
        public ResourceLocation getItemFor(ResourceLocation vanilla) {
            return vanilla;
        }

        @Override
        public ResourceLocation getOriginalItem(ResourceLocation random) {
            return random;
        }

        @Override
        public ResourceLocation getOriginalTagKey(ResourceLocation random) {
            return random;
        }

        @Override
        public TagKey<Item> getTagKeyFor(TagKey<Item> vanilla) {
            return vanilla;
        }

        @Override
        public TagKey<Item> getRandomTag(Random rng) {
            return null;
        }

        @Override
        public Item getRandomItem(Random rng) {
            return null;
        }
    }
}

