/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class RandomizerConfig {
    public static int itemCooldown;
    public static boolean pointsCarryover;
    public static boolean giveMultipleItems;
    public static int cycleBase;
    public static boolean randomizeRecipes;
    public static boolean randomizeRecipeInputs;
    public static boolean giveRandomItems;
    public static boolean generateStructures;
    public static int structureProbability;
    public static boolean randomizeLoot;
    public static boolean randomizeBlockLoot;
    public static boolean randomizeEntityLoot;
    public static boolean randomizeChestLoot;
    public static boolean randomizeMobs;
    public static boolean randomizeMobAttributes;
    public static boolean randomizeVillagerTrades;
    public static boolean ensureCompletability;
    public static boolean enableDebug;

    public static void update() {
        itemCooldown = (Integer)Holder.itemCooldown.get();
        pointsCarryover = (Boolean)Holder.pointsCarryover.get();
        giveMultipleItems = (Boolean)Holder.giveMultipleItems.get();
        cycleBase = (Integer)Holder.cycleBase.get();
        randomizeRecipes = (Boolean)Holder.randomizeRecipes.get();
        randomizeRecipeInputs = (Boolean)Holder.randomizeRecipeInputs.get();
        giveRandomItems = (Boolean)Holder.giveRandomItems.get();
        generateStructures = (Boolean)Holder.generateStructures.get();
        structureProbability = (Integer)Holder.structureProbability.get();
        randomizeLoot = (Boolean)Holder.randomizeLoot.get();
        randomizeBlockLoot = (Boolean)Holder.randomizeBlockLoot.get();
        randomizeEntityLoot = (Boolean)Holder.randomizeEntityLoot.get();
        randomizeChestLoot = (Boolean)Holder.randomizeChestLoot.get();
        randomizeMobs = (Boolean)Holder.randomizeMobs.get();
        randomizeMobAttributes = (Boolean)Holder.randomizeMobAttributes.get();
        randomizeVillagerTrades = (Boolean)Holder.randomizeVillagerTrades.get();
        ensureCompletability = (Boolean)Holder.ensureCompletability.get();
        enableDebug = (Boolean)Holder.enableDebug.get();
    }

    static {
        RandomizerConfig.update();
    }

    public static class Holder {
        private static final Pair<Holder, ForgeConfigSpec> RandomizerConfigPair = new ForgeConfigSpec.Builder().configure(Holder::new);
        public static ForgeConfigSpec.IntValue itemCooldown;
        public static ForgeConfigSpec.BooleanValue pointsCarryover;
        public static ForgeConfigSpec.BooleanValue giveMultipleItems;
        public static ForgeConfigSpec.IntValue cycleBase;
        public static ForgeConfigSpec.BooleanValue randomizeRecipes;
        public static ForgeConfigSpec.BooleanValue randomizeRecipeInputs;
        public static ForgeConfigSpec.BooleanValue giveRandomItems;
        public static ForgeConfigSpec.BooleanValue generateStructures;
        public static ForgeConfigSpec.IntValue structureProbability;
        public static ForgeConfigSpec.BooleanValue randomizeLoot;
        public static ForgeConfigSpec.BooleanValue randomizeBlockLoot;
        public static ForgeConfigSpec.BooleanValue randomizeEntityLoot;
        public static ForgeConfigSpec.BooleanValue randomizeChestLoot;
        public static ForgeConfigSpec.BooleanValue randomizeMobs;
        public static ForgeConfigSpec.BooleanValue randomizeMobAttributes;
        public static ForgeConfigSpec.BooleanValue randomizeVillagerTrades;
        public static ForgeConfigSpec.BooleanValue ensureCompletability;
        public static ForgeConfigSpec.BooleanValue enableDebug;

        public Holder(ForgeConfigSpec.Builder builder) {
            builder.push("Item Randomizer");
            giveRandomItems = builder.comment("Should random items be given to the player? Defaults to true.").define("give_random_items", true);
            itemCooldown = builder.comment("Time between items given (measured in ticks, 20 ticks is one second). Default value is 800.").defineInRange("item_cooldown", 800, 1, Integer.MAX_VALUE);
            pointsCarryover = builder.comment("Should unused points carry over after a cycle? : Default value is false.").define("points_carryover", false);
            giveMultipleItems = builder.comment("Should the randomizer attempt to give the player more items if there are still points to use. Defaults to false.").define("give_multiple_items", false);
            cycleBase = builder.comment("Amount of cycles needed to reach the first point max increment. Default value is 10.").defineInRange("cycle_base", 10, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Recipe Randomizer");
            randomizeRecipes = builder.comment("Should recipes be randomized? Defaults to true.").define("randomize_recipes", true);
            randomizeRecipeInputs = builder.comment("Should recipe inputs also be randomized? This also attempts to change advancements for unlocking recipes. Defaults to true.").define("randomize_recipe_inputs", true);
            ensureCompletability = builder.comment("Ensures that Ender Eyes have at least one crafting recipe and the game is completable. Defaults to false.").define("force_completable", false);
            builder.pop();
            builder.push("Structure Randomizer");
            generateStructures = builder.comment("Should random structures be generated when able? Defaults to true.").worldRestart().define("generate_structures", true);
            structureProbability = builder.comment("Percent chance of how likely structure generation is picked over item generation. Defaults to 10.").defineInRange("structure_probability", 10, 0, 100);
            builder.pop();
            builder.push("Loot Randomizer");
            randomizeLoot = builder.comment("Should Loot Tables (block drops, entity drops, chest loot) be randomized? Defaults to true.").define("randomize_loot", true);
            randomizeBlockLoot = builder.comment("Should block drops be randomized? Defaults to true.").define("randomize_block_loot", true);
            randomizeEntityLoot = builder.comment("Should mob drops be randomized? Defaults to true.").define("randomize_entity_loot", true);
            randomizeChestLoot = builder.comment("Should chest loot be randomized? Defaults to true.").define("randomize_chest_loot", true);
            builder.pop();
            builder.push("Mob Randomizer");
            randomizeMobs = builder.comment("Should mobs be randomized when spawning? Attempts to mimic vanilla spawning logic and checks. Ignores spawn egss. Defaults to false.").define("randomize_mobs", false);
            randomizeMobAttributes = builder.comment("Should the attributes of mobs be randomized when spawned? Defaults to false.").define("randomize_attributes", false);
            randomizeVillagerTrades = builder.comment("Should villager trades give random output item stacks? Defaults to true.").define("randomize_trades", true);
            builder.pop();
            builder.push("Miscellaneous");
            enableDebug = builder.comment("Enable verbose logging").define("enable_debug", false);
            builder.pop();
        }

        public static IConfigSpec<?> getSpec() {
            return (IConfigSpec)RandomizerConfigPair.getRight();
        }
    }
}

