/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.CompletabilityVerifier;
import com.ghzdude.randomizer.ItemRandomizer;
import com.ghzdude.randomizer.MobRandomizer;
import com.ghzdude.randomizer.RandomizationMapData;
import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RecipeRandomizer;
import com.ghzdude.randomizer.loot.LootRandomizer;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="randomizer")
public class RandomizerCore {
    public static final String MODID = "randomizer";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Random seededRNG;
    public static Random unseededRNG;
    public static boolean serverStarted;
    private static DynamicOps<JsonElement> OPS;

    public RandomizerCore(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, RandomizerConfig.Holder.getSpec());
        MobSpawnEvent.FinalizeSpawn.BUS.addListener(MobRandomizer::randomizeSpawn);
        ServerStartingEvent.BUS.addListener(event -> {
            MinecraftServer server = event.getServer();
            OPS = server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            seededRNG = new Random(server.getWorldData().worldGenOptions().seed());
            unseededRNG = new Random();
        });
        TickEvent.PlayerTickEvent.Pre.BUS.addListener(ItemRandomizer::playerTickPre);
        ServerStartedEvent.BUS.addListener(RandomizerCore::onStart);
        ServerStoppingEvent.BUS.addListener(RandomizerCore::onStop);
        AddReloadListenerEvent.BUS.addListener(event -> event.addListener((PreparableReloadListener)RandomizerCore.simple(RecipeRandomizer::reload)));
    }

    static void onStart(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        RandomizationMapData.init((RegistryAccess)server.registryAccess());
        ItemRandomizer.init(server);
        RecipeRandomizer.init(server);
        LootRandomizer.init(server);
        MobRandomizer.init((RegistryAccess)server.registryAccess());
        RandomizerUtil.init((RegistryAccess)server.registryAccess());
        if (RandomizerConfig.ensureCompletability) {
            CompletabilityVerifier.init(server);
            CompletabilityVerifier.ensureCompletability();
        }
        RandomizerConfig.update();
        serverStarted = true;
    }

    static void onStop(ServerStoppingEvent event) {
        RandomizerUtil.dispose();
        LootRandomizer.dispose();
        CompletabilityVerifier.dispose();
        OPS = null;
        serverStarted = false;
    }

    public static Optional<DynamicOps<JsonElement>> getOps() {
        return Optional.ofNullable(OPS);
    }

    private static ResourceManagerReloadListener simple(Runnable runnable) {
        return m -> runnable.run();
    }

    static {
        serverStarted = false;
    }
}

