/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.RandomizationMapData;
import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.api.AdvancementModify;
import com.ghzdude.randomizer.api.Randomizable;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RecipeRandomizer {
    private static final Map<ResourceLocation, List<ResourceLocation>> MODIFIED = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, Set<JsonElement>> CACHED_RECIPES = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, ResourceLocation> RESULT_MAP = new Object2ObjectOpenHashMap();
    public static final Map<ResourceLocation, List<ResourceLocation>> OUTPUT_MAP = new Object2ObjectOpenHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static RandomizationMapData INSTANCE = null;
    private static Registry<Item> ITEM_REGISTRY;
    private static Runnable onReload;
    private static boolean init;
    private static ResourceLocation activeRecipe;

    static void init(MinecraftServer server) {
        if (RandomizerConfig.randomizeRecipes) {
            if (init) {
                return;
            }
            ITEM_REGISTRY = server.registryAccess().lookupOrThrow(Registries.ITEM);
            INSTANCE = RandomizationMapData.get(server, "recipes");
            onReload = () -> {
                RecipeManager manager = server.getRecipeManager();
                if (!(manager instanceof Randomizable)) {
                    return;
                }
                Randomizable randomizable = (Randomizable)manager;
                if (RandomizerConfig.randomizeRecipes) {
                    LOGGER.warn("Recipe Randomizer Running!");
                    randomizable.randomizer$randomize();
                    manager.finalizeRecipeLoading(server.getWorldData().enabledFeatures());
                    if (RandomizerConfig.randomizeRecipeInputs) {
                        RecipeRandomizer.setAdvancements(server.getAdvancements());
                    }
                }
            };
            onReload.run();
            init = true;
        }
    }

    static void reload() {
        if (init) {
            onReload.run();
        }
    }

    public static void dispose() {
        MODIFIED.clear();
        CACHED_RECIPES.clear();
        OUTPUT_MAP.clear();
        RESULT_MAP.clear();
        init = false;
    }

    public static RandomizationMapData getMapData() {
        if (RandomizerConfig.randomizeRecipes && INSTANCE != null) {
            return INSTANCE;
        }
        return RandomizationMapData.VANILLA;
    }

    public static List<ResourceLocation> getRecipesForItem(Item item) {
        return RecipeRandomizer.getRecipesFor(ITEM_REGISTRY.getKey((Object)item));
    }

    public static List<ResourceLocation> getRecipesForTag(TagKey<Item> tagKey) {
        return RecipeRandomizer.getRecipesFor(tagKey.location());
    }

    public static List<ResourceLocation> getRecipesFor(ResourceLocation location) {
        return OUTPUT_MAP.getOrDefault(location, Collections.emptyList());
    }

    public static Set<JsonElement> getIngredients(ResourceLocation recipe) {
        return CACHED_RECIPES.getOrDefault(recipe, Collections.emptySet());
    }

    public static void setAdvancements(ServerAdvancementManager manager) {
        if (manager instanceof AdvancementModify) {
            AdvancementModify modify = (AdvancementModify)manager;
            LOGGER.warn("Modifying advancements!");
            modify.randomizer$randomizeRecipeAdvancements();
        }
    }

    public static RecipeMap randomizeRecipeMap(RecipeMap original) {
        if (!RandomizerConfig.randomizeRecipes) {
            return original;
        }
        return RandomizerCore.getOps().map(ops -> {
            ArrayList randomized = new ArrayList(original.values().size());
            for (RecipeHolder recipeHolder : original.values()) {
                randomized.add(RecipeRandomizer.randomizeRecipe(recipeHolder, (DynamicOps<JsonElement>)ops));
            }
            activeRecipe = null;
            return RecipeMap.create(randomized);
        }).orElse(original);
    }

    private static RecipeHolder<Recipe<?>> randomizeRecipe(RecipeHolder<Recipe<?>> recipeHolder, DynamicOps<JsonElement> ops) {
        DataResult encoded = Recipe.CODEC.encodeStart(ops, (Object)recipeHolder.value());
        activeRecipe = recipeHolder.id().location();
        return encoded.map(JsonElement::getAsJsonObject).ifError(e -> RecipeRandomizer.error(recipeHolder, e.message())).map(recipe -> RecipeRandomizer.handleRecipe(recipe, ops)).map(object -> Recipe.CODEC.decode(ops, object).ifError(e -> RecipeRandomizer.error(recipeHolder, e.message()))).result().filter(DataResult::isSuccess).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).map(Pair::getFirst).map(r -> new RecipeHolder(recipeHolder.id(), r)).orElse(recipeHolder);
    }

    private static void error(RecipeHolder<?> recipeHolder, String message) {
        LOGGER.debug("failed to randomize: {}", (Object)recipeHolder.id());
        LOGGER.debug(message);
    }

    private static JsonObject handleRecipe(JsonObject recipe, DynamicOps<JsonElement> ops) {
        if (RandomizerConfig.randomizeRecipeInputs) {
            if (RecipeRandomizer.isType(recipe, "minecraft:crafting_shaped")) {
                inputs = recipe.getAsJsonObject("key");
                Set.copyOf(inputs.keySet()).forEach(key -> inputs.add(key, RecipeRandomizer.randomizeOutput(inputs.get(key))));
            } else if (RecipeRandomizer.isType(recipe, "minecraft:crafting_shapeless")) {
                inputs = recipe.getAsJsonArray("ingredients");
                JsonArray randomized = new JsonArray();
                inputs.asList().stream().map(RecipeRandomizer::randomizeOutput).forEach(arg_0 -> ((JsonArray)randomized).add(arg_0));
                recipe.add("ingredients", (JsonElement)randomized);
            } else if (recipe.has("ingredient")) {
                RecipeRandomizer.modifyOutput(recipe, "ingredient");
            } else if (RecipeRandomizer.isType(recipe, "minecraft:crafting_transmute")) {
                RecipeRandomizer.modifyOutput(recipe, "input");
            } else if (RecipeRandomizer.isType(recipe, "minecraft:smithing_trim") || RecipeRandomizer.isType(recipe, "minecraft:smithing_transform")) {
                RecipeRandomizer.modifyOutput(recipe, "template");
                RecipeRandomizer.modifyOutput(recipe, "base");
                RecipeRandomizer.modifyOutput(recipe, "addition");
            } else {
                LOGGER.debug("unhandled object: {}", (Object)recipe);
            }
        }
        if (recipe.has("result")) {
            JsonObject result = recipe.getAsJsonObject("result");
            ItemStack.CODEC.decode(ops, (Object)result).ifError(e -> LOGGER.debug("failed to decode \"{}\"\n{}", (Object)result, (Object)e.message())).result().map(Pair::getFirst).map(vanilla -> {
                if (vanilla.is(Items.ENDER_EYE) && RandomizerConfig.ensureCompletability) {
                    return vanilla;
                }
                ItemStack stack = RecipeRandomizer.getMapData().getStackFor((ItemStack)vanilla);
                RESULT_MAP.put(activeRecipe, ITEM_REGISTRY.getKey((Object)stack.getItem()));
                return stack;
            }).flatMap(stack -> ItemStack.CODEC.encodeStart(ops, stack).ifError(e -> LOGGER.debug("failed to encode \"{}\"\n{}", stack, (Object)e.message())).result()).ifPresent(element -> recipe.add("result", element));
        }
        return recipe;
    }

    private static void modifyOutput(JsonObject recipe, String key) {
        recipe.add(key, RecipeRandomizer.randomizeOutput(recipe.get(key)));
    }

    private static JsonElement randomizeOutput(JsonElement output) {
        CACHED_RECIPES.computeIfAbsent(activeRecipe, k -> new ObjectOpenHashSet(9)).add(output);
        if (output.isJsonArray()) {
            JsonArray inner = new JsonArray();
            output.getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(ResourceLocation::tryParse).map(RecipeRandomizer.getMapData()::getItemFor).map(loc -> {
                RecipeRandomizer.addToMap(activeRecipe, loc);
                return loc.toString();
            }).forEach(arg_0 -> ((JsonArray)inner).add(arg_0));
            return inner;
        }
        String vanilla = output.getAsString();
        if (vanilla.startsWith("#")) {
            ResourceLocation location = ResourceLocation.parse((String)vanilla.substring(1));
            RecipeRandomizer.addToMap(activeRecipe, location);
            return new JsonPrimitive("#" + RecipeRandomizer.getMapData().getTagKeyFor(location).toString());
        }
        ResourceLocation location = ResourceLocation.parse((String)vanilla);
        RecipeRandomizer.addToMap(activeRecipe, location);
        return new JsonPrimitive(RecipeRandomizer.getMapData().getItemFor(location).toString());
    }

    private static boolean isType(JsonObject recipe, String type) {
        return recipe.get("type").getAsString().equals(type);
    }

    public static void addToMap(@NotNull ResourceLocation recipe, @NotNull ResourceLocation ingredient) {
        MODIFIED.computeIfAbsent(ingredient, key -> new ArrayList()).add(recipe);
    }

    public static void buildAdvancements(ImmutableMap.Builder<ResourceLocation, AdvancementHolder> map) {
        for (ResourceLocation ing : MODIFIED.keySet()) {
            Item[] changedItems;
            Optional item = ITEM_REGISTRY.getOptional(ing);
            Optional<TagKey> tag = ITEM_REGISTRY.getTags().map(HolderSet.Named::key).filter(key -> key.location().equals((Object)ing)).findFirst();
            if (item.isPresent()) {
                changedItems = new Item[]{(Item)item.get()};
            } else if (tag.isPresent()) {
                changedItems = (Item[])((HolderSet.Named)ITEM_REGISTRY.get(tag.get()).orElseThrow()).stream().map(Holder::get).toArray(Item[]::new);
            } else {
                LOGGER.warn("{} is not a valid item or tag!", (Object)ing);
                continue;
            }
            Advancement.Builder builder = new Advancement.Builder();
            AdvancementRewards.Builder rewards = new AdvancementRewards.Builder();
            for (ResourceLocation recipe : MODIFIED.get(ing)) {
                rewards.addRecipe(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipe));
            }
            builder.rewards(rewards);
            builder.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])changedItems));
            String path = "%s-%s_gives_recipes".formatted(ing.getNamespace(), ing.getPath());
            AdvancementHolder toAdd = builder.build(RandomizerUtil.location(path));
            map.put((Object)toAdd.id(), (Object)toAdd);
        }
    }

    public static Set<ResourceLocation> getKnownRecipes() {
        return RESULT_MAP.keySet();
    }

    public static ResourceLocation getResultFor(ResourceLocation recipe) {
        return RESULT_MAP.get(recipe);
    }

    static {
        onReload = () -> {};
        init = false;
    }
}

