/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer;

import com.ghzdude.randomizer.ItemRandomizer;
import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.io.ConfigIO;
import com.ghzdude.randomizer.special.SpecialFeatures;
import com.ghzdude.randomizer.special.structure.SpecialStructures;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.slf4j.Logger;

public class StructureRandomizer {
    private static List<ResourceLocation> BLACKLISTED_STRUCTURES = null;
    private static final Object2IntMap<ResourceLocation> VALID_STRUCTURES = new Object2IntOpenHashMap();
    private static final List<ResourceLocation> STRUCTURES = new ArrayList<ResourceLocation>();
    private static List<ResourceLocation> BLACKLISTED_FEATURES = null;
    private static final Object2IntMap<ResourceLocation> VALID_FEATURES = new Object2IntOpenHashMap();
    private static final List<ResourceLocation> FEATURES = new ArrayList<ResourceLocation>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Registry<Structure> STRUCTURE_REGISTRY;
    private static Registry<ConfiguredFeature<?, ?>> FEATURE_REGISTRY;

    public static void init(RegistryAccess access) {
        STRUCTURE_REGISTRY = access.lookupOrThrow(Registries.STRUCTURE);
        FEATURE_REGISTRY = access.lookupOrThrow(Registries.CONFIGURED_FEATURE);
        if (BLACKLISTED_STRUCTURES == null) {
            BLACKLISTED_STRUCTURES = ConfigIO.read("blacklisted_structures", List.of(ResourceLocation.parse((String)"namespace:structure_name_here")), STRUCTURE_REGISTRY);
        }
        if (VALID_STRUCTURES.isEmpty()) {
            ConfigIO.readValues("structures", SpecialStructures.CONFIGURED_STRUCTURES, STRUCTURE_REGISTRY).object2IntEntrySet().forEach(StructureRandomizer::putValidStructure);
        }
        for (ResourceLocation structure : STRUCTURE_REGISTRY.keySet()) {
            StructureRandomizer.putValidStructure(structure, 1);
        }
        STRUCTURES.addAll((Collection<ResourceLocation>)VALID_STRUCTURES.keySet());
        if (BLACKLISTED_FEATURES == null) {
            BLACKLISTED_FEATURES = ConfigIO.read("blacklisted_features", SpecialFeatures.BLACKLISTED_FEATURES, FEATURE_REGISTRY);
        }
        if (VALID_FEATURES.isEmpty()) {
            ConfigIO.readValues("features", SpecialFeatures.DEFAULT_FEATURES, FEATURE_REGISTRY).object2IntEntrySet().forEach(StructureRandomizer::putValidFeature);
        }
        for (ResourceLocation loc : FEATURE_REGISTRY.keySet()) {
            StructureRandomizer.putValidFeature(loc, 1);
        }
        FEATURES.addAll((Collection<ResourceLocation>)VALID_FEATURES.keySet());
    }

    private static void putValidStructure(Map.Entry<ResourceLocation, Integer> entry) {
        if (entry instanceof Object2IntMap.Entry) {
            Object2IntMap.Entry intEntry = (Object2IntMap.Entry)entry;
            StructureRandomizer.putValidStructure(entry.getKey(), intEntry.getIntValue());
        } else {
            StructureRandomizer.putValidStructure(entry.getKey(), entry.getValue());
        }
    }

    private static void putValidStructure(ResourceLocation structure, int value) {
        if (BLACKLISTED_STRUCTURES.contains(structure) || VALID_STRUCTURES.containsKey((Object)structure)) {
            return;
        }
        VALID_STRUCTURES.put((Object)structure, value);
    }

    private static void putValidFeature(Map.Entry<ResourceLocation, Integer> entry) {
        if (entry instanceof Object2IntMap.Entry) {
            Object2IntMap.Entry intEntry = (Object2IntMap.Entry)entry;
            StructureRandomizer.putValidFeature(entry.getKey(), intEntry.getIntValue());
        } else {
            StructureRandomizer.putValidFeature(entry.getKey(), entry.getValue());
        }
    }

    private static void putValidFeature(ResourceLocation feature, int value) {
        if (BLACKLISTED_FEATURES.contains(feature) || VALID_FEATURES.containsKey((Object)feature)) {
            return;
        }
        VALID_FEATURES.put((Object)feature, value);
    }

    public static int tryPlace(int pointsToUse, ServerLevel level, ServerPlayer player) {
        return RandomizerCore.seededRNG.nextInt(10) == 0 ? StructureRandomizer.placeStructure(pointsToUse, level, player) : StructureRandomizer.placeFeature(pointsToUse, level, player);
    }

    private static int placeStructure(int pointsToUse, ServerLevel level, ServerPlayer player) {
        if (pointsToUse < 1) {
            return pointsToUse;
        }
        ResourceLocation structure = StructureRandomizer.selectStructure(pointsToUse);
        BlockPos target = StructureRandomizer.getPos(player, level, 128);
        LOGGER.warn("Attempting to generate structure \"{}\"", (Object)structure);
        if (!StructureRandomizer.tryPlaceStructure(level, structure, target)) {
            LOGGER.warn("Failed to place structure \"{}\"", (Object)structure);
            if (RandomizerConfig.giveRandomItems) {
                pointsToUse -= ItemRandomizer.giveRandomItem(pointsToUse, player.getInventory());
            }
            return pointsToUse;
        }
        LOGGER.warn("Placed \"{}\" at [{}X, {}Y, {}Z]", new Object[]{structure, target.getX(), target.getY(), target.getZ()});
        return pointsToUse - VALID_STRUCTURES.getInt((Object)structure);
    }

    private static int placeFeature(int pointsToUse, ServerLevel level, ServerPlayer player) {
        ResourceLocation feature;
        while (VALID_FEATURES.getInt((Object)(feature = RandomizerUtil.getRandom(FEATURES))) > pointsToUse) {
        }
        if (!StructureRandomizer.tryPlaceFeature(level, feature, StructureRandomizer.getPos(player, level, 48))) {
            LOGGER.warn("Failed to place feature \"{}\"", (Object)feature);
            if (RandomizerConfig.giveRandomItems) {
                pointsToUse -= ItemRandomizer.giveRandomItem(pointsToUse, player.getInventory());
            }
            return pointsToUse;
        }
        return pointsToUse - VALID_FEATURES.getInt((Object)feature);
    }

    private static ResourceLocation selectStructure(int points) {
        ResourceLocation structure;
        while (VALID_STRUCTURES.getInt((Object)(structure = RandomizerUtil.getRandom(STRUCTURES))) > points) {
        }
        return structure;
    }

    private static BlockPos getPos(ServerPlayer player, ServerLevel level, int upperBound) {
        int offsetX = level.getRandom().nextIntBetweenInclusive(upperBound / 4, upperBound);
        int offsetZ = level.getRandom().nextIntBetweenInclusive(upperBound / 4, upperBound);
        switch (level.getRandom().nextInt(4)) {
            case 1: {
                offsetX = -offsetX;
                break;
            }
            case 2: {
                offsetZ = -offsetZ;
                break;
            }
            case 3: {
                offsetX = -offsetX;
                offsetZ = -offsetZ;
            }
        }
        return player.getOnPos().offset(offsetX, 1, offsetZ);
    }

    private static boolean tryPlaceStructure(ServerLevel serverLevel, ResourceLocation resourceKey, BlockPos blockPos) {
        Structure structure = RandomizerUtil.getOrThrow(STRUCTURE_REGISTRY, resourceKey);
        ChunkGenerator chunkgenerator = serverLevel.getChunkSource().getGenerator();
        StructureStart structurestart = structure.generate(STRUCTURE_REGISTRY.wrapAsHolder((Object)structure), serverLevel.dimension(), serverLevel.registryAccess(), chunkgenerator, chunkgenerator.getBiomeSource(), serverLevel.getChunkSource().randomState(), serverLevel.getStructureManager(), serverLevel.getSeed(), new ChunkPos(blockPos), 0, (LevelHeightAccessor)serverLevel, biomes -> true);
        if (!structurestart.isValid()) {
            return false;
        }
        BoundingBox boundingbox = structurestart.getBoundingBox();
        ChunkPos minpos = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingbox.minX()), SectionPos.blockToSectionCoord((int)boundingbox.minZ()));
        ChunkPos maxpos = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingbox.maxX()), SectionPos.blockToSectionCoord((int)boundingbox.maxZ()));
        List toCheck = ChunkPos.rangeClosed((ChunkPos)minpos, (ChunkPos)maxpos).toList();
        for (ChunkPos chunkPos : toCheck) {
            BoundingBox bb = new BoundingBox(chunkPos.getMinBlockX(), serverLevel.getMinY(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), serverLevel.getMaxY(), chunkPos.getMaxBlockZ());
            structurestart.placeInChunk((WorldGenLevel)serverLevel, serverLevel.structureManager(), chunkgenerator, serverLevel.getRandom(), bb, chunkPos);
        }
        return true;
    }

    private static boolean tryPlaceFeature(ServerLevel serverLevel, ResourceLocation location, BlockPos blockPos) {
        ConfiguredFeature<?, ?> feature = RandomizerUtil.getOrThrow(FEATURE_REGISTRY, location);
        LOGGER.warn("Placing feature \"{}\"", (Object)location);
        Optional optional = BlockPos.findClosestMatch((BlockPos)blockPos, (int)8, (int)32, StructureRandomizer.featurePredicate(serverLevel, feature));
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos pos = (BlockPos)optional.get();
        LOGGER.warn("Feature \"{}\" placed at [{}X, {}Y, {}Z]", new Object[]{location, pos.getX(), pos.getY(), pos.getZ()});
        return true;
    }

    private static Predicate<BlockPos> featurePredicate(ServerLevel level, ConfiguredFeature<?, ?> feature) {
        return pos -> feature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), level.getRandom(), pos);
    }
}

