/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.compat.jei;

import com.ghzdude.randomizer.compat.jei.ParsedLootTable;
import com.ghzdude.randomizer.util.RandomizerUtil;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootTableCategory
implements IRecipeCategory<ParsedLootTable> {
    public static final ResourceLocation UID = RandomizerUtil.location("block_drop_category");
    public static final IRecipeType<ParsedLootTable> TYPE = IRecipeType.create((ResourceLocation)UID, ParsedLootTable.class);
    private final IDrawable ICON;
    private final Component TITLE = Component.translatable((String)"randomizer.compat.jei.block_drop_category");
    private final IGuiHelper helper;

    public LootTableCategory(IGuiHelper helper) {
        this.helper = helper;
        this.ICON = helper.createDrawableItemLike((ItemLike)Items.GRASS_BLOCK);
    }

    @NotNull
    public IRecipeType<ParsedLootTable> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.TITLE;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.ICON;
    }

    public int getWidth() {
        return 166;
    }

    public int getHeight() {
        return 94;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ParsedLootTable recipe, @NotNull IFocusGroup focusGroup) {
        int startX = this.getWidth() / 2;
        int starty = 1;
        builder.addSlot(RecipeIngredientRole.INPUT, startX - 20, starty).setStandardSlotBackground().add(recipe.input());
        starty += 20;
        int maxSlots = 36;
        boolean willFit = recipe.drops().size() <= maxSlots;
        startX = 1;
        List<ItemStack> drops = recipe.drops();
        for (int i = 0; i < maxSlots; ++i) {
            ItemStack drop = i < drops.size() ? drops.get(i) : ItemStack.EMPTY;
            int row = i / 9;
            int col = i % 9;
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.OUTPUT, startX + 18 * col, starty + 18 * row).setStandardSlotBackground();
            if (i + 1 == maxSlots && !willFit) {
                List<Component> lines = RandomizerUtil.getOrCreateLines(drop);
                lines.add((Component)Component.translatable((String)"randomizer.compat.jei.block_drop.cannot_fit").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}));
                drop.set(DataComponents.LORE, (Object)new ItemLore(lines));
                slot.add(drop);
                break;
            }
            if (drop.isEmpty()) continue;
            slot.add(drop);
        }
    }

    public void draw(@NotNull ParsedLootTable recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.helper.getRecipeArrow().draw(guiGraphics, this.getWidth() / 2 - 2, 1);
    }
}

