/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.compat.jei;

import com.ghzdude.randomizer.RandomizerConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record ParsedLootTable(ItemStack input, List<ItemStack> drops, ResourceLocation lootTable) {
    private static final Map<ResourceLocation, ParsedLootTable> REGISTRY = new Object2ObjectOpenHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void registerRecipe(ItemStack input, List<ItemStack> drops, @NotNull ResourceLocation table) {
        ParsedLootTable existing = REGISTRY.put(table, new ParsedLootTable(input, drops, Objects.requireNonNull(table)));
        if (existing != null && RandomizerConfig.enableDebug) {
            LOGGER.debug("Parsed Loot Table '{}' was replaced!", (Object)existing.lootTable());
        }
    }

    public static void clearRegistry() {
        REGISTRY.clear();
    }

    public static List<ParsedLootTable> getRecipes() {
        return ImmutableList.copyOf(REGISTRY.values());
    }

    public static List<ResourceLocation> getKeys() {
        return ImmutableList.copyOf(REGISTRY.keySet());
    }

    @Nullable
    public static ParsedLootTable get(ResourceLocation location) {
        return REGISTRY.get(location);
    }

    public static enum Type {
        HAND("Hand"),
        PICK("Pick"),
        SHOVEL("Shovel"),
        AXE("Axe"),
        SILK("Silk Touch"),
        SHEARS("Shears"),
        SHEARS_OR_SILK("Silk or Shears");

        private final String name;
        private final String lower;

        private Type(String name) {
            this.name = name;
            this.lower = name.toLowerCase().replace(' ', '_');
        }

        public Component getName() {
            return Component.translatable((String)("randomizer.compat.jei.block_drop.type." + this.lower));
        }

        public String toString() {
            return "Type{%s}".formatted(this.name);
        }
    }
}

