/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ConfigIO {
    private static final Path CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("randomizer");
    private static final Path BLACKLIST_DIR = CONFIG_DIR.resolve("blacklists");
    private static final Path VALUE_DIR = CONFIG_DIR.resolve("values");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String JSON_FILE = "%s.json";

    public static void writeListToFile(File file, List<ResourceLocation> list) {
        JsonArray stringArray = new JsonArray();
        list.forEach(loc -> stringArray.add(loc.toString()));
        ConfigIO.tryWriteJson((JsonElement)stringArray, file);
    }

    public static void writeValues(File valueFile, Object2IntMap<ResourceLocation> valueMap) {
        JsonObject map = new JsonObject();
        for (ResourceLocation location : valueMap.keySet()) {
            map.addProperty(location.toString(), (Number)valueMap.getInt((Object)location));
        }
        ConfigIO.tryWriteJson((JsonElement)map, valueFile);
    }

    private static void tryWriteJson(JsonElement toWrite, File file) {
        try {
            if (file.canWrite() || file.createNewFile()) {
                BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);
                GSON.toJson(toWrite, (Appendable)writer);
                ((Writer)writer).close();
            }
        }
        catch (IOException | NullPointerException e) {
            LOGGER.warn("Failure to write JSON at {}", (Object)file);
        }
    }

    public static <T> Object2IntMap<ResourceLocation> readValues(String file, Object2IntMap<ResourceLocation> defaults, Registry<T> registry) {
        Object2IntArrayMap map = new Object2IntArrayMap();
        File valueFile = VALUE_DIR.resolve(JSON_FILE.formatted(file)).toFile();
        if (!valueFile.exists() && (valueFile.getParentFile().exists() || valueFile.getParentFile().mkdirs())) {
            ConfigIO.writeValues(valueFile, defaults);
            return defaults;
        }
        try {
            JsonObject object = JsonParser.parseString((String)Files.readString(valueFile.toPath())).getAsJsonObject();
            for (String vanilla : object.keySet()) {
                ResourceLocation loc = ResourceLocation.parse((String)vanilla);
                int i = object.get(vanilla).getAsInt();
                if (registry.containsKey(loc)) {
                    map.put((Object)loc, i);
                    continue;
                }
                LOGGER.warn("Value \"{}\" does not exist in {} or is invalid!", (Object)loc, (Object)registry.key());
            }
        }
        catch (IOException e) {
            ConfigIO.readFail(valueFile);
        }
        return map;
    }

    public static List<ResourceLocation> read(@NotNull String file, @NotNull @NotNull List<@NotNull ResourceLocation> defaults, @Nullable Registry<?> registry) {
        ArrayList<ResourceLocation> blacklist = new ArrayList<ResourceLocation>();
        File blacklistFile = ConfigIO.createFileName(file);
        try {
            if (blacklistFile.createNewFile()) {
                ConfigIO.writeListToFile(blacklistFile, defaults);
                return defaults;
            }
            JsonArray elements = JsonParser.parseString((String)Files.readString(blacklistFile.toPath())).getAsJsonArray();
            for (JsonElement vanilla : elements) {
                ResourceLocation location = ResourceLocation.parse((String)vanilla.getAsString());
                if (registry == null || registry.containsKey(location)) {
                    blacklist.add(location);
                    continue;
                }
                LOGGER.warn("Location {} is not valid!", (Object)location);
            }
        }
        catch (IOException | NullPointerException e) {
            ConfigIO.readFail(blacklistFile);
            ConfigIO.writeListToFile(blacklistFile, defaults);
            return defaults;
        }
        return blacklist;
    }

    private static File createFileName(String file) {
        if (Files.exists(BLACKLIST_DIR, new LinkOption[0]) || BLACKLIST_DIR.toFile().mkdirs()) {
            file = file.toLowerCase(Locale.ROOT).replace(" ", "");
            return BLACKLIST_DIR.resolve(JSON_FILE.formatted(file)).toFile();
        }
        throw new IllegalStateException("Failed to make file for \"%s\" in \"%s\"".formatted(file, BLACKLIST_DIR));
    }

    private static void readFail(File file) {
        LOGGER.warn("Failure to read JSON at '{}'! Overwriting with defaults!", (Object)file.getAbsolutePath());
    }
}

