/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.loot;

import com.ghzdude.randomizer.RandomizationMapData;
import com.ghzdude.randomizer.RandomizerConfig;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.compat.jei.ParsedLootTable;
import com.ghzdude.randomizer.special.item.SpecialItems;
import com.ghzdude.randomizer.util.RandomizerUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TwistingVinesPlantBlock;
import net.minecraft.world.level.block.WeepingVinesPlantBlock;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LootRandomizer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MATCH_TOOL = "match_tool";
    public static final String CAN_TOOL_PERFORM_ACTION = "can_tool_perform_action";
    public static final String INVERTED = "inverted";
    private static RandomizationMapData INSTANCE = null;
    public static HolderLookup.RegistryLookup<LootTable> LOOT_REGISTRY;
    public static Registry<Item> ITEM_REGISTRY;
    public static Registry<Block> BLOCK_REGISTRY;
    private static final ObjectOpenHashSet<ResourceLocation> TABLES;
    private static final Object2ObjectMap<ResourceLocation, ResourceLocation> BLOCK_MAP;
    private static final Object2ObjectMap<ResourceLocation, Set<LootData>> LOOT_MAP;
    private static final Map<ResourceLocation, Map<ResourceLocation, ResourceLocation>> SPECIAL_MAP;
    private static final Map<ResourceLocation, ResourceLocation> ENTITY_EGG_MAP;
    public static ResourceLocation activeLocation;
    private static final Set<ResourceLocation> PICKAXE_MINABLE;
    private static final Set<ResourceLocation> SHOVEL_MINABLE;
    private static final Set<ResourceLocation> REQUIRES_STONE;
    private static final Set<ResourceLocation> REQUIRES_IRON;
    private static final Set<ResourceLocation> REQUIRES_DIAMOND;
    private static RecipeManager RECIPE_MANAGER;
    private static RegistryAccess ACCESS;
    private static boolean appliesToAll;
    private static boolean requiresPick;
    private static boolean requiresShovel;
    private static boolean requiresSilk;
    private static boolean requiresShears;

    public static void init(MinecraftServer server) {
        INSTANCE = RandomizationMapData.get(server, "loot");
        ACCESS = server.registryAccess();
        LOOT_REGISTRY = server.reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE);
        ITEM_REGISTRY = ACCESS.lookupOrThrow(Registries.ITEM);
        BLOCK_REGISTRY = ACCESS.lookupOrThrow(Registries.BLOCK);
        RECIPE_MANAGER = server.getRecipeManager();
        TagKey pickaxeMineable = BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mineable/pickaxe"));
        TagKey shovelMineable = BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mineable/shovel"));
        TagKey needsStone = BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_stone_tool"));
        TagKey needsIron = BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"));
        TagKey needsDiamond = BlockTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_diamond_tool"));
        LootRandomizer.collectFromTag((TagKey<Block>)pickaxeMineable, PICKAXE_MINABLE);
        LootRandomizer.collectFromTag((TagKey<Block>)shovelMineable, SHOVEL_MINABLE);
        LootRandomizer.collectFromTag((TagKey<Block>)needsStone, REQUIRES_STONE);
        LootRandomizer.collectFromTag((TagKey<Block>)needsIron, REQUIRES_IRON);
        LootRandomizer.collectFromTag((TagKey<Block>)needsDiamond, REQUIRES_DIAMOND);
        for (Block block : BLOCK_REGISTRY) {
            if (block == Blocks.AIR) continue;
            Optional lootTable = block.getLootTable();
            if (lootTable.isEmpty()) {
                if (!RandomizerConfig.enableDebug) continue;
                LOGGER.debug("Block {} has no loot table", (Object)block);
                continue;
            }
            BLOCK_MAP.put((Object)((ResourceKey)lootTable.get()).location(), (Object)BLOCK_REGISTRY.getKey((Object)block));
        }
        for (EntityType type : server.registryAccess().lookupOrThrow(Registries.ENTITY_TYPE)) {
            SpawnEggItem egg = SpawnEggItem.byId((EntityType)type);
            if (egg == null) continue;
            type.getDefaultLootTable().map(ResourceKey::location).ifPresent(key -> ENTITY_EGG_MAP.put((ResourceLocation)key, ITEM_REGISTRY.getKey((Object)egg)));
        }
        Optional<DynamicOps<JsonElement>> registryOps = RandomizerCore.getOps();
        if (registryOps.isEmpty()) {
            return;
        }
        DynamicOps<JsonElement> ops = registryOps.get();
        LOGGER.info("Iterating through loot tables!");
        List lootTables = LOOT_REGISTRY.listElements().toList();
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Found {} loot tables", (Object)lootTables.size());
        }
        for (Holder.Reference table : lootTables) {
            LootTable.DIRECT_CODEC.encodeStart(ops, (Object)((LootTable)table.get())).ifError(e -> LOGGER.debug("error encoding table: {}", (Object)e.message())).result().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).ifPresent(LootRandomizer::handleJson);
        }
        activeLocation = null;
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("loot map size: {}", (Object)LOOT_MAP.size());
        }
        for (Holder.Reference table : LOOT_MAP.keySet()) {
            ItemStack inputStack;
            Set lootData = (Set)LOOT_MAP.get((Object)table);
            if (LootRandomizer.isChestLoot((ResourceLocation)table)) {
                inputStack = new ItemStack((ItemLike)Items.CHEST);
            } else if (LootRandomizer.isEntityDrop((ResourceLocation)table)) {
                Optional egg = ITEM_REGISTRY.get(Objects.requireNonNull(LootRandomizer.getEggForEntityTable((ResourceLocation)table)));
                inputStack = egg.map(ItemStack::new).orElse(ItemStack.EMPTY);
            } else if (table.getPath().startsWith("gameplay/fishing")) {
                inputStack = new ItemStack((ItemLike)Items.FISHING_ROD);
            } else if (table.getPath().startsWith("spawners")) {
                inputStack = new ItemStack((ItemLike)Items.SPAWNER);
            } else if (table.getPath().startsWith("gameplay/hero")) {
                inputStack = new ItemStack((ItemLike)Items.EMERALD);
            } else if (LootRandomizer.isBlock((ResourceLocation)table)) {
                Item blockItem = LootRandomizer.getItemFromBlock(LootRandomizer.getBlockFor((ResourceLocation)table));
                if (blockItem == null) continue;
                inputStack = new ItemStack((ItemLike)blockItem);
            } else if (table.getPath().startsWith("dispensers/")) {
                inputStack = new ItemStack((ItemLike)Items.DISPENSER);
            } else if (table.getPath().startsWith("pots/")) {
                inputStack = new ItemStack((ItemLike)Items.DECORATED_POT);
            } else if (table.getPath().startsWith("archaeology/")) {
                inputStack = new ItemStack((ItemLike)Items.BRUSH);
            } else if (table.getPath().equals("gameplay/piglin_bartering")) {
                inputStack = new ItemStack((ItemLike)Items.GOLD_INGOT);
            } else if (table.getPath().equals("gameplay/cat_morning_gift")) {
                inputStack = new ItemStack((ItemLike)Items.CAT_SPAWN_EGG);
            } else if (table.getPath().equals("gameplay/sniffer_digging")) {
                inputStack = new ItemStack((ItemLike)Items.SNIFFER_SPAWN_EGG);
            } else if (table.getPath().startsWith("shearing/")) {
                inputStack = new ItemStack((ItemLike)Items.SHEARS);
            } else if (table.getPath().equals("gameplay/panda_sneeze")) {
                inputStack = new ItemStack((ItemLike)Items.PANDA_SPAWN_EGG);
            } else if (table.getPath().equals("gameplay/chicken_lay")) {
                inputStack = new ItemStack((ItemLike)Items.EGG);
            } else {
                if (!RandomizerConfig.enableDebug) continue;
                LOGGER.debug("Unhandled Table: '{}'", (Object)table);
                continue;
            }
            if (inputStack.isEmpty()) {
                LOGGER.warn("Input cannot be air for table '{}'!", (Object)table);
                return;
            }
            List<Component> lines = RandomizerUtil.getOrCreateLines(inputStack);
            lines.add((Component)Component.translatable((String)"randomizer.compat.jei.table.id", (Object[])new Object[]{table}).withStyle(ChatFormatting.DARK_GRAY));
            inputStack.set(DataComponents.LORE, (Object)new ItemLore(lines));
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (LootData data : lootData) {
                ParsedLootTable.Type type = data.getType();
                LootRandomizer.expandData(data).map(arg_0 -> ITEM_REGISTRY.get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(Holder::get).map(Item::getDefaultInstance).filter(stack -> !stack.isEmpty()).forEach(arg_0 -> LootRandomizer.lambda$init$3((ResourceLocation)table, data, type, drops, arg_0));
            }
            if (drops.isEmpty()) continue;
            ParsedLootTable.registerRecipe(inputStack, drops, (ResourceLocation)table);
        }
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Parsed {} loot tables", (Object)ParsedLootTable.getKeys().size());
        }
    }

    private static void configureOutputStack(ResourceLocation table, LootData data, ItemStack stack, ParsedLootTable.Type type) {
        ArrayList<Object> additional = new ArrayList<Object>();
        if (LootRandomizer.isBlock(table)) {
            additional.add(type.getName());
        }
        if (data.silk() && data.shears()) {
            additional.add(ParsedLootTable.Type.SHEARS_OR_SILK.getName());
        } else if (data.silk()) {
            additional.add(ParsedLootTable.Type.SILK.getName());
        } else if (data.shears()) {
            additional.add(ParsedLootTable.Type.SHEARS.getName());
        }
        if (SpecialItems.EFFECT_ITEMS.contains(stack.getItem())) {
            additional.add(Component.literal((String)"May have random effects!"));
        }
        if (SpecialItems.ENCHANTABLE.contains(stack.getItem())) {
            additional.add(Component.literal((String)"May have random enchantments!"));
        }
        if (!additional.isEmpty()) {
            List<Component> existing = RandomizerUtil.getOrCreateLines(stack);
            existing.addAll(additional);
            stack.set(DataComponents.LORE, (Object)new ItemLore(existing));
        }
    }

    @Nullable
    private static Item getItemFromBlock(ResourceLocation block) {
        Block block2 = (Block)((Holder.Reference)BLOCK_REGISTRY.get(block).orElseThrow()).get();
        Objects.requireNonNull(block2);
        Block block3 = block2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CandleCakeBlock.class, AttachedStemBlock.class, WeepingVinesPlantBlock.class, KelpPlantBlock.class, TwistingVinesPlantBlock.class, CaveVinesPlantBlock.class, FlowerPotBlock.class, BambooSaplingBlock.class, TallSeagrassBlock.class}, (Object)block3, n)) {
            case 0 -> {
                CandleCakeBlock candleCakeBlock = (CandleCakeBlock)block3;
                DataResult result = CandleCakeBlock.CODEC.encoder().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)candleCakeBlock);
                if (result.isError()) {
                    yield null;
                }
                yield result.result().map(JsonElement::getAsJsonObject).map(object -> object.get("candle").getAsString()).map(ResourceLocation::parse).map(arg_0 -> ITEM_REGISTRY.get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(Holder::get).orElse(null);
            }
            case 1 -> {
                AttachedStemBlock stemBlock = (AttachedStemBlock)block3;
                DataResult result = AttachedStemBlock.CODEC.encoder().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stemBlock);
                if (result.isError()) {
                    yield null;
                }
                yield result.result().map(JsonElement::getAsJsonObject).map(object -> object.get("seed").getAsString()).map(ResourceLocation::parse).map(arg_0 -> ITEM_REGISTRY.get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(Holder::get).orElse(null);
            }
            case 2 -> {
                WeepingVinesPlantBlock ignored = (WeepingVinesPlantBlock)block3;
                yield Blocks.WEEPING_VINES.asItem();
            }
            case 3 -> {
                KelpPlantBlock ignored = (KelpPlantBlock)block3;
                yield Blocks.KELP.asItem();
            }
            case 4 -> {
                TwistingVinesPlantBlock ignored = (TwistingVinesPlantBlock)block3;
                yield Blocks.TWISTING_VINES.asItem();
            }
            case 5 -> {
                CaveVinesPlantBlock ignored = (CaveVinesPlantBlock)block3;
                yield Blocks.CAVE_VINES.asItem();
            }
            case 6 -> {
                FlowerPotBlock flowerPotBlock = (FlowerPotBlock)block3;
                yield flowerPotBlock.getEmptyPot().asItem();
            }
            case 7 -> {
                BambooSaplingBlock ignored = (BambooSaplingBlock)block3;
                yield Blocks.BAMBOO.asItem();
            }
            case 8 -> {
                TallSeagrassBlock ignored = (TallSeagrassBlock)block3;
                yield Blocks.SEAGRASS.asItem();
            }
            default -> Optional.of((Block)((Holder.Reference)BLOCK_REGISTRY.get(block).orElseThrow()).value()).map(Block::asItem).orElse(null);
        };
    }

    public static boolean hasTable(ResourceLocation table) {
        return LOOT_MAP.containsKey((Object)table);
    }

    public static Set<ResourceLocation> getItems(ResourceLocation table) {
        return ((Set)LOOT_MAP.get((Object)table)).stream().flatMap(LootRandomizer::expandData).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    public static ResourceLocation getEggForEntityTable(ResourceLocation table) {
        if (!ENTITY_EGG_MAP.containsKey(table) && table.getPath().startsWith("entities/sheep/")) {
            return ITEM_REGISTRY.getKey((Object)Items.SHEEP_SPAWN_EGG);
        }
        return ENTITY_EGG_MAP.get(table);
    }

    private static Stream<ResourceLocation> expandData(LootData data) {
        if (data.tag()) {
            return ITEM_REGISTRY.get(data.makeTagKey()).map(holders -> holders.stream().map(Holder::get).map(arg_0 -> ITEM_REGISTRY.getKey(arg_0))).orElseThrow();
        }
        if (data.reference()) {
            return LootRandomizer.getItems(data.location()).stream();
        }
        return Stream.of(data.location());
    }

    public static Set<ResourceLocation> getDrops(ResourceLocation table) {
        return ((Set)LOOT_MAP.get((Object)table)).stream().map(LootData::location).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<ResourceLocation> getKnownTables() {
        return ImmutableSet.copyOf((Collection)LOOT_MAP.keySet());
    }

    @Nullable
    public static ResourceLocation getBlockFor(ResourceLocation table) {
        if (BLOCK_MAP.containsKey((Object)table)) {
            return (ResourceLocation)BLOCK_MAP.get((Object)table);
        }
        LOGGER.warn("Table '{}' is not a block table!", (Object)table);
        return null;
    }

    public static void registerSpecialDrop(ResourceLocation table, ResourceLocation drop, ResourceLocation replace) {
        ParsedLootTable parsedLootTable = ParsedLootTable.get(table);
        if (parsedLootTable == null) {
            LOGGER.warn("Parsed LootTable \"{}\" does not exist!", (Object)table);
            return;
        }
        SPECIAL_MAP.computeIfAbsent(table, k -> new Object2ObjectOpenHashMap()).put(drop, replace);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (LootData data : (Set)LOOT_MAP.get((Object)table)) {
            ParsedLootTable.Type type = data.getType();
            LootRandomizer.expandData(data).map(l -> drop.equals(l) ? replace : l).map(arg_0 -> ITEM_REGISTRY.get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(Holder::get).map(Item::getDefaultInstance).filter(stack -> !stack.isEmpty()).forEach(stack -> {
                LootRandomizer.configureOutputStack(table, data, stack, type);
                drops.add((ItemStack)stack);
            });
        }
        if (!drops.isEmpty()) {
            ParsedLootTable.registerRecipe(parsedLootTable.input(), drops, parsedLootTable.lootTable());
        }
    }

    private static void collectFromTag(TagKey<Block> key, Set<ResourceLocation> collection) {
        BLOCK_REGISTRY.get(key).ifPresent(blocks -> blocks.stream().map(holder -> BLOCK_REGISTRY.getKey((Object)((Block)holder.get()))).forEach(collection::add));
    }

    private static void handleJson(JsonObject table) {
        if (!table.has("random_sequence") || !table.has("pools")) {
            return;
        }
        ResourceLocation id = activeLocation = ResourceLocation.parse((String)table.get("random_sequence").getAsString());
        appliesToAll = false;
        if (!LootRandomizer.isBlacklisted(id)) {
            TABLES.add((Object)id);
        }
        Set items = (Set)LOOT_MAP.computeIfAbsent((Object)id, k -> new ObjectOpenHashSet());
        requiresPick = LootRandomizer.isBlock(id) && PICKAXE_MINABLE.contains(BLOCK_MAP.get((Object)id));
        requiresShovel = LootRandomizer.isBlock(id) && SHOVEL_MINABLE.contains(BLOCK_MAP.get((Object)id));
        LootRandomizer.handleJsonRaw(table, items);
    }

    private static void handleJsonRaw(JsonObject table, Set<LootData> items) {
        if (!table.has("pools")) {
            return;
        }
        if (!appliesToAll) {
            requiresShears = false;
            requiresSilk = false;
        }
        List<JsonObject> pools = table.getAsJsonArray("pools").asList().stream().map(JsonElement::getAsJsonObject).toList();
        for (JsonObject pool : pools) {
            List<JsonObject> entries = pool.getAsJsonArray("entries").asList().stream().map(JsonElement::getAsJsonObject).toList();
            if (pool.has("conditions") && !appliesToAll) {
                requiresSilk = LootRandomizer.handleConditions(pool, MATCH_TOOL, LootRandomizer::handleMatchTool);
                requiresShears = LootRandomizer.handleConditions(pool, CAN_TOOL_PERFORM_ACTION, LootRandomizer::handleShears);
                appliesToAll = requiresSilk || requiresShears;
            }
            for (JsonObject entry : entries) {
                LootRandomizer.handleEntry(entry, items);
            }
        }
    }

    private static void handleEntry(JsonObject entry, Set<LootData> items) {
        if (LootRandomizer.isType(entry, "alternatives")) {
            LootRandomizer.handleAlternatives(entry, items);
        } else if (LootRandomizer.isType(entry, "item")) {
            LootRandomizer.handleItem(entry, items);
        } else if (!LootRandomizer.isType(entry, "empty")) {
            if (LootRandomizer.isType(entry, "loot_table")) {
                JsonElement value = entry.get("value");
                if (value.isJsonObject()) {
                    LootRandomizer.handleJsonRaw(value.getAsJsonObject(), items);
                } else {
                    ResourceLocation reference = ResourceLocation.parse((String)value.getAsString());
                    LootRandomizer.addEntry(LootData.table(reference), items);
                }
            } else if (LootRandomizer.isType(entry, "dynamic")) {
                ResourceLocation name = LootRandomizer.getName(entry);
                List<ResourceLocation> list = ITEM_REGISTRY.getTags().filter(named -> named.key().location().getPath().contains(name.getPath())).flatMap(HolderSet.ListBacked::stream).map(holder -> ITEM_REGISTRY.getKey((Object)((Item)holder.get()))).toList();
                for (ResourceLocation item : list) {
                    LootRandomizer.addEntry(LootData.standard(LootRandomizer.getRandomized(item)), items);
                }
            } else if (LootRandomizer.isType(entry, "tag")) {
                ResourceLocation vanilla = LootRandomizer.getName(entry);
                ResourceLocation randomized = LootRandomizer.getRandomized(vanilla);
                LootRandomizer.addEntry(LootData.tag(randomized), items);
            } else if (RandomizerConfig.enableDebug) {
                LOGGER.debug("unhandled entry: {}", (Object)entry);
            }
        }
    }

    private static void addEntry(LootData data, Set<LootData> items) {
        items.add(data);
    }

    private static ResourceLocation getName(JsonObject entry) {
        if (entry.has("name")) {
            return ResourceLocation.parse((String)entry.get("name").getAsString());
        }
        throw new IllegalArgumentException(String.format("Cannot get item from Entry '%s'", entry));
    }

    private static boolean isType(JsonObject object, String type) {
        if (!object.has("type")) {
            return false;
        }
        return object.get("type").getAsString().contains(type);
    }

    private static boolean isCondition(JsonObject object, String type) {
        if (!object.has("condition")) {
            return false;
        }
        return object.get("condition").getAsString().contains(type);
    }

    private static void handleAlternatives(JsonObject entry, Set<LootData> items) {
        List<JsonObject> children = entry.getAsJsonArray("children").asList().stream().map(JsonElement::getAsJsonObject).toList();
        for (JsonObject child : children) {
            LootRandomizer.handleEntry(child, items);
        }
    }

    private static void handleItem(JsonObject entry, Set<LootData> items) {
        ResourceLocation vanilla = LootRandomizer.getName(entry);
        ResourceLocation random = LootRandomizer.getRandomized(vanilla);
        LootData data = LootData.standard(random).pick(requiresPick).shovel(requiresShovel);
        if (!appliesToAll) {
            requiresSilk = LootRandomizer.handleConditions(entry, MATCH_TOOL, LootRandomizer::handleMatchTool);
            requiresShears = LootRandomizer.handleConditions(entry, CAN_TOOL_PERFORM_ACTION, LootRandomizer::handleShears);
            if (entry.has("functions")) {
                List<JsonObject> functions = entry.getAsJsonArray("functions").asList().stream().map(JsonElement::getAsJsonObject).toList();
                for (JsonObject function : functions) {
                    Optional<ResourceLocation> location = LootRandomizer.canSmelt(function, vanilla);
                    if (!location.isPresent()) continue;
                    LootRandomizer.addEntry(LootData.standard(LootRandomizer.getRandomized(location.get())).smelt(true), items);
                    break;
                }
            }
        }
        LootRandomizer.addEntry(data.silk(requiresSilk).shears(requiresShears), items);
    }

    private static ResourceLocation getRandomized(ResourceLocation vanilla) {
        RandomizationMapData mapData = LootRandomizer.getMapData(activeLocation);
        if (mapData.getItems().contains(vanilla)) {
            return mapData.getItemFor(vanilla);
        }
        if (mapData.getTags().contains(vanilla)) {
            return mapData.getTagKeyFor(vanilla);
        }
        LOGGER.warn("'{}' must be an item or tag!", (Object)vanilla);
        return vanilla;
    }

    private static boolean hasCondition(JsonObject object, String type) {
        if (!object.has("conditions")) {
            return false;
        }
        List<JsonObject> conditions = object.getAsJsonArray("conditions").asList().stream().map(JsonElement::getAsJsonObject).toList();
        for (JsonObject condition : conditions) {
            if (!LootRandomizer.isCondition(condition, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean handleConditions(JsonObject object, String type, Predicate<JsonObject> predicate) {
        if (!object.has("conditions")) {
            return false;
        }
        List<JsonObject> conditions = object.getAsJsonArray("conditions").asList().stream().map(JsonElement::getAsJsonObject).toList();
        for (JsonObject condition : conditions) {
            if (!LootRandomizer.handleCondition(type, predicate, condition)) continue;
            return true;
        }
        return false;
    }

    private static boolean handleCondition(String type, Predicate<JsonObject> predicate, JsonObject condition) {
        if (LootRandomizer.isCondition(condition, type) && predicate.test(condition)) {
            return true;
        }
        if (LootRandomizer.isCondition(condition, "any_of")) {
            return LootRandomizer.handleTerms(type, predicate, condition.getAsJsonArray("terms"));
        }
        if (LootRandomizer.isCondition(condition, INVERTED)) {
            JsonObject term = condition.getAsJsonObject("term");
            return !LootRandomizer.handleCondition(type, predicate, term);
        }
        return false;
    }

    private static boolean handleTerms(String type, Predicate<JsonObject> predicate, JsonArray condition) {
        List<JsonObject> terms = condition.asList().stream().map(JsonElement::getAsJsonObject).toList();
        for (JsonObject term : terms) {
            if (!LootRandomizer.isCondition(term, type) || !predicate.test(term)) continue;
            return true;
        }
        return false;
    }

    private static boolean handleMatchTool(JsonObject object) {
        if (!object.has("predicate")) {
            return false;
        }
        JsonObject predicate = object.getAsJsonObject("predicate");
        if (!predicate.has("predicates")) {
            return false;
        }
        JsonObject predicates = predicate.getAsJsonObject("predicates");
        if (!predicates.has("minecraft:enchantments")) {
            return false;
        }
        return LootRandomizer.hasEnchantment(predicates, "silk_touch");
    }

    private static boolean hasEnchantment(JsonObject predicate, String enchantment) {
        return predicate.getAsJsonArray("minecraft:enchantments").asList().stream().map(JsonElement::getAsJsonObject).filter(object -> object.has("enchantments")).map(object -> object.get("enchantments").getAsString()).anyMatch(s -> s.contains(enchantment));
    }

    private static boolean handleShears(JsonObject object) {
        if (!object.has("action")) {
            return false;
        }
        return object.get("action").getAsString().contains("shears");
    }

    private static Optional<ResourceLocation> canSmelt(JsonObject function, ResourceLocation currentItem) {
        if (function.has("function") && function.get("function").getAsString().contains("furnace_smelt")) {
            List<RecipeHolder> recipes = RECIPE_MANAGER.getRecipes().stream().filter(recipeHolder -> recipeHolder.value().getType().equals((Object)RecipeType.SMELTING)).map(recipeHolder -> recipeHolder).toList();
            Optional item = ITEM_REGISTRY.get(currentItem);
            if (item.isEmpty()) {
                return Optional.empty();
            }
            ItemStack stack = new ItemStack((Holder)item.get());
            return recipes.stream().filter(holder -> ((SmeltingRecipe)holder.value()).input().test(stack)).map(holder -> RandomizerCore.getOps().flatMap(ops -> Recipe.CODEC.encodeStart(ops, (Object)holder.value()).result().map(JsonElement::getAsJsonObject).map(object -> object.get("result")).flatMap(object -> ItemStack.CODEC.decode(ops, object).result()).map(Pair::getFirst))).filter(Optional::isPresent).map(Optional::get).map(is -> Objects.requireNonNull(ITEM_REGISTRY.getKey((Object)is.getItem()))).findAny();
        }
        return Optional.empty();
    }

    public static RandomizationMapData getMapData(ResourceLocation table) {
        if (RandomizerConfig.randomizeLoot && TABLES.contains((Object)table)) {
            return INSTANCE;
        }
        return RandomizationMapData.VANILLA;
    }

    public static void dispose() {
        ParsedLootTable.clearRegistry();
        TABLES.clear();
        BLOCK_MAP.clear();
        LOOT_MAP.clear();
    }

    private static boolean isBlacklisted(ResourceLocation location) {
        return !RandomizerConfig.randomizeBlockLoot && LootRandomizer.isBlock(location) || !RandomizerConfig.randomizeEntityLoot && LootRandomizer.isEntityDrop(location) || !RandomizerConfig.randomizeChestLoot && LootRandomizer.isChestLoot(location);
    }

    public static boolean isBlock(ResourceLocation location) {
        return location.getPath().startsWith("blocks/");
    }

    public static boolean isEntityDrop(ResourceLocation location) {
        return location.getPath().startsWith("entities/");
    }

    public static boolean isChestLoot(ResourceLocation location) {
        return location.getPath().startsWith("chests/");
    }

    @NotNull
    public static ObjectArrayList<ItemStack> randomizeLoot(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation queriedLootTableId = context.getQueriedLootTableId();
        if (!TABLES.contains((Object)queriedLootTableId)) {
            return generatedLoot;
        }
        RandomizationMapData mapData = LootRandomizer.getMapData(queriedLootTableId);
        if (RandomizerConfig.enableDebug) {
            LOGGER.debug("Table '{}' is being queried, randomizing", (Object)queriedLootTableId);
        }
        Map replacementMap = SPECIAL_MAP.getOrDefault(queriedLootTableId, Collections.emptyMap());
        ObjectArrayList ret = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            if (!stack.isEmpty()) {
                Item random = mapData.getItemFor(stack.getItem());
                ResourceLocation key = ITEM_REGISTRY.getKey((Object)random);
                if (replacementMap.containsKey(key)) {
                    random = (Item)((Holder.Reference)ITEM_REGISTRY.get((ResourceLocation)replacementMap.get(key)).orElseThrow()).get();
                }
                ret.add((Object)RandomizerUtil.itemToStack(random, stack.getCount()));
                continue;
            }
            ret.add((Object)ItemStack.EMPTY);
        }
        return ret;
    }

    private static /* synthetic */ void lambda$init$3(ResourceLocation table, LootData data, ParsedLootTable.Type type, List drops, ItemStack stack) {
        LootRandomizer.configureOutputStack(table, data, stack, type);
        drops.add(stack);
    }

    static {
        TABLES = new ObjectOpenHashSet();
        BLOCK_MAP = new Object2ObjectOpenHashMap();
        LOOT_MAP = new Object2ObjectOpenHashMap();
        SPECIAL_MAP = new Object2ObjectOpenHashMap();
        ENTITY_EGG_MAP = new Object2ObjectOpenHashMap();
        PICKAXE_MINABLE = new ObjectOpenHashSet();
        SHOVEL_MINABLE = new ObjectOpenHashSet();
        REQUIRES_STONE = new ObjectOpenHashSet();
        REQUIRES_IRON = new ObjectOpenHashSet();
        REQUIRES_DIAMOND = new ObjectOpenHashSet();
    }

    public static final class LootData {
        public static final int REQUIRES_SILK = 0;
        public static final int REQUIRES_SHEARS = 1;
        public static final int REQUIRES_SMELT = 2;
        public static final int REQUIRES_PICK = 3;
        public static final int TABLE_REFERENCE = 4;
        public static final int TAG_REFERENCE = 5;
        public static final int REQUIRES_SHOVEL = 6;
        private final ResourceLocation location;
        private final BitSet data = new BitSet();

        public static LootData standard(ResourceLocation item) {
            return new LootData(item);
        }

        public static LootData tag(ResourceLocation item) {
            return new LootData(item).tag(true);
        }

        public static LootData table(ResourceLocation item) {
            return new LootData(item).reference(true);
        }

        public LootData(@NotNull ResourceLocation location) {
            this.location = Objects.requireNonNull(location);
        }

        public boolean silk() {
            return this.data.get(0);
        }

        public boolean shears() {
            return this.data.get(1);
        }

        public boolean smelt() {
            return this.data.get(2);
        }

        public boolean pick() {
            return this.data.get(3);
        }

        public boolean shovel() {
            return this.data.get(6);
        }

        public boolean reference() {
            return this.data.get(4);
        }

        public boolean tag() {
            return this.data.get(5);
        }

        public LootData silk(boolean b) {
            this.data.set(0, b);
            return this;
        }

        public LootData shears(boolean b) {
            this.data.set(1, b);
            return this;
        }

        public LootData smelt(boolean b) {
            this.data.set(2, b);
            return this;
        }

        public LootData pick(boolean b) {
            this.data.set(3, b);
            return this;
        }

        public LootData shovel(boolean b) {
            this.data.set(6, b);
            return this;
        }

        public LootData reference(boolean b) {
            this.data.set(4, b);
            return this;
        }

        public LootData tag(boolean b) {
            this.data.set(5, b);
            return this;
        }

        public ParsedLootTable.Type getType() {
            if (!this.shovel() && !this.pick()) {
                return ParsedLootTable.Type.HAND;
            }
            return this.shovel() ? ParsedLootTable.Type.SHOVEL : ParsedLootTable.Type.PICK;
        }

        public TagKey<Item> makeTagKey() {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.location());
        }

        public ResourceLocation location() {
            return this.location;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LootData that = (LootData)obj;
            return Objects.equals(this.location, that.location) && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.data);
        }

        public String toString() {
            return "LootData[location=" + String.valueOf(this.location) + ", silk=" + this.silk() + ", shears=" + this.shears() + ", pick=" + this.pick() + ", smelt=" + this.smelt() + ", table=" + this.reference() + ", tag=" + this.tag() + "]";
        }
    }
}

