/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.special.generators;

import com.ghzdude.randomizer.RandomizerCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentGenerator {
    private static final ArrayList<Holder<Enchantment>> VALID_ENCHANTS = new ArrayList();

    public static void init(RegistryAccess access) {
        Registry enchantments = access.lookupOrThrow(Registries.ENCHANTMENT);
        enchantments.stream().map(arg_0 -> ((Registry)enchantments).wrapAsHolder(arg_0)).forEach(VALID_ENCHANTS::add);
    }

    public static boolean canEnchant(ItemStack stack) {
        return stack.is(Items.ENCHANTED_BOOK) || stack.has(DataComponents.ENCHANTABLE) && stack.getMaxStackSize() == 1;
    }

    public static void applyEnchantment(ItemStack stack) {
        Random rng = RandomizerCore.unseededRNG;
        int shouldEnchant = rng.nextInt(0, 100);
        if (shouldEnchant < 80 && !stack.is(Items.ENCHANTED_BOOK)) {
            return;
        }
        List applicable = VALID_ENCHANTS.stream().filter(arg_0 -> ((ItemStack)stack).canApplyAtEnchantingTable(arg_0)).collect(Collectors.toList());
        if (applicable.isEmpty()) {
            return;
        }
        int numOfEnchants = rng.nextInt(applicable.size()) + 1;
        for (int i = 0; i < numOfEnchants; ++i) {
            int id = rng.nextInt(applicable.size());
            Holder toApply = (Holder)applicable.remove(id);
            stack.enchant(toApply, rng.nextInt(15));
        }
    }
}

